/* Listing 6, check.c, version 2 */
#include <stdio.h>
#include <stdlib.h>

#include "check.h"	/* Listing 5 */

struct Category
   {
   const char * name;
   void (*handler)(void);
   };

static void Exit(void) 
   { exit(EXIT_FAILURE); }
static void CarryOn(void) { }

static struct Category Severity[] =
   {
   { "UNDEFINED", Exit },
   { "WARNING",	CarryOn	},
   };


void DB_Trap(	const char pred[], 
                struct Func * pFunc, 
                int sev )
   {
   FILE * errLog = stderr;

   fprintf(errLog, 
           "\n----Debug-test-failed----\n");
   fprintf(errLog, "CALL: %s %s%s\n",
	   pFunc->ret, pFunc->name, 
           pFunc->parms);
   fprintf(errLog, "FILE: %s\n", 
           pFunc->file);
   fprintf(errLog, "LINE: %s\n", 
           pFunc->line);
   fprintf(errLog, "TYPE: %s\n", 
           Severity[sev].name);
   fprintf(errLog, "TEST: %s\n", pred);
   fprintf(errLog, 
           "-------------------------\n");
   fflush(errLog);
   Severity[sev].handler();
   }

