echo off

rem   Usage:
rem   morphit in1 in2 working-dir output
rem
rem   Example:
rem      morphit c:a.tif c:b.tif d: c:out.tif
rem
rem   This will morph c:a.tif and c:b.tif
rem   and put the output in c:out.tif
rem   It will also create temporary files in
rem   d: and then delete them.

rem   Check for the right number of parameters
if "%4" == "" goto usage

warp %1 %3in1w1.tif object 10 10 90 10 90 90 10 90 1 1 0
warp %3in1w1.tif %3in1w2.tif object 10 10 90 10 90 90 10 90 1 1 0

warp %2 %3in2w1.tif object -10 -10 110 -10 110 110 -10 110 1 1 0
warp %3in2w1.tif %3in2w2.tif object -10 -10 110 -10 110 110 -10 110 1 1 0

rem Average input 1 with the second warp of input 2
rem Weight input 1 twice as much
rem Put the result in file 1.tif

mainover %1 %3in2w2.tif %3tmp1.tif average 1 1
mainover %1 %3tmp1.tif  %3tmp2.tif average 1 1
copy %3tmp2.tif %31.tif


rem Average input 2 with the second warp of input 1
rem Weight input 2 twice as much
rem Put the result in file 3.tif

mainover %2 %3in1w2.tif %3tmp1.tif average 1 1
mainover %2 %3tmp1.tif  %3tmp2.tif average 1 1
copy %3tmp2.tif %33.tif


rem Average the first warps of the two inputs
rem Put the result in file 2.tif

mainover %3in2w1.tif %3in1w1.tif %3tmp1.tif average 1 1
copy %3tmp1.tif %32.tif

del %3tmp1.tif
del %3tmp2.tif

rem Now put the images side by side
rem in the sequence: in1 1 2 3 in2

side %1 %31.tif %3tmp1.tif side
side %3tmp1.tif %32.tif %3tmp2.tif side
del %3tmp1.tif
side %3tmp2.tif %33.tif %3tmp1.tif side
side %3tmp1.tif %2 %4 side
del %3tmp1.tif
del %3tmp2.tif
del %31.tif
del %32.tif
del %33.tif
del %3in1w1.tif
del %3in1w2.tif
del %3in2w1.tif
del %3in2w2.tif

goto end

:usage
echo .
echo usage: morphit in1 in2 working-dir output
echo .
:end
