//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  STANDARD LIBRARY ROUTINES (ANSI)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#if !defined(__STDLIB_H_INCLUDED)

#define NULL    _NULL

#define EXIT_FAILURE 1          /* Code for unsuccessful termination    */
#define EXIT_SUCCESS 0          /* Code for successful termination      */

#define MB_CUR_MAX  _Mbcurmax   /* Maximum len of multibyte character   */

#define RAND_MAX 0x7fff         /* Maximum of rand()    */

#define _NATFUNCS   32

#if _MSDOS_SOURCE
#   if _MSC_VER >= 600
#       define _MAX_PATH    260         /* Max len of full pathname     */
#       define _MAX_DRIVE   3           /* Max len of drive component   */
#       define _MAX_DIR     256         /* Max len of path component    */
#       define _MAX_FNAME   256         /* Max len of file name         */
#       define _MAX_EXT     256         /* Max len of extension         */
#   else
#       define _MAX_PATH    144         /* Max len of full pathname     */
#       define _MAX_DRIVE   3           /* Max len of drive component   */
#       define _MAX_DIR     130         /* Max len of path component    */
#       define _MAX_FNAME   9           /* Max len of file name         */
#       define _MAX_EXT     5           /* Max len of extension         */
#   endif
#endif

#ifndef _DIV_T_DEFINED
typedef struct _div_t   { int quot;     int rem; }  div_t;
typedef struct _ldiv_t  { long quot;    long rem; } ldiv_t;
#define _DIV_T_DEFINED
#endif

#ifndef _SIZE_T_DEFINED
typedef _Size_t size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _WCHAR_T_DEFINED
typedef _Wchar_t wchar_t;
#define _WCHAR_T_DEFINED
#endif

#ifndef _MBSTATE_DEFINED
typedef struct {    const char far *table;  short state; } _Mbstate;
#define _MBSTATE_DEFINED
#endif

#if _OLD_SOURCE > 0

#ifndef _ONEXIT_T_DEFINED
typedef int (_CDECL * _CDECL onexit_t)();       // Return type for onexit()
#define _ONEXIT_T_DEFINED
#endif

#endif // _OLD_SOURCE > 0

extern "C" {

void    _CDECL  abort       (void);
int     _CDECL  abs         (int);
int     _CDECL  atexit      (void (_CDECL *)(void));
double  _CDECL  atof        (const char *);
int     _CDECL  atoi        (const char *);
long    _CDECL  atol        (const char *);
void *  _CDECL  bsearch     (const void *, const void *, size_t, size_t,
                            int (_CDECL *)(const void *, const void *));
void *  _CDECL  calloc      (size_t, size_t);
div_t   _CDECL  div         (int, int);
void    _CDECL  exit        (int);
void    _CDECL  free        (void *);
char *  _CDECL  getenv      (const char *);
long    _CDECL  labs        (long);
ldiv_t  _CDECL  ldiv        (long, long);
void *  _CDECL  malloc      (size_t);
int     _CDECL  mblen       (const char *, size_t);
size_t  _CDECL  mbstowcs    (wchar_t *, const char *, size_t);
int     _CDECL  mbtowc      (wchar_t *, const char *, size_t);
void    _CDECL  qsort       (void *, size_t, size_t,
                            int (_CDECL *)(const void *, const void *));
int     _CDECL  rand        (void);
void *  _CDECL  realloc     (void *, size_t);
void    _CDECL  srand       (unsigned int);
double  _CDECL  strtod      (const char *, char **);
long    _CDECL  strtol      (const char *, char **, int);
unsigned long   _CDECL  strtoul (const char *, char **, int);
int     _CDECL  system      (const char *);
size_t  _CDECL  wcstombs    (char *, const wchar_t *, size_t);
int     _CDECL  wctomb      (char *, wchar_t);

#if _POSIX1_SOURCE > 1
int     _CDECL  putenv      (const char *);
int     _CDECL  clearenv    (void);
char *  _CDECL  setenv      (const char *, const char *);
int     _CDECL  unsetenv    (const char *);
#endif

#if _OLD_SOURCE > 0
onexit_t        _CDECL  onexit  (onexit_t);
#endif

#if _MSDOS_SOURCE > 0
void    _CDECL  _makepath   (char *, char *, char *, char *, char *);
void    _CDECL  _searchenv  (char *, char *, char *);
void    _CDECL  _splitpath  (char *, char *, char *, char *, char *);
unsigned long   _CDECL  _lrotl  (unsigned long, int);
unsigned long   _CDECL  _lrotr  (unsigned long, int);
unsigned int    _CDECL  _rotl   (unsigned int, int);
unsigned int    _CDECL  _rotr   (unsigned int, int);
char *  _CDECL  ecvt        (double, int, int *, int *);
char *  _CDECL  fcvt        (double, int, int *, int *);
char *  _CDECL  gcvt        (double, int, char *);
void    _CDECL  swab        (char *, char *, int);
char *  _CDECL  itoa        (int, char *, int);
char *  _CDECL  ltoa        (long, char *, int);
char *  _CDECL  ultoa       (unsigned long, char *, int);
#endif

#if _MSDOS_SOURCE > 1
char *  _CDECL  ultor       (unsigned long, char *, int);
#endif

void    _CDECL  _exit       (int);
void    _CDECL  _exitsub    (void);
void    _CDECL  __exitsub   (void);

int     _CDECL  _Mbtowc     (wchar_t *, const char *, size_t, _Mbstate *);
int     _CDECL  _Wctomb     (char *, wchar_t, char *);

unsigned long   _CDECL  _Strtoul    (const char *, char **, int);

extern  _Mbstate        _CDECL  _Mbs_mblen, _Mbs_mbtowc;
extern  unsigned char   _CDECL  _Mbcurmax;
extern  unsigned long   _CDECL  _RandSeed;
extern  int             _CDECL  _Envc;
extern  char **         _CDECL  _Environ;

#if _MSDOS_SOURCE > 0
extern const char * _CDECL sys_errlist[];       // Error messages
extern const int _CDECL sys_nerr;               // Size of above
#endif

}

#define srand(x)    (void)(_RandSeed = (unsigned long)(x))

#define strtoul(s,e,b)  _Strtoul(s,e,b)
#define atoi(s)         (int)_Strtoul(s,NULL,10)
#define atol(s)         (long)_Strtoul(s,NULL,10)

#define mblen(s,n)      _Mbtowc(NULL,s,n,&_Mbs_mblen)
#define mbtowc(pwc,s,n) _Mbtowc(pwc,s,n,&_Mbs_mbtowc)

#if _MSDOS_SOURCE
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

#if _POSIX_SOURCE
#define environ _Environ            // Not actually required by the standard
#endif

#define __STDLIB_H_INCLUDED
#endif

