/*
 *
 * File.........: DATECL.H
 * Date.........: August 4, 1993
 * Author.......: Steve Marcus
 * Copyright....: None! Use freely.
 * Version......: 4.7  Compile w/MSC++ 7.0 or Borland C++ 3.1
 * Usage........: General purpose date conversion, arithmetic,
 *              :    comparison, and formatting class
 * Compile line.: cl /AM /W3 /Zp /D_DOS /D_XXX /Osel /Gs /c datecl4.cpp
 *              : cl /AM /W3 /Zp /D_DOS /D_XXX /Osel /Gs /c datedemo.cpp
 *              : where _XXX = { _BCC (Borland C++) or _MSC (Microsoft C++) }
 * Link line....:
 *     link /NOD /ONERROR:NOEXE datedemo date, datedemo, NUL, mlibce;
 *
 * Acknowledgements:
 *
 *     Originally inspired by Steve Marcus (CIS 72007,1233)    6/16/91
 *     Enhanced by Eric Simon (CIS 70540,1522)                 6/29/91
 *     Further Enhanced by Chris Hill (CIS 72030,2606)         7/11/91
 *     Still Further Enhanced by Hill & Simon  v3.10           8/05/91
 *
 *     "It just keeps on a 'git 'n bedder!"
 *             by Charles D. Price (CIS 70541,3651) v4.0       6/27/92
 *
 *     Sealing the memory leaks...
 *         some variable casts and string output.
 *             by Kenneth A. Argo (CIS 71241,3635) v4.1        3/10/93
 *
 *     "Yet, more improvements..."
 *             by Ly Minh Tr (CIS 70641,3127) v4.2            3/13/93
 *             ............................... v4.3            3/24/93
 *             ............................... v4.4            6/03/93
 *             ............................... v4.5            6/21/93
 *             ............................... v4.6            8/04/93
 *             ............................... v4.7            9/20/93
 *
 *    And the quest for the perfect date class continues....
 *
 *
 */
#ifndef __cplusplus
#error  Requires C++ Compiler
#endif

#ifndef DATECLS_H
#define DATECLS_H

#if defined(_BCC)
#define DOSDATE_T   dosdate_t
#elif defined(_MSC)
#define DOSDATE_T   _dosdate_t
#else
#error  Must define _BCC (for Borland C++) or _MSC (for Microsoft C++)
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <dos.h>

#define PUBLIC              // just a couple of friendly reminders!
#define MEMBER

#define ABBR_LENGTH 3

class Date
{
    public:
        //
        // TML - Put into class so we don't proliferate global names...in the
        //       tradition of the 'ios' class!
        //       Make use of the encapsulation feature of C++
        //
        const enum format_type {MDY, DAY, MONTH, FULL, EUROPEAN};
        const enum {OFF, ON};
        const enum {BUF_SIZE=40};
        const enum { NO_CENTURY  = (unsigned char) 0x02,
                     DATE_ABBR   = (unsigned char) 0x04};

    protected:
        unsigned long julian;       // see julDate();  days since 1/1/4713 B.C.
        int year;                   // see NYear4()
		unsigned char month;		// see NMonth()
        unsigned char day;          // see Day()
		unsigned char day_of_week;	// see NDOW();	1 = Sunday, ... 7 = Saturday

	private:
		static int DisplayFormat;
		static unsigned char DisplayOptions;
        static char cbuf[BUF_SIZE];     // Date::formatDate()'s buffer space

        void julian_to_mdy ();          // convert julian day to mdy
        void julian_to_wday ();         // convert julian day to day_of_week
        void mdy_to_julian ();          // convert mdy to julian day

	public:
		Date ();
        Date (long j);
        Date (int m, int d, int y);
        Date (const char * dat);
        Date (const DOSDATE_T &ds);
		Date (const Date &dt);
        virtual ~Date() {}              // Do nothing!

        operator char *( void );        // Date to character - via type casting

        Date  operator + (long i);
        Date  operator + (int i);

        Date  operator - (long i);
        Date  operator - (int i);
        long  operator - (const Date &dt);

        const Date &operator += (long i);
        const Date &operator -= (long i);

        Date  operator ++ ();               // Prefix increment
        Date  operator ++ (int);            // Postfix increment
        Date  operator -- ();               // Prefix decrement
        Date  operator -- (int);            // Postfix decrement

        int operator <  (const Date &dt);   // TML - Convert to member
        int operator <= (const Date &dt);   // functions from 'friend'
        int operator >  (const Date &dt);   // functions
        int operator >= (const Date &dt);
        int operator == (const Date &dt);
        int operator != (const Date &dt);

        friend ostream &operator << (ostream &os, const Date &dt);
        friend ostream &operator << (ostream &os, const DOSDATE_T &dt);

        const  char * formatDate(int type=DisplayFormat) const;
        static void   setFormat (int format);
        static int    setOption (int option, int action=ON);

		long  julDate() 	const;	// returns julian date
        int   DOY()         const;  // returns relative date since Jan. 1
		int   isLeapYear()	const;	// returns 1 if leap year, 0 if not

		// note that the next functions return a date struct as defined in
		// dos.h (distinct from the Date class)

        DOSDATE_T  eom()        const;  // returns last day of month in object
        DOSDATE_T  getDate()    const;  // returns a date structure


		//
		// Version 4.0 Extension to Public Interface - CDP
		//

        // These 'Set's modify the date object and actually SET it
		// They all return a reference to self (*this)

        const Date &Set();                    // Sets to current system date
        const Date &Set(long lJulian);
        const Date &Set(int nMonth, int nDay, int nYear);

        const Date &AddWeeks(int nCount = 1);  //
        const Date &AddMonths(int nCount = 1); // May also pass neg# to 
        const Date &AddYears(int nCount = 1);  // decrement

        int Day() const;        // Numeric Day of date object

        int DaysInMonth();      // Number of days in month (1..31)

        int FirstDOM() const;   // First Day Of Month  (1..7)

        const char *CDOW();     // Character Day Of Week ('Sunday'..'Saturday')
        int NDOW() const;       // (1..7)

        int WOM();              // Numeric Week Of Month  (1..6)
        int WOY();              // Numeric Week Of Year   (1..52)

        const char * CMonth();  // Character Month name
		int  NMonth() const;	// Month Number (1..12)
        Date BOM();             // First Date Of Month
        Date EOM();             // Last Date Of Month

		int  NYear4() const;	// eg. 1992
        Date BOY();             // First Date Of Year
        Date EOY();             // Last Date Of Year
};

#endif
