********************************************
* Function  : AlertVesa()
* Autor     : Jose Manuel Ortiz Ramirez
* Source    : ALERT func for VESA mode.
********************************************

#include "inkey.ch"
#include "fastgt.ch"

FUNC AlertVesa( aMensaje, aPromptMenu, cTitulo, cColor, cIcono )
local cAntColor:= setcolor()
local nCursores:= set( 16 )
local nOpcion:=0, nTecla
local aBotones, aBoton
local nAnchura, nAltura, nColumna
local i, aCoord:= {}
Local cPan

    if ( pcount() < 1 )
      RETURN ( 0 )
    endif
    if ( pcount() < 2 )
      aPromptMenu:= { " Aceptar " }
    endif
    if ( pcount() < 3 )
      cTitulo:= ""
    endif
    if ( pcount() < 4 )
      cColor:= setcolor()
    endif
    if ( pcount() < 5 )
      cIcono:= ""
    endif

    setcursor( 0 )

//
// Calcula la altura y anchura de la ventana segn las opciones y
// el mensaje ms largo.
//

    nAltura := len( aMensaje ) + 5
    nAnchura:= 0
    for i:= 1 to len( aMensaje )
      if nAnchura < len( aMensaje[i] )
        nAnchura:= len( aMensaje[i] )
      endif
    next i
    nAnchura+= 4

//
// Calcula las coordenadas de la ventana segn altura y anchura.
//

    aCoord:= Coordenadas( nAnchura, nAltura )

//
// Guarda la zona de la pantalla utilizada y crea la ventana con su icono
// si se hubiese especificado.
//

    cPan := SaveScreen( aCoord[1], aCoord[2], aCoord[3], aCoord[4] )

    @ aCoord[1], aCoord[2], aCoord[3], aCoord[4] GTWINBOX cTitulo color cColor
    ShowMsIco( cIcono, CoordX( aCoord[1]+4 )-5, CoordY( aCoord[2]+2 ) )

//
// Pone los mensajes centrados en la pantalla.
//

    setcolor( cColor )

    for i:= 1 to len( aMensaje )
      @ aCoord[1]+i+2, 39 - Len( aMensaje[ i ] ) / 2 Say aMensaje[i]
    next i


//
// Calcula las coordenadas Y de los botones.
//

    nColumna:= 0
    for i:= 1 to len( aPromptMenu )
      nColumna+= len( aPromptMenu[i] )+4
    next i

//
// Crea los botones y los introduce en un array.
//

    nColumna:= int(( maxcol()-nColumna ) /2 )
    aBotones:= {}
    aBoton:= {}
    for i:= 1 to len( aPromptMenu )
      aadd( aBotones, { aCoord[3]-1, nColumna, aPromptMenu[i] } )
      nColumna+= len( aPromptMenu[i] )+4
      @ aBotones[i,1], aBotones[i,2] GTDRAWBTN aBotones[i,3] INTO aBoton
    next i

//
// Espera de pulsacin de teclado o ratn.
//

    aBoton:= {}
    setkey( K_MOUSE_LEFT, { || aBoton:= PulsaBoton( aBotones ) } )

    while .t.
      nTecla:= Inkey( 0 )
      do case
        case ( nTecla == K_ENTER )
          GtPushBtn aBotones[1]
          nOpcion:= 1
          exit
        case ( nTecla == K_ESC )
          nOpcion:= len( aBotones )
          GtPushBtn aBotones[nOpcion]
          exit
        otherwise
          nOpcion:= 0
          for i:= 1 to len( aBotones )
            if ( ltrim( upper( aBotones[i,3] )) = upper( chr( nTecla )))
              nOpcion:= i
              exit
            endif
          next i
          if !empty( nOpcion )
            GtPushBtn aBotones[nOpcion]
            exit
          endif
      endcase
      if !empty( aBoton )
        for nOpcion:= 1 to len( aBotones )
          if aBotones[nOpcion,3] = aBoton[3]
            exit
          endif
        next nOpcion
        GtPushBtn aBoton
        exit
      endif
    end
    setkey( 451, nil )
    RestScreen( aCoord[1], aCoord[2], aCoord[3], aCoord[4], cPan )
    setcolor( cAntColor )
    setcursor( nCursores )
RETURN nOpcion






STATIC FUNC PulsaBoton( aBotones )
local nX1, nX2, nY1, nY2
local i, aDev:= {}
    for i:= 1 to len( aBotones )
      nX1:= aBotones[i,1]
      nY1:= aBotones[i,2]
      nX2:= nX1+1
      nY2:= nY1+len( aBotones[i,3] )+3
      if Marea( CoordX( nX1 ), CoordY( nY1 ), CoordX( nX2 ), CoordY( nY2 ))
        aDev:= aBotones[i]
        exit
      endif
    next i
RETURN aDev



STATIC FUNC Coordenadas( nLong, nAltura )
local nFila1, nCol1, nFila2, nCol2
    nFila1:= int(( maxrow()-nAltura ) / 2 )
    nFila2:= nFila1 + nAltura
    nCol1:= int(( maxcol()-nLong ) / 2 )-1
    nCol2:= nCol1 + nLong
RETURN { nFila1, nCol1, nFila2, nCol2 }



STATIC FUNC CoordX( nX )
RETURN ( nX * 16 )



STATIC FUNC CoordY( nY )
RETURN ( nY * 8 )



STATIC FUNC MArea( nX1, nY1, nX2, nY2 )
RETURN ( MouseX() > nY1 .and. MouseX() < nY2 .and. MouseY() > nX1 .and. MouseY() < nX2 )
