
Sub FOpenProc ()
    Dim OpenFileName As String
    
    OpenFileName = GetFilename("Open")
    If OpenFileName <> "" Then
	OpenFile (OpenFileName)
    End If
End Sub

Function GetFilename (DialogType As String)
    FileForm.Caption = DialogType
    CenterForm frmMDI, FileForm
    FileForm.Show modal

    GetFilename = FileForm!txtFileName.Text

End Function

Function IsValidFilename (fname As String) As Integer
    If Len(fname) < 13 Then
	IsValidFilename = True
    End If
End Function

Sub OpenFile (filename)
    Dim NL, TextIn, GetLine
    Dim fIndex As Integer

    NL = Chr$(13) + Chr$(10)
    
    On Error Resume Next
    ' open the selected file
    Open filename For Input As #1
    If Err Then
	MsgBox "Can't open file: " + filename
	Exit Sub
    End If
    ' change mousepointer to an hourglass
    screen.MousePointer = 11
    
    ' change form's caption and display new text
    fIndex = FindFreeIndex()
    Document(fIndex).Tag = fIndex
    Document(fIndex).Caption = UCase$(filename)
    Document(fIndex).Text1.Text = Input$(LOF(1), 1)
    FState(fIndex).Dirty = False
    Document(fIndex).Show
    Close #1
    ' reset mouse pointer
    screen.MousePointer = 0
End Sub

Sub SaveFileAs (filename)
On Error Resume Next
    Dim Contents As String

    ' open the file
    Open filename For Output As #1
    ' put contents of the notepad into a variable
    Contents = frmMDI.ActiveForm.Text1.Text
    ' display hourglass
    screen.MousePointer = 11
    ' write variable contents to saved file
    Print #1, Contents
    Close #1
    ' reset the mousepointer
    screen.MousePointer = 0
    ' set the Notepad's caption

    If Err Then
	MsgBox Error, 48, App.Title
    Else
	frmMDI.ActiveForm.Caption = UCase$(filename)
	' reset the dirty flag
	FState(frmMDI.ActiveForm.Tag).Dirty = False
    End If
End Sub

