Option Explicit

DefInt A-Z

Declare Function UnrealizeObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function GetStockObject Lib "GDI" (ByVal nIndex As Integer) As Integer
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function SetROP2 Lib "GDI" (ByVal hDC As Integer, ByVal nDrawMode As Integer) As Integer
Declare Function CreateRectRgn Lib "GDI" (ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function SelectClipRgn Lib "GDI" (ByVal hDC As Integer, ByVal hRgn As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function RestoreDC Lib "GDI" (ByVal hDC As Integer, ByVal nSavedDC As Integer) As Integer

' Binary raster ops
Global Const R2_NOTXORPEN = 10

' Stock Logical Objects
Global Const WHITE_BRUSH = 0
Global Const LTGRAY_BRUSH = 1
Global Const GRAY_BRUSH = 2
Global Const DKGRAY_BRUSH = 3
Global Const BLACK_BRUSH = 4
Global Const NULL_BRUSH = 5
Global Const HOLLOW_BRUSH = NULL_BRUSH

Declare Function GetModuleHandle Lib "Kernel" (ByVal lpModuleName As String)
Declare Function GetModuleUsage Lib "Kernel" (ByVal hModule As Integer)
Declare Function GetWindowsDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)

' Calculator declarations
Global StartX As Single
Global StartY As Single

Global Border As Single
Global TPRatio As Single
Global Bevel As Integer
Global Outline As Integer

Global OKToMove As Integer

Global PixOffsetX As Integer
Global PixOffsetY As Integer
Global PixStartX As Integer
Global PixStartY As Integer
Global PixPictX As Integer
Global PixPictY As Integer
Global PixX As Integer
Global PixY As Integer

Global RgnX1 As Integer
Global RgnY1 As Integer
Global RgnX2 As Integer
Global RgnY2 As Integer

'  Data type used by FillRect
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

'  API Functions used to create pattern brush and draw brush on form
Declare Function CreatePatternBrush Lib "GDI" (ByVal hBitmap As Integer) As Integer
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer

'  This variable keeps track of which picture shade in picShade
'  control array is being used
Global GShade As Integer

Global ViewTitle As String
Global BMPFileName As String
Global ViewCaption As Integer
Global ViewTop As Integer
Global ViewLeft As Integer
Global ViewHeight As Integer
Global ViewWidth As Integer
Global ViewAspect As Double
Global ViewBorder As Integer
Global ViewAllowResize As Integer

Declare Function SetWindowPos Lib "user" (ByVal h%, ByVal hb%, ByVal X%, ByVal Y%, ByVal cx%, ByVal cy%, ByVal f%) As Integer

Global Const SWP_NOMOVE = 2
Global Const SWP_NOSIZE = 1
Global Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Global Const HWND_TOPMOST = -1
Global Const HWND_NOTOPMOST = -2

'Note: This attribute was introduced in Windows, version 3.1, so
'remember to make a GetVersion() API call to determine whether the
'application is running under Windows, version 3.1.

Global Const PIXEL = 3
Global Const TWIP = 1

'----- WindowStates (form)
Global Const NORMAL = 0                ' 0 - Normal
Global Const MINIMIZED = 1             ' 1 - Minimized
Global Const MAXIMIZED = 2             ' 2 - Maximized

'---------------------------------------------------------
' This routine simulates the dragging behavior found in ProgMan.
' The built-in VB DragDrop routine does not handle clipping
' properly and yields poor visual results.
'
' The routine:
'   - Gets a handle to the screen (a DC of Null)
'   - Creates a rectangular region based on the X,Y of the LCD
'   - Sets the Clipping Region to that rectangle
'   - Paints a box on the screen based on the mouse X,Y
'     combined with the applets height and width.
'   - Releases the Windows resources.
'---------------------------------------------------------
'
Sub GhostForm (X As Integer, Y As Integer, h As Integer, W As Integer)
    
    Dim hScreen As Integer
    Dim hRegion As Integer
    Dim tmp As Integer
    Dim hBrush As Integer
    Dim hObjOld As Integer

    hScreen = GetDC(0)
    hRegion = CreateRectRgn(RgnX1, RgnY1, RgnX2, RgnY2)
    tmp = SelectClipRgn(hScreen, hRegion)
    hBrush = GetStockObject(NULL_BRUSH)
    hObjOld = SelectObject(hScreen, hBrush)
    tmp = SetROP2(hScreen, R2_NOTXORPEN)
    tmp = Rectangle(hScreen, X, Y, h, W)
    tmp = DeleteObject(hRegion)
    tmp = UnrealizeObject(hScreen)
    hScreen = ReleaseDC(0, hScreen)

End Sub

Sub ImageLoad ()
    
    BMPView.Image1.Picture = LoadPicture("")
    
    BMPView.Picture1.Picture = LoadPicture(BMPFileName)
    
    ViewAspect = BMPView.Picture1.Width / BMPView.Picture1.Height
    
'   BmpView.Picture1.ScaleMode = PIXEL
'   ViewTitle = "Bitmap Viewer - " & BMPFileName & " (" & Mid$(Str$(BmpView.Picture1.ScaleWidth), 2) & "x" & Mid$(Str$(BmpView.Picture1.ScaleHeight), 2) & ")"
'   ViewTitle = "Bitmap Viewer - Image size (" & Mid$(Str$(BmpView.Picture1.ScaleWidth), 2) & "x" & Mid$(Str$(BmpView.Picture1.ScaleHeight), 2) & ")"
'   BmpView.Picture1.ScaleMode = TWIP

    ViewBorder = BMPView.Width - BMPView.ScaleWidth

    If (BMPView.Caption = "") Then
        BMPView.Width = BMPView.Picture1.Width + ViewBorder
        BMPView.Height = BMPView.Picture1.Height + ViewBorder
    Else
        BMPView.Width = BMPView.Picture1.Width + ViewBorder
        BMPView.Height = BMPView.Picture1.Height + 324 + ViewBorder
    End If

    BMPView.Image1.Width = BMPView.Picture1.Width
    BMPView.Image1.Height = BMPView.Picture1.Height
    
    BMPView.Image1.Picture = BMPView.Picture1.Picture
    BMPView.Picture1.Picture = LoadPicture("")

'   If (ViewCaption = True) Then
'       BmpView.Caption = ViewTitle
'   End If
    
End Sub

Sub Main ()
    
    Dim tmp As Integer

    Screen.MousePointer = 11
    
    TPRatio = Screen.TwipsPerPixelX

    Load BMPView

    ' Determine the screen bounding region
    RgnX1 = Int(0) / TPRatio
    RgnY1 = Int(0) / TPRatio
    RgnX2 = Int(Screen.Width / TPRatio)
    RgnY2 = Int(Screen.Height / TPRatio)
    
    tmp = DoEvents()
    
    Screen.MousePointer = 0

    BMPView.Show

End Sub

Sub NotTopMost ()

    Dim success As Integer

    '----- To reset the form XXXX to NON-TOPMOST, use the following code

    success% = SetWindowPos(BMPView.hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS)
    
    ' success% <> 0 When Successful


End Sub

Sub Topmost ()
    
    Dim success As Integer
    
    '----- To set the form XXXX to TOPMOST, use the following code:

    success% = SetWindowPos(BMPView.hWnd, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)
    
    ' success% <> 0 When Successful

End Sub

