/***************************************************************************
* EXAMPL1.C
* This example demonstrates programming in the structured paradigm under
* Windows 3.0. Note the absence of the GetMessage, DispatchMessage loop.
* The program counts to 1 million in any of five different windows. The
* count moves from window to window every 2 seconds. If the user clicks
* on the button associated with any of the windows, the count resumes
* from that window. The user is requested to give an ID and password
* at the start, to demonstrate some additional functionality.
**************************************************************************/

#include <Windows.h>
#include "WinDosIO.h"


long far pascal WndProc(HWND, WORD, WORD, LONG);

short ticks;
short currentHandle;
HWND handle[5];
HWND button[5];
HWND idWindow;
HANDLE hInst;


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdline, int cmdshow)
 {
	HWND hwnd;
	WNDCLASS wc;
	short i;
	RECT r;
    	struct WINDOSIO w;
    	long l;
	MSG msg;
	char buffer[240];
	char far *p;


	/* Register Main Window Class */

	hInst = hInstance;

	if (!hPrevInstance)
	 {
	    wc.style = 0;
	    wc.lpfnWndProc = WndProc;
	    wc.cbClsExtra = 0;
	    wc.cbWndExtra = 0;
	    wc.hInstance = hInstance;
	    wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	    wc.hCursor = LoadCursor( 0, IDC_ARROW );
	    wc.hbrBackground = COLOR_WINDOW + 1;
	    wc.lpszMenuName = "Example1";
	    wc.lpszClassName = "Example1";
	    RegisterClass( &wc );
	 }


    /* Initialize terminal IO */
    WinDosIO(WD_INIT,hInstance,0);

	/* Create Main Window */
    hwnd = CreateWindow(
                "Example1",
                "Counting to a Million",
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT,
                0,
                CW_USEDEFAULT,
                0,
                0,
                0,
                hInstance,
                NULL
                );

    ShowWindow(hwnd, cmdshow);

    /* Wrap width for small windows */
    w.wrapWidth = 12;

    /* Create 5 buttons and 5 associated counting windows */
    for (i = 0; i < 5; i++)
     {
	  r.top = 130;
	  r.left = 10 + (i * 140);
	  handle[i] = CreateWindow("termIO",0,
			  WS_CHILD | WDS_NOPAGES | WDS_NOTEXTBUFFER,
 			  r.left,r.top,70,60,
			  hwnd,i+50,hInstance,(LPSTR)&w);
	  textcolor(i + 10);
	  ShowWindow(handle[i],SW_SHOW);
	  UpdateWindow(handle[i]);

	  r.top = 18;
	  r.left = 25 + (i * 140);

	  button[i] =  CreateWindow("termIO",0,
			  WS_CHILD | WDS_SELECT | WDS_NOPAGES,
 			  r.left,r.top,40,38,
			  hwnd,i,hInstance,(LPSTR)&w);
	  textcolor(i + 10);
	  ShowWindow(button[i],SW_SHOW);
	  UpdateWindow(button[i]);
	  printf("ͻ\n");
	  printf(" %d \n",i+1);
	  printf("ͼ");
	}

	/* Create ID and Password window */
	r.top = 200;
	r.left = 10;
	idWindow = CreateWindow("termIO","ID and Password",
			  WS_CHILD | WS_THICKFRAME | WS_CAPTION |
			  WDS_SELECT | WDS_NOPAGES,
			  r.left,r.top,290,100,
			  hwnd,20,hInstance,0);
	textcolor(WHITE);
	ShowWindow(idWindow,SW_SHOW);
	UpdateWindow(idWindow);

	/* Get info from user */
	printf("Enter ID ? ");
	gets(buffer);

	_setcursortype(_NOCURSOR);
	p = getpass("Enter password:");
	printf("The password is '%s'\n",p);


	_setcursortype(_SOLIDCURSOR);
	printf("Hit any key to continue\n");
	getche();

	ShowWindow(idWindow,SW_HIDE);
	UpdateWindow(idWindow);

	/* Loop through the windows while counting to a million,
	   using the timer to change windows.
	*/
	currentHandle = 4;
	WinDosIO(WD_SELECT,handle[currentHandle],0);
	SetTimer(hwnd,1,500,0);
	for (l = 0; l < 1000000L; l++)
	  if (printf("%ld\n",l) < 0) break;

	KillTimer(hwnd,1);

	while( GetMessage( &msg, 0, 0, 0 ) != 0 )
     	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
     	}

	return 0;
 }


long far pascal WndProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam)
 {
    short i;
    short nCode;

    switch( msg )
        {
	case WM_TIMER:
		if (++ticks >= 36)
		 {
			WinDosIO(WD_SELECT,handle[currentHandle],0);
			currentHandle = ++currentHandle % 5;
			ticks = 0;
		 }
		break;
	case WM_COMMAND:
		nCode = HIWORD(lParam);
		switch (nCode)
		 {
			case WDN_LBUTTON:
			  for (i = 0; i < 5; i++)
			   {
				if (wParam == i)
				 {
					currentHandle = i;
					WinDosIO(WD_SELECT,
						handle[currentHandle],0);
					ticks = 0;
					break;
				 }
			   }
		 }
		break;
	case WM_SETFOCUS:
		WinDosIO(WD_SETFOCUS,0,0);
		break;
	case WM_CLOSE:
	        WinDosIO(WD_DESTROY,hwnd,0);
		return 0;
        case WM_DESTROY:
		PostQuitMessage(0);
	        return 0;
        }

	return DefWindowProc(hwnd,msg,wParam,lParam);
}


