/***************************************************************************
* EXAMPL3.C
* This example demonstrates coroutines. They allow a sequential process
* to use windows when prompting users.
* In this case, the 'living trie' presents the user with the letters
* of the alphabet. It then returns to Windows. When a letter is selected, it is
* concatenated to the word being built up. Again the user is presented with
* the letters of the alphabet and again control returns to Windows. When
* the OK button is pressed, a letter is deleted from the end of the
* word, and control returns back to the application.
* Notice the absence of the run loop.
*****************************************************************************/

#include <Windows.h>
#include <WinDosIO.h>

#define UP_LEVEL 	1
#define SAME_LEVEL 	2
#define IDD_LISTBOX	100
#define IDD_BUTTON	101

long far pascal WndProc(HWND, WORD, WORD, LONG);
void LivingTrie(void);

HANDLE hInst;
HWND hwnd, hwndStatic, hwndListBox, hwndButton, dummyHwnd;

char word[256];
short level = 0;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdline, int cmdshow)
 {
	WNDCLASS wc;
	short i;
	MSG msg;
	char lBFill[2];

	lBFill[1] = 0;

	/* Register Main Window Class */

	hInst = hInstance;

	if (!hPrevInstance)
	 {
	    wc.style = 0;
	    wc.lpfnWndProc = WndProc;
	    wc.cbClsExtra = 0;
	    wc.cbWndExtra = 0;
	    wc.hInstance = hInstance;
	    wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	    wc.hCursor = LoadCursor( 0, IDC_ARROW );
	    wc.hbrBackground = COLOR_WINDOW + 1;
	    wc.lpszMenuName = "Example3";
	    wc.lpszClassName = "Example3";
	    RegisterClass( &wc );
	 }


    /* Initialize terminal IO */
    WinDosIO(WD_INIT,hInstance,0);

	/* Create Main Window */
    hwnd = CreateWindow(
                "Example3",
                "The Living Trie",
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT,
                0,
                CW_USEDEFAULT,
                0,
                0,
                0,
                hInstance,
                NULL
                );

    ShowWindow(hwnd, cmdshow);

   /* Create a dummy termIO window, which will not even be used. */
   dummyHwnd = CreateWindow("termIO",0,
		  WS_CHILD | WDS_NOPAGES | WDS_NOTEXTBUFFER,
		  0,0,0,0,hwnd,50,hInstance,0);
   ShowWindow(dummyHwnd,SW_HIDE);

   hwndStatic = CreateWindow("static","",WS_CHILD | WS_VISIBLE | WS_BORDER,
					 100,10,300,20,hwnd,0,hInst,0);

   hwndListBox = CreateWindow("listbox",0,WS_CHILD|WS_VISIBLE|LBS_NOTIFY |
					   WS_VSCROLL | WS_BORDER,
					  100,60,60,200,hwnd,IDD_LISTBOX,
					  hInst,0);

   /* Fill the list box with the letters of the alphabet */
   for (i = 'A'; i <= 'Z'; i++)
    {
      lBFill[0] = i;
      SendMessage(hwndListBox,LB_ADDSTRING,0,(LONG)lBFill);
    }

   hwndButton = CreateWindow("button","UP LEVEL",
			      WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			      100,280,100,40,hwnd,IDD_BUTTON,hInst,0);

   LivingTrie();

   WinDosIO(WD_DESTROY,hwnd,0);

   while( GetMessage( &msg, 0, 0, 0 ) != 0 )
     	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
     	}


   return 0;
 }



void LivingTrie(void)
 {
    short rc;
    for(;;) {
	word[level] = 0;
	SendMessage(hwndStatic,WM_SETTEXT,0,(LONG)word);
	if ((rc = ReturnToWindows()) == UP_LEVEL || rc < 0) break;
     }
 }
/*************************************************************
* 1. If user clicks on letter. Set word[level++] to letter.
*    call Living trie. Then decrement level and ReturnToApplication(SAME_LEVEL)
* 2. If user clicks on OK, call return to application(CLICKED_OK).
**************************************************************/


long far pascal WndProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam)
 {

    WORD notify = HIWORD(lParam);

    switch (msg) {
    	case WM_COMMAND:
		switch (wParam)
		 {
			case IDD_BUTTON:
			     ReturnToApplication(UP_LEVEL);
			     break;
			case IDD_LISTBOX:
			     if (notify == LBN_DBLCLK)
			       {
			    	 word[level++] = 'A' +
				   SendMessage(hwndListBox,LB_GETCURSEL,0,0);
			    	 LivingTrie();
			    	 level--;
			    	 ReturnToApplication(SAME_LEVEL);
		       	       }
		     	break;
			default:
				break;
	 	   } /* End switch wParam */
	break;
	case WM_SETFOCUS:
		WinDosIO(WD_SETFOCUS,0,0);
		break;
	case WM_CLOSE:
	        WinDosIO(WD_DESTROY,hwnd,0);
		return 0;
        case WM_DESTROY:
		PostQuitMessage(0);
	        return 0;
	} /* End switch message */
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
