// slidevw.cpp : implementation of the CSlidetstView class
//

#include "stdafx.h"
#include "slidetst.h"

#include "slidedoc.h"
#include "cslider.h"
#include "slidevw.h"
#include "range.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView

IMPLEMENT_DYNCREATE(CSlidetstView, CView)

BEGIN_MESSAGE_MAP(CSlidetstView, CView)
    //{{AFX_MSG_MAP(CSlidetstView)
    ON_WM_CREATE()
    ON_WM_DESTROY()
    ON_WM_HSCROLL()
    ON_WM_VSCROLL()
    ON_WM_CTLCOLOR()
    ON_COMMAND(IDM_SETHPOS, OnSethpos)
    ON_COMMAND(IDM_SETHRANGE, OnSethrange)
    ON_COMMAND(IDM_SETVPOS, OnSetvpos)
    ON_COMMAND(IDM_SETVRANGE, OnSetvrange)
    ON_COMMAND(IDM_ENABLEVERT, OnEnablevert)
    ON_COMMAND(IDM_ENABLEHORZ, OnEnablehorz)
    ON_COMMAND(IDM_DISABLEVERT, OnDisablevert)
    ON_COMMAND(IDM_DISABLEHORZ, OnDisablehorz)
    ON_COMMAND(IDM_SETHPOS, OnSethpos)
    ON_COMMAND(IDM_GETHRANGE, OnGethrange)
    ON_COMMAND(IDM_GETVRANGE, OnGetvrange)
    //}}AFX_MSG_MAP
    // Standard printing commands
    ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
    ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView construction/destruction

CSlidetstView::CSlidetstView()
{  

}

CSlidetstView::~CSlidetstView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView drawing

HBRUSH CSlidetstView::OnCtlColor(CDC* dc, CWnd*, UINT)
{                               
	//Paint the control grey
	dc->SetBkColor(RGB(192,192,192));    
	
	return NULL;
}


void CSlidetstView::OnDraw(CDC* pDC)
{
    CSlidetstDoc* pDoc = GetDocument();

    // TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView printing

BOOL CSlidetstView::OnPreparePrinting(CPrintInfo* pInfo)
{
    // default preparation
    return DoPreparePrinting(pInfo);
}

void CSlidetstView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
    // TODO: add extra initialization before printing
}

void CSlidetstView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
    // TODO: add cleanup after printing
}




/////////////////////////////////////////////////////////////////////////////
// CSlidetstView diagnostics

#ifdef _DEBUG
void CSlidetstView::AssertValid() const
{
    CView::AssertValid();
}

void CSlidetstView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CSlidetstDoc* CSlidetstView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSlidetstDoc)));
    return (CSlidetstDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView message handlers

int CSlidetstView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // Create a vertical slider (id hardcoded at 50)
    pVSlider=new CSlider(m_hWnd,50,
                        WS_CHILD|WS_VISIBLE|SCS_INVERTRANGE|
                        SCS_VERTICAL|SCS_TEXTHASRANGE|
                        SCS_RIGHTTICKS,
                        "1,2000,25",10,20,40,200);
 
    // Create a horizontal slider (id hardcoded at 51)
    pHSlider=new CSlider(m_hWnd,51,
                        WS_CHILD|WS_VISIBLE|SCS_INVERTRANGE|
                        SCS_HORIZONTAL|SCS_TEXTHASRANGE|
                        SCS_TOPTICKS|SCS_BOTTOMTICKS,
                        "1,2000,25",60,110,200,50); 
                        
    // Create a text window to display the current position
    RECT    r={60,20,120,44};
    
    vposWin.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,
                  r,this,12);
                  
    vposWin.ShowWindow(1);
                  
    r.top=80;
    r.bottom=104;
                
    hposWin.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,
                  r,this,13);
                  
    hposWin.ShowWindow(1);                  
    return 0;
}

void CSlidetstView::OnDestroy()
{
    CView::OnDestroy();
    
    // TODO: Add your message handler code here
    delete pVSlider;
    delete pHSlider;
}

void CSlidetstView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // See if this is the slider 
    if (pScrollBar->m_hWnd==pHSlider->m_hWnd)
    {
    
        int curPos=pHSlider->getPos(); 
        
            // This is for testing only - you only need to use nPos
            //  and would not normally call getPos to get the position
        ASSERT (curPos==(int)nPos);
        
        char szText[20];
    
        wsprintf(szText,"%d",nPos);                 
        hposWin.SetWindowText(szText);    
    }
}

void CSlidetstView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // See if this is the slider 
    if (pScrollBar->m_hWnd==pVSlider->m_hWnd)
    {
    
        int curPos=pVSlider->getPos(); 
        
            // This is for testing only - you only need to use nPos
            //  and would not normally call getPos to get the position
        ASSERT (curPos==(int)nPos);
    
            // Display the current position    
        char szText[20];
    
        wsprintf(szText,"%d",nPos);                 
        vposWin.SetWindowText(szText);    
    }
}


void CSlidetstView::OnSethrange()
{
  CRange    dlg;
  
  if (dlg.DoModal())
  {
     pHSlider->setRange(atoi(dlg.m_Low.GetBuffer(10)),
                        atoi(dlg.m_High.GetBuffer(10)));  
  }
    
}

void CSlidetstView::OnSetvpos()
{
    char    szTemp[30];           
    int     nVal;
    
    vposWin.GetWindowText(szTemp,30);
    nVal=atoi(szTemp);
    pVSlider->setPos(nVal);
}

void CSlidetstView::OnSetvrange()
{
  CRange    dlg;
     
  if (dlg.DoModal())
  {                              
     pVSlider->setRange(atoi(dlg.m_Low.GetBuffer(10)),
                        atoi(dlg.m_High.GetBuffer(10)));
  }
}

void CSlidetstView::OnSethpos()
{
    char    szTemp[30];           
    int     nVal;
    
    hposWin.GetWindowText(szTemp,30);
    nVal=atoi(szTemp);
    pHSlider->setPos(nVal);
}

void CSlidetstView::OnEnablevert()
{
   pVSlider->EnableWindow(TRUE);       
}

void CSlidetstView::OnEnablehorz()
{
   pHSlider->EnableWindow(TRUE);        
}

void CSlidetstView::OnDisablevert()
{
   pVSlider->EnableWindow(FALSE);       
}

void CSlidetstView::OnDisablehorz()
{        
   pHSlider->EnableWindow(FALSE);
}

void CSlidetstView::OnGethrange()
{
    long    lVal;
    char    szMsg[100];
        
    lVal=pHSlider->getRange();
    wsprintf(szMsg,"%d to %d",LOWORD(lVal),HIWORD(lVal));
    AfxMessageBox(szMsg);
}

void CSlidetstView::OnGetvrange()
{
    long    lVal;
    char    szMsg[100];
        
    lVal=pVSlider->getRange();
    wsprintf(szMsg,"%d to %d",LOWORD(lVal),HIWORD(lVal));
    AfxMessageBox(szMsg);
    
}
