/****************************************************************************

    PROGRAM:  alckey

    PURPOSE:  Microsoft Sample Application that demonstrates ALC_ flags
              and the ShowKeyboard API for Windows for Pens.
              
              Author:  Cynthia G. Anderson, 
                       PSS Developer Support, Windows SDK Developer Support
              Created: 9/15/92

    FUNCTIONS:

         WinMain() - calls initialization function, processes message loop
         MainWndProc() - processes messages
         About() - processes messages for "About" dialog box
         InitApplication() - initializes window data and registers window
         InitInstance() - saves instance handle and creates main window
         AlcDlgProc() - Dialog procedure for setting ALC options
         SetAlcBits() - sets bits if ALC_BITMAP selected in ALC Dialog
         
****************************************************************************/

// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//

#include "windows.h"
#include "penwin.h"
#include "string.h"
#include "math.h"
#include "stdlib.h"
#include "alckey.h"


int _pascal WinMain( HANDLE, HANDLE, LPSTR, int );
long _far _pascal MainWndProc( HWND, unsigned, WORD, LONG );
BOOL _far _pascal About( HWND, unsigned, WORD, LONG );
BOOL _far _pascal AlcDlgProc( HWND, unsigned, WORD, LONG );
static BOOL InitApplication( HANDLE );
static BOOL InitInstance( HANDLE, int );
VOID SetAlcBits (LPRC lprc, LPSTR lp);


static HANDLE hInst;
static HWND   hwnd;            /* handle to main window */
static HWND   hWndHedit, hWndBedit;  /* handle to child windows..hedit and bedit */
static HWND   hWndKeyBdButton;  /* handle to pen windows keyboard button*/
static HWND   hWndAlcButton;  /* handle to alc settings button */
static HWND   heditFocusWnd = NULL;  //keeper of the last window to have focus
static HWND   hPenWin;               /* handle to penwin.dll if present */
static HBITMAP  hKBUp, hKBDown;   /* showkeyboard bitmaps handles */


/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/

int _pascal WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine,  int nCmdShow)
    {
    MSG msg;

    if (hPrevInstance == 0)
        if (InitApplication(hInstance) == 0)
            return (FALSE);

    if (InitInstance(hInstance, nCmdShow) == 0)
        return (FALSE);

    while (GetMessage(&msg, 0, 0, 0) != 0)
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    return (msg.wParam);
    }


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

static BOOL InitApplication(HANDLE hInstance)
    {
    WNDCLASS  wc;
    char      szMenu[11], szClass[12];

    LoadString (hInstance, ID_MENUSTR, szMenu, sizeof (szMenu));
    LoadString (hInstance, ID_CLASSSTR, szClass, sizeof (szClass));

    wc.style          = 0;
    wc.lpfnWndProc    = (WNDPROC)MainWndProc;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hInstance      = hInstance;
    wc.hIcon          = LoadIcon(hInstance, "ALCKEY");
    wc.hCursor        = LoadCursor(0, IDC_ARROW);
    wc.hbrBackground  = (HBRUSH)COLOR_WINDOW+1 ;
    wc.lpszMenuName   = szMenu;
    wc.lpszClassName  = szClass;

    return (RegisterClass(&wc));
    }


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

static BOOL InitInstance(HANDLE hInstance, int nCmdShow)
    {
    char szClass[12], szTitle[40];

    LoadString (hInstance, ID_CLASSSTR, szClass, sizeof (szClass));
    LoadString (hInstance, ID_CAPTIONSTR, szTitle, sizeof (szTitle));

    hInst = hInstance;

    hwnd = CreateWindow(
             szClass,
             szTitle,
             WS_OVERLAPPEDWINDOW,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             0,
             0,
             hInstance,
             0 );

    if (hwnd == 0 )
        return ( FALSE );

    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    return (TRUE);
    }


/****************************************************************************

    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

          
****************************************************************************/

long _far _pascal MainWndProc(HWND hWnd, unsigned message,
                              WORD wParam, LONG lParam)
    {

    FARPROC  lpProcAbout, lpProcAlcDlg;
    char szDlgBox[9], szMsgBoxCap[12], szStatus1[14], szStatus2[14];
    char szAlcDlgBox[10];

    LoadString (hInst, ID_DLGBOX, szDlgBox, sizeof (szDlgBox));
    LoadString (hInst, ID_MSGBOXCAP, szMsgBoxCap, sizeof (szMsgBoxCap));
    LoadString (hInst, ID_STATUS1, szStatus1, sizeof (szStatus1));
    LoadString (hInst, ID_STATUS2, szStatus2, sizeof (szStatus2));
    
    LoadString (hInst, ID_ALCDLGBOX, szAlcDlgBox, sizeof(szAlcDlgBox));
    

    switch ( message )
        {
        case WM_CREATE:
         {
         RECT crect;
         int x,y,cx,cy;
         
         //create keyboard button top,left corner
         x=y=0;
         cx=cy=40;    //make buttons 40 pixels square
         hWndKeyBdButton = CreateWindow(
                            (LPSTR)"button",
                            (LPSTR)"ShowKeyBoard",
                            WS_CHILD|WS_VISIBLE | WS_BORDER|BS_OWNERDRAW,
                            x,
                            y,
                            cx,
                            cy,
                            hWnd, 
                            IDC_KEYBDBUTTON,
                            GetWindowWord(hWnd, GWW_HINSTANCE),
                            (LPSTR)NULL);
         
         //load up the keyboard bitmaps, discard when app closes.
         hPenWin = GetSystemMetrics(SM_PENWINDOWS);

         hKBDown = LoadBitmap(hPenWin, MAKEINTRESOURCE(OBM_SKBBTNDOWN));
         hKBUp = LoadBitmap(hPenWin, MAKEINTRESOURCE(OBM_SKBBTNUP));
         
         //create alc settings button top,left corner next to keyboard button
         x=40; y=0;
         cx=cy=40;
         hWndAlcButton = CreateWindow(
                            (LPSTR)"button",
                            (LPSTR)"ALC",
                            WS_CHILD|WS_VISIBLE | WS_BORDER,
                            x,
                            y,
                            cx,
                            cy,
                            hWnd, 
                            IDC_ALCBUTTON,
                            GetWindowWord(hWnd, GWW_HINSTANCE),
                            (LPSTR)NULL);
               
         // create two edit controls, an hedit and a bedit
         GetClientRect(hWnd, &crect);
         
         x =  (crect.right-crect.left)/8;
         cx = (crect.right-crect.left)*4/8;
         y =  (crect.bottom-crect.top)/8;
         cy = (crect.bottom-crect.top)*2/8;
         
         hWndHedit = CreateWindow(
               (LPSTR)"hedit",
               (LPSTR)NULL,
               WS_CHILD|WS_VISIBLE |ES_MULTILINE|ES_LEFT | ES_AUTOVSCROLL|WS_VSCROLL | WS_BORDER | WS_TABSTOP,
               x,
               y,
               cx,
               cy,
               hWnd, 
               (HMENU)NULL,
               GetWindowWord(hWnd, GWW_HINSTANCE),
               (LPSTR)NULL);
               
         x =  (crect.right-crect.left)/8;
         cx = (crect.right-crect.left)*4/8;
         y =  (crect.bottom-crect.top)*4/8;
         cy = (crect.bottom-crect.top)*2/8;
         
         hWndBedit = CreateWindow(
               (LPSTR)"bedit",
               (LPSTR)NULL,
               WS_CHILD|WS_VISIBLE |ES_MULTILINE|ES_LEFT | ES_AUTOVSCROLL | WS_VSCROLL|WS_BORDER | WS_TABSTOP,
               x,
               y,
               cx,
               cy,
               hWnd, 
               (HMENU)NULL,
               GetWindowWord(hWnd, GWW_HINSTANCE),
               (LPSTR)NULL);
        
         }
         
         //set focus to hedit control as a default
         SetFocus(hWndHedit);
         heditFocusWnd = hWndHedit;
         
         break;
        
        case WM_SETFOCUS:
        SetFocus(heditFocusWnd);
        return 0;
        break;
        
        case WM_COMMAND:
            /* Edit control commands
            */
            if (HIWORD(lParam) == EN_SETFOCUS)
              {
              /* Field focus is being set */
              heditFocusWnd = LOWORD(lParam);
              break;
              }
            
            switch ( wParam )
                {
                case IDM_ABOUT:
                    lpProcAbout = MakeProcInstance( About, hInst );
                    DialogBox(hInst, szDlgBox, hWnd, lpProcAbout);
                    FreeProcInstance( lpProcAbout );
                    break;

                case IDC_ALCBUTTON:
                    lpProcAlcDlg = MakeProcInstance(AlcDlgProc, hInst);
                    DialogBox(hInst,szAlcDlgBox, hWnd, lpProcAlcDlg);
                    FreeProcInstance( lpProcAlcDlg);
                    break;
                    
                case IDC_KEYBDBUTTON:
                    {
                    SKBINFO skb;
                    
                    if (heditFocusWnd)
                      SetFocus(heditFocusWnd);
                    
                    ShowKeyboard(hWnd,SKB_QUERY,NULL, &skb);
                    if (!skb.fVisible)
                     {
                     ShowKeyboard(hWnd,SKB_SHOW,NULL,&skb);
                     }
                    else
                     {
                     ShowKeyboard(hWnd, SKB_HIDE,NULL,&skb);
                     }

                     
                    }
                    break;
                    

                }
            break;
        
        case WM_MEASUREITEM:
          {
          int nIDCtl;
          LPMEASUREITEMSTRUCT lpmisCtl;
          
          nIDCtl = (int) wParam;                      /* control identifier   */
          lpmisCtl = (MEASUREITEMSTRUCT FAR*) lParam; /* address of structure */
          }
          break;
        
        case WM_DRAWITEM:
          {
          int nIDCtl;
          LPDRAWITEMSTRUCT lpdis;
          HDC hMemDC;
          HBITMAP hOldBitmap;
          BITMAP bm;
          
          nIDCtl = (int) wParam;                     /* control identifier */
         // lpdis = (const DRAWITEMSTRUCT FAR*) lParam;    /* structure     */
          lpdis = (LPDRAWITEMSTRUCT) lParam; 
          GetObject(hKBUp,sizeof(BITMAP),&bm);
          
          //check for state of button .. the only ownerdraw control in this app.
          switch (lpdis->itemAction) {

            case ODA_DRAWENTIRE:
            /* Redraw the entire control or menu. */
            case ODA_SELECT:
            /* Redraw to reflect current selection state. */
            
            hMemDC = CreateCompatibleDC(lpdis->hDC);
            
            if ((lpdis->itemState && ODS_SELECTED) != 0)     //bit is set if not equal to zero
               hOldBitmap = SelectObject(hMemDC,hKBDown);
            else
               hOldBitmap = SelectObject(hMemDC, hKBUp);
               
            StretchBlt(lpdis->hDC,0,0,40,40,hMemDC,0,0,bm.bmWidth,bm.bmHeight,SRCCOPY);
            SelectObject(hMemDC, hOldBitmap);
            DeleteDC(hMemDC);
            
            return TRUE;

            case ODA_FOCUS:
            /* Redraw to reflect current focus state. */
            hMemDC = CreateCompatibleDC(lpdis->hDC);
            
            if ((lpdis->itemState && ODS_FOCUS) != 0)     //bit is set if not equal to zero
               hOldBitmap = SelectObject(hMemDC,hKBDown);
            else
               hOldBitmap = SelectObject(hMemDC, hKBUp);
               
            StretchBlt(lpdis->hDC,0,0,40,40,hMemDC,0,0,bm.bmWidth,bm.bmHeight,SRCCOPY);
            SelectObject(hMemDC, hOldBitmap);
            DeleteDC(hMemDC);
            
            return TRUE;

            
           } //end of switch
           
          }
          break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
     }

    return (FALSE);
    }


/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL _far _pascal About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
    {
    switch (message)
        {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
            if (wParam == IDOK || wParam == IDCANCEL)
                {
                EndDialog(hDlg, TRUE);
                return (TRUE);
                }
            break;
        }
    return (FALSE);
    }

/****************************************************************************

    FUNCTION: AlcDlgProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "Alc Dialog" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL _far _pascal AlcDlgProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
    {
    DWORD dwIndex;
    RC rc;
    char szAlcTmp[30];
    LPSTR lpAlcBeg, lpAlcEnd, lpAlc, lpAlcOrg;
    int j;
    LONG  y;
    DWORD dwx;
    HRSRC hAlcValues;   //alc string resource handle in rc file
    HGLOBAL hAlcGlobal;  //global memory handle of alc resource string
    BOOL fContinue = TRUE;
    
    
    switch (message)
        {
        case WM_INITDIALOG:
        {
        //load values into listbox for ALC use
        if (hAlcValues = FindResource(hInst, (LPCSTR)ID_ALCSTRINGS, (LPCSTR)RT_RCDATA))
          if (hAlcGlobal = LoadResource(hInst, hAlcValues))
            lpAlc = (LPSTR)LockResource(hAlcGlobal);
        lpAlcOrg = lpAlc;
        
        lpAlcBeg = lpAlc;
        lpAlcEnd = lpAlc;
        
       while (fContinue)
        {
        lpAlc++;
        //must find a way to check for eof right off..
        if (!(*lpAlc != 0))
          break;
          
          if (*lpAlcEnd != '{') 
           {
            lpAlcEnd++;
           }
          else
          {
            //initialize tmp array back to null
            for (j=0; j<30; j++)
              szAlcTmp[j] = 0;
              
            _fmemcpy((void _far *)szAlcTmp,lpAlcBeg,(int)(lpAlcEnd-lpAlcBeg));
            //is this the terminating string?
            if ((szAlcTmp[0] == 'E')&&(szAlcTmp[1] == 'O')&&(szAlcTmp[2] == 'S'))
              {
              fContinue = FALSE;
              break; //out of the loop
              }
              
            dwIndex = SendDlgItemMessage(hDlg, ID_ALCLISTBOX, LB_ADDSTRING, 0, (LPARAM)((LPSTR)szAlcTmp));
            //pick up alc hex value
            
            for (j=0; j<30; j++)
              szAlcTmp[j] = 0;
            _fmemcpy((void _far *)szAlcTmp,lpAlcEnd+1,10); //format has 10 numerics in it
            dwx = atol(szAlcTmp);
            //associate the value with that listbox item
            SendDlgItemMessage(hDlg,ID_ALCLISTBOX,LB_SETITEMDATA,(WORD)dwIndex,(LPARAM)dwx);
            y = SendDlgItemMessage(hDlg,ID_ALCLISTBOX,LB_GETITEMDATA,(WORD)dwIndex,0L);
            
            //go to start of next valid alc code
            while (*lpAlcEnd != '!')
              lpAlcEnd++;
            lpAlcBeg = ++lpAlcEnd;
          //increment lpAlc to new position
          lpAlc = lpAlcEnd;  
          }
        }
        
        
            return (TRUE);
        }
        
        
        case WM_COMMAND:
           switch (wParam)
            {
              case ID_SELECT:
                {
                LPSTR lp;
                HWND hwndMyEdit;
                char szBuffer[32] ;
                int count, retct;
                int szCount[32];

                LONG alcvalue=0;
                int i;

                hwndMyEdit = GetDlgItem(hDlg, ID_ALCEDIT);
                SendMessage(hwndMyEdit, WM_GETTEXT, sizeof(szBuffer),
                           (LPARAM) ((LPSTR) szBuffer));
                lp = szBuffer;

                //get rc for hedit control and reset to new values for alc
                if (SendMessage(hWndHedit, WM_HEDITCTL, HE_GETRC, (LONG)((LPRC)&rc)))
                 {
                    rc.alc = alcvalue = ALC_USEBITMAP;
                    //initialize szCount to nothing
                    
                    count = (int)SendDlgItemMessage(hDlg,ID_ALCLISTBOX,LB_GETSELCOUNT,0,0L);
                    for (i=0; i<count; i++)
                      szCount[i] = 0;
                    retct = (int)SendDlgItemMessage(hDlg,ID_ALCLISTBOX,LB_GETSELITEMS,(WPARAM)count,(LPARAM)(int FAR*)szCount);
                    
                     
                    for (i=0; i <count; i++)
                    {
                      alcvalue = SendDlgItemMessage(hDlg,ID_ALCLISTBOX,LB_GETITEMDATA,(WORD)szCount[i],0L);
                      rc.alc = rc.alc|alcvalue;
                    }
                    
                    if (rc.alc&ALC_USEBITMAP)
                       SetAlcBits(&rc, lp);

                    SendMessage(hWndHedit, WM_HEDITCTL, HE_SETRC, (LONG)((LPRC)&rc));
                    
                 } //end if
                 
          
                }
              break;
              
              case ID_DONE:
                {
                EndDialog(hDlg, TRUE);
                return (TRUE);
                }
              break;
              
              default:
              break;
            }//end switch
            
        }
    return (FALSE);
    }


/*----------------------------------------------------------
Purpose: Set the bits for ALC_USEBITMAP field
Returns: --
*/
VOID SetAlcBits(
   LPRC lprc,
   LPSTR lp)
   {
   int ib;

//wipe out all the old values (initialization to '0')
   for (ib=0; ib<32; ib++)
      lprc->rgbfAlc[ib] = 0;   //this is faster than using the macros

   for ( ; *lp != 0; lp++)
      {
      SetAlcBitAnsi (lprc, *lp);  //use the ALC macro here
      }
   }

/* END OF FILE */
