/***********************************
 *  Paddy's Change Directory v2.31 *
 ***********************************/


parse arg arg1 arg2

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse upper var arg1 arg1 bla



err=0
pcdcmp=SysIni(, 'PCD', 'pcdcmp')
if (pcdcmp='ERROR:') then err=err+1
index=SysIni(, 'PCD', 'index')
if (index='ERROR:') then err=err+1
indext=SysIni(, 'PCD', 'indext')
if (indext='ERROR:') then err=err+1
outpath=SysIni(, 'PCD', 'outpath')
if (outpath='ERROR:') then err=err+1

if ((\(err=0)) | (arg1 = "/INIT")) then do
  say "You have to initialize PCD."
  say "Enter the path of pcdcmp.exe (e.g. d:\tools\pcd)"
  pull pcdcmp
  helppath=pcdcmp
  pcdcmp=pcdcmp"\pcdcmp.exe"
  bla=charin(pcdcmp, 1, 1)
  blabla=stream(pcdcmp, "c", "close")
  if (bla='') then do
    say "Path "helppath" is illegal. Program terminated."
    exit
  end

  say "Enter the path of the indexfile of PCD (e.g. c:)"
  pull index
  bla=SysFileTree(index, 'dirs', 'DO')
  if (dirs.0=0) then do
    say "Path "index" is illegal. Program terminated."
    exit
  end

  say "Enter the path of the temporary indexfile (e.g. c:)"
  pull indext
  bla=SysFileTree(indext, 'dirs', 'DO')
  if (dirs.0=0) then do
    say "Path "indext" is illegal. Program terminated."
    exit
  end

  say "Enter the path of the temporary file of pcdcmp.exe (e.g. c:)"
  pull outpath
  bla=SysFileTree(outpath, 'dirs', 'DO')
  if (dirs.0=0) then do
    say "Path "outpath" is illegal. Program terminated."
    exit
  end

  index=index"\pcd.idx"
  indext=indext"\pcd.tmp"
  outpath=outpath"\pcd-path.tmp"

  SysIni(, 'PCD')
  SysIni(, 'PCD', 'pcdcmp', pcdcmp)
  SysIni(, 'PCD', 'index', index)
  SysIni(, 'PCD', 'indext', indext)
  SysIni(, 'PCD', 'outpath', outpath)

  say
  say "OS2.INI updated."

  exit
end


select
  when arg1 = "/CLEAR" then do
    SysIni(, 'PCD')
    say
    say "PCD entries in OS2.INI deleted."
    exit
  end

  when arg1 = "/SCAN" then do
    if (arg2="") then
      devices=SysDriveMap()
    else do
      do while (\(arg2==""))
        if (devices=="DEVICES") then
          devices=substr(arg2, 1, 1)": "
        else
          devices=devices""substr(arg2, 1, 1)": "
        arg2=substr(arg2, 2)
      end
      devices=translate(delstr(devices,length(devices)))
    end

    wordnum=1
    scanned=0

    device=subword(devices, wordnum, 1)

    do while (\(device=""))
      bla=SysFileTree(device'\', 'dirs', 'DSO')
      bla=SysFileDelete(index)

      do i=1 to dirs.0
        bla=lineout(index, dirs.i)
        if (bla=1) then do
          say "Error generating "index". Program terminated."
          exit
        end
      end
      wordnum=wordnum+1
      scanned=scanned+i-1
      device=subword(devices, wordnum, 1)
    end

    say scanned" directories scanned. ("devices")"
  end

  when (arg1="MD") & (\(arg2="")) then do
    say "Making Directory "arg2"..."
    bla=SysMkDir(arg2)
    if (\(bla=0)) then
      say "It's not possible to create "arg2" (Error="bla")."
    else do
      bla=SysFileTree(arg2, 'dirs', 'DO')

      bla=lineout(index, dirs.1)
      if (bla=1) then do
        say "Error updating "index". Program terminated."
      exit
      end
    end
  end

  when (arg1="RD") & (\(arg2="")) then do
    say "Removing Directory "arg2"..."
    bla=SysFileTree(arg2, 'dirs', 'DO')
    if ((\(bla=0)) | (dirs.0=0)) then do
      say "Directory "arg2" does not exist. Program terminated."
      exit
    end
    
    bla=SysRmDir(arg2)
    if (\(bla=0)) then do
      say "It's not possible to remove "arg2" (Error="bla"). Program terminated."
      exit
    end
 
    bla=SysFileSearch(dirs.1, index, 'lines', 'CN')
    if (\(bla=0)) then do
      say "Error updating "index". Program terminated."
      exit
    end
    
    line=subword(lines.1, 1, 1)
    bla=SysFileDelete(indext)
        
    i=1
    do while (lines(index))
      bla=linein(index)
      if (bla='BLA') then do
        say "Error reading "index". Program terminated."
        exit
      end

      if (\(i=line)) then do
        bla=lineout(indext, bla)
        if (bla=1) then do
          say "Error generating new "index". Program terminated."
          exit
        end
      end
      i=i+1         
    end
  bla=stream(index, "c", "close")
  bla=stream(indext, "c", "close")

  "@copy "indext index '2>nul >nul'

  bla=SysFileDelete(indext)
  end

  when (\(arg1 = "")) then do
    '@cd "'arg1'" 2> nul'
    if (\(rc=0)) then do
      "@"pcdcmp index arg1 translate(arg2) "2>"outpath
      bla=linein(outpath)
      if (\(bla="")) then do
        drive=substr(bla, 1, 2)
        "@"drive
        '@cd "'bla'" 2> nul'
        if (\(rc=0)) then do
          say "Error changing to "bla". Program terminated."
          exit
        end
      end
      bla=stream(outpath, "c", "close")
      bla=SysFileDelete(outpath)
    end
  end

  otherwise
  "@"pcdcmp "copyright"
end
exit
