/***********************************************************************\
 *                                 PC2.c                               *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Install.cmd  Installation batch file.                               *
 *                                                                     *
 *              INSTALL <InstallationPathDirectory>                    *
 *              F.e. INSTALL C:\PMAPPS\PC2                             *
 *                                                                     *
\***********************************************************************/

                                        /* Register REXX APIs */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Halt Name SignalHandler       /* Exception handler */

NewObjectID=" "
Do While NewObjectID=" "
    Call SysCls
    Say "                   Empty WPS Objects Installer"
    Say
    Say " To install any empty Object with an registered Object ID (Idendity) onto the"
    Say " WPS, you must provide a symbolic name for this registered Object. You may"
    Say " then use PC/2 to launch this object, after you have configured this empty"
    Say " Object with the application you want to install as an object. F.e. you may"
    Say " want to create an empty Object and then configure it as an seamless WIN-OS2"
    Say " session, allowing you to launch this seamless WIN-OS2 session from PC/2."
    Say
    Say " Syntax:       INSTALL WPSObjectID"
    Say
    Say " Example:      INSTALL <WP_MyObject>"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please input: "
    Col=Col+15
    Call SysCurPos Row, Col
    Pull NewObjectID
End
Say
SetupString="OBJECTID="NewObjectID
                                        /* Now create the WPS Object on the Desktop */
rc=SysCreateObject("WPProgram",,
                   NewObjectID,,
                   "<WP_DESKTOP>",,
                   SetupString)
If rc=0 Then Do
    Say " Sorry, WPS Object couldn't be created..."
End
Else Do
    Say " WPS Object sucessfully created..."
    Say
    Say " You may now want to open the Settings of the newly created empty WP Object to"
    Say " configure it to an application, f.e. an PM, DOS or seamless WIN-OS2 session."
    Say
    Say " Press Enter to continue!..."
    Pull IgnoreInput
End
Call SysCls
Exit

/*--------------------------------------------------------------------------------------*\
 * The signal handler to exit after an exception                                        *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
SignalHandler:
Call SysCls
Say "PC/2 abnormal error - exiting..."
Exit

