/* ================================================================= */
/* EAPREP.CMD - Create EA Backup/Restore Command Files               */
/* ================================================================= */
/*                                                                   */
/* Written by Mercer H. Harz  (70431,150)   23 May 1992              */
/*                                                                   */
/* All standard disclaimers apply; this procedure is provided "as is"*/
/* and no guarantees or warranties are provided regarding its fitness*/
/* for a particular task.  It is placed into the public domain by    */
/* the author, who created the procedure only as a training exercise */
/* in response to another user's request.  Feel free to modify it as */
/* you will.  It is not terribly robust in its current incarnation.  */
/*                                                                   */
/* ================================================================= */
/*                                                                   */
/* This procedure creates OS/2 command files that can be executed to */
/* backup and restore extended attributes prior to backup or after   */
/* a restore using a DOS backup program that can't handle extended   */
/* attributes.  If the DOS backup/restore program does not preserve  */
/* the contents of reserved bytes in the directory entries, EAPREP   */
/* should be used on both FAT and HPFS volumes.  However, if the     */
/* backup/restore program does preserve the contents of the reserved */
/* bytes, then EAPREP is not needed for FAT volumes, as long as you  */
/* backup and restore the EA DATA. SF file.  EAPREP (or something    */
/* like it) is always needed for backing up/restoring HPFS volumes   */
/* using EA-unaware utilities.                                       */
/*                                                                   */
/* EAPREP does not backup/restore the Workplace Shell desktop, even  */
/* though some WPS state info may be saved in EAs.  Use the WPSBKP   */
/* utility in the CIS:IBMOS2 libraries for this purpose.             */
/*                                                                   */
/* ================================================================= */
/*                                                                   */
/* syntax:  EAPREP <drive>                                           */
/*                                                                   */
/* <drive> is an optional parameter.  If not specified, the current  */
/* drive will be processed.                                          */
/*                                                                   */
/* ================================================================= */
/*                                                                   */
/* Currently the procedure uses a brute force method to achieve its  */
/* ends, since there is no built-in way in REXX to determine whether */
/* a file has extended attributes.  EAPREP builds a list of files on */
/* the drive, then scans the list looking for a non-zero value in    */
/* the extended attribute size field; for each hit, it creates a     */
/* command in the backup and restore command files.  Files that are  */
/* "in use" by OS/2 (such as OS2KRNL on my system) will generate     */
/* errors during processing of the backup and restore command files. */
/* These can, in my experience, be ignored.                          */
/*                                                                   */
/* The backup and restore command files use the EAUTIL program that  */
/* is furnished with OS/2.  Operation of EAUTIL is documented in the */
/* online command reference.                                         */
/*                                                                   */
/* EAPREP has no selective processing capability; the entire drive   */
/* will be scanned.  You can further refine the process by editing   */
/* the output with any ASCII text editor.                            */
/*                                                                   */
/* EAPREP assumes you are not disk-space-constrained.  At a minimum, */
/* you will need slightly more free space on the drive than is       */
/* occupied by the extended attributes on that drive.  To see how    */
/* much space is occupied by extended attributes, run CHKDSK against */
/* the drive before you run this procedure.                          */
/*                                                                   */
/* EAPREP uses the TEMP environment variable to determine where to   */
/* place the work file and command files that are the output of this */
/* procedure.  If TEMP is not set in the environment, the current    */
/* directory will be used.  Work files could occupy several hundred  */
/* kilobytes, but are deleted at the end of the procedure.           */
/*                                                                   */
/* The backup copies of the extended attributes are stored in        */
/* subdirectories named EAS, in each directory that has files that   */
/* have extended attributes.  The files in the EAS directory have    */
/* the same name as the file in the parent directory.  This is the   */
/* default EAUTIL behavior, and can be overridden, but not easily.   */
/* If you want to use another directory name besides EAS, you must   */
/* create the directories manually; EAUTIL takes care of creating    */
/* the EAS directories when the default <holdfile> conventions are   */
/* followed.                                                         */
/*                                                                   */
/* The restore command file also contains the commands to remove the */
/* EAS directories after EAs have been restored.  If you modify the  */
/* procedure to use a subdirectory name other than EAS, you need to  */
/* change the RD commands that are emitted.                          */
/*                                                                   */
/* The BACKUP command file uses the /P /R /S switches; these split   */
/* (/S) the EAs into a backup copy, preserving the EAs with the      */
/* parent file, and replacing (/R) any existing backup copy of the   */
/* parent's EAs that might be stored in the EAS subdirectory.        */
/*                                                                   */
/* The RESTORE command file uses the /O /J switches; these join (/J) */
/* the EAs to the parent file, overlaying (/O) any existing EAs      */
/* associated with the parent.  The backup copy will be erased.  To  */
/* prevent the erasure of the backup, add the /P switch to these     */
/* commands and remove the lines that call LINEOUT in order to       */
/* remove the EAS directories.   If you want to merge the backup EAs */
/* with the current EAs (if any) rather than overlaying them, use    */
/* the switches /M /J rather than /O /J for the restoration.         */
/*                                                                   */
/* Long file names may not operate properly with DOS backup/restore  */
/* software; this will depend on whether OS/2 will properly create   */
/* filenames in 8.3 format when backing up/restoring with DOS s/w.   */
/* I haven't tested long file names because I don't have any HPFS    */
/* volumes right now.  My advice is to stick with 8.3 filenames on   */
/* HPFS volumes until you have long-name-aware backup/restore s/w.   */
/*                                                                   */
/* See the comments at the end of the procedure about deleting the   */
/* directory listing work file created by EAPREP.                    */
/*                                                                   */
/* ================================================================= */

arg Drive

TimeStamp = time()
DateStamp = date()
hdr = "EAPREP: "
say " "
say "EAPREP v1.0 - Prepare Extended Attributes for DOS Backup/Restore"
say hdr"Starting at "TimeStamp" on "DateStamp"."

TempDir = value('TEMP',,'OS2ENVIRONMENT')
if length(TempDir) = 0 then TempDir = directory()
if right(TempDir,1) = '\' then
    TempDir = substr(TempDir, 1, length(TempDir) - 1)
if length(Drive) = 0   then Drive = filespec("Drive", directory())

Drive = left(Drive,1)
WorkFile = TempDir'\'Drive'.wrk'
BackupFile = TempDir'\'Drive'_bkp.cmd'
RestoreFile = TempDir'\'Drive'_rst.cmd'
if length(stream(BackupFile,'c','query exists')) > 0 then
    'del 'BackupFile
if length(stream(RestoreFile,'c','query exists')) > 0 then
    'del 'RestoreFile

'dir 'Drive':\*.* /N /S /A:-D > 'WorkFile
/*  say "Return Code from Directory Search was "rc"."  */
if rc <> 0 then do
    'del 'WorkFile
    say hdr"Sorry, there was a problem obtaining a directory for drive "Drive":."
    say hdr"The return code from OS/2 was "rc"."
    exit
end
Result = stream(WorkFile,'c','open read')
if Result <> "READY:" then do
    'del 'WorkFile
    say hdr"Sorry, there was a problem reading directory file "WorkFile"."
    exit
end
Result = stream(BackupFile,'c','open write')
if Result <> "READY:" then do
    'del 'BackupFile
    say hdr"Sorry, there was a problem opening backup command file "BackupFile"."
    exit
end
Result = stream(RestoreFile,'c','open write')
if Result <> "READY:" then do
    'del 'RestoreFile
    say hdr"Sorry, there was a problem opening restore command file "RestoreFile"."
    exit
end

EACount = 0
NumDirs = 0
NumFiles = 0
DirCount = 0
do until lines(WorkFile) = 0
    buff = linein(WorkFile)
    parse var buff word1 word2 word3 word4 word5 word6
    if buff = " " then iterate
    if word1 = "The" then iterate
    if word1 = "Totals" then iterate
    if word1 = "Volume" then iterate
    if word2 = "bytes" then iterate
    if word2 = "file(s)" then iterate
    if word1 = "Directory" then do
/* ================================================================= */
        if ((NumDirs > 0) & (DirCount > 0)) then
            call lineout RestoreFile, 'RD 'CurrentDir'\EAS'
/* ================================================================= */
        CurrentDir = word3
        if CurrentDir == Drive":\" then CurrentDir = Drive":"
        NumDirs = NumDirs + 1
        DirCount = 0
        iterate
    end
    NumFiles = NumFiles + 1
    if word4 > 0 then do
        BackupCmd = 'EAUTIL 'CurrentDir'\'word5' /P /R /S'
        RestoreCmd = 'EAUTIL 'CurrentDir'\'word5' /O /J'
        call lineout BackupFile, BackupCmd
        call lineout RestoreFile, RestoreCmd
        EACount = EACount + 1
        DirCount = DirCount + 1
    end
end
/* ================================================================= */
if DirCount > 0 then call lineout RestoreFile, 'RD 'CurrentDir'\EAS'
/* ================================================================= */
Result = stream(WorkFile,'c','close')
Result = stream(BackupFile,'c','close')
Result = stream(RestoreFile,'c','close')
/* ================================================================= */
/*  after you are satisfied that the procedure works correctly, you  */
/*  can remove the comments on the next line to cause the work file  */
/*  (the directory listing) to be deleted.                           */
/* ================================================================= */
/*  'del 'WorkFile   */
if count = 0 then do
    'del 'BackupFile
    'del 'RestoreFile
end

buff = "files"
buff2 = buff
if EACount = 1 then buff = "file"
if NumFiles = 1 then buff2 = "file"
say " "
say hdr"Processed "NumFiles" "buff2"; "EACount" "buff" had extended attributes."
if count > 0 then do
    say hdr"Backup commands are stored in "BackupFile"."
    say hdr"Restore commands are stored in "RestoreFile"."
  end
else say hdr"Backup and Restore commands were not created."

TimeStamp = time()
DateStamp = date()
say " "
say hdr"Finished at "TimeStamp" on "DateStamp"."
