//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//

#if !defined(___OMODE_H_INCLUDED)

//
//  OS/2 and DOS Open mode flags.  Used in <fcntl.h>, <share.h>
//  and <stdio.h>.
//
//  The visible versions of these flags are the O_... flags.
//

//
// Required by POSIX
//
#define _O_RDONLY       0x0000  /* open for reading only            */
#define _O_WRONLY       0x0001  /* open for writing only            */
#define _O_RDWR         0x0002  /* open for reading and writing     */
#define _O_ACCMODE      0x0003  /* Because the above need not be bitmasks */
#define _O_CREAT        0x0100  /* create and open file             */
#define _O_TRUNC        0x0200  /* open and truncate                */
#define _O_EXCL         0x0400  /* open only if file doesn't already exist  */

//
// Required by POSIX, but meaningless under MS-DOS
//
#define _O_APPEND       0x0008  /* writes done at eof               */
#define _O_NOCTTY       0x0000  /* Do not assign ctty               */
#define _O_NONBLOCK     0x0000  /* Non-blocking I/O                 */

//
// Required by MS-DOS and OS/2
//
// Note that sharing flags are properly part of the POSIX.1 O_... set of
// flags, because they may be passed in the oflag parameter to open() .
//
#define _O_COMPAT       0x0000  /* Compatibility sharing mode       */
#define _O_DENYALL      0x0010  /* Deny reads and writes            */
#define _O_DENYWRITE    0x0020  /* Deny writes                      */
#define _O_DENYREAD     0x0030  /* Deny reads                       */
#define _O_DENYNONE     0x0040  /* Deny nothing                     */
#define _O_NOINHERIT    0x0080  /* child process doesn't inherit file   */
#define _O_FAILONERR    0x2000  /* AutoFail on hard error           */
#define _O_WRITETHRU    0x4000  /* Auto-commit every write          */
#define _O_DASD         0x8000  /* DASD access (OS/2 only)          */

// Names used internally by the library
#define _O_ANYSHARE     0x0070  /* Mask for sharing mode            */
#define _O_EXTENDED     0xE0F0  /* Mask for all extended flags      */
#define _O_RUNFLAGS     0x0F00  /* Flags that change when file is open */

// Names inherited from UNIX version 3, which are not in POSIX.
#define _O_TEXT         0x0400  /* text mode (CRLF <--> LF translated)  */
#define _O_BINARY       0x0800  /* binary mode (untranslated)           */

#define ___OMODE_H_INCLUDED
#endif
