unit Grpmodu;
{2/14/95}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DdeMan, ExtCtrls, StdCtrls, Menus,
  ShellApi,
  GroupFile, GroupItem, GroupType;

type
  TGrpModForm = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    GRPEditor1: TMenuItem;
    Savefile1: TMenuItem;
    PanelGrpName: TPanel;
    ComboItemList: TComboBox;
    PanelNormRect: TPanel;
    PanelMinLoc: TPanel;
    EditCmdLine: TEdit;
    EditWorkDir: TEdit;
    EditIconPath: TEdit;
    PanelLoc: TPanel;
    PanelMin: TPanel;
    PanelHotkey: TPanel;
    PanelHotkeyStr: TPanel;
    PanelIndex: TPanel;
    ImageIcon: TImage;
    DdeClientConv1: TDdeClientConv;
    PanelNumItems: TPanel;
    procedure SaveWithBackup(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboItemListClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    ItemWas : Integer;
    TGF     : TGroupFileObj;
    PROCEDURE UpdateItem(which : LongInt);
  public
    { Public declarations }
    PROCEDURE LoadFromFile(CONST FileName : String);
  end;

implementation

{$R *.DFM}

PROCEDURE TGrpModForm.LoadFromFile(CONST FileName : String);
VAR
  TR : TRect;
  TP : TPoint;
  N  : Word;
begin
  {TGF was created in FormCreate}
  TGF.LoadFromFile(FileName);
  PanelGrpName.Caption := ExtractFileName(FileName);
  TR := TGF.NormRect;
  WITH TR DO
    PanelNormRect.Caption := Format('(%d,%d,%d,%d)',
      [left, top, right, bottom]);
  TP := TGF.MinPoint;
  WITH TP DO
    PanelMinLoc.Caption := Format('(%d,%d)', [X, Y]);
  N := TGF.Items.Count;
  PanelNumItems.Caption := Format('(%d)',[N]);
  Caption := 'Editor - ' + TGF.WindowName;
  ComboItemList.Clear;
  ItemWas := -1;
  IF TGF.Items.Count > 0 THEN
    WITH ComboItemList DO
      BEGIN
        Items.AddStrings(TGF.Items);
        ItemIndex := 0;
        ComboItemListClick(ComboItemList);
      END
  ELSE
    BEGIN
      EditCmdLine.Text := '';
      EditWorkDir.Text := '';
      EditiconPath.Text := '';
    END;
  Enabled := True;
  Show;
end;

PROCEDURE TGrpModForm.UpdateItem(Which : LongInt);
{Copy data from edit boxes back to TGF structure}
BEGIN
  IF Which > -1 THEN
    WITH TGF, Items.Objects[Which] AS TItemDataObj DO
      BEGIN
        Command  := EditCmdLine.Text;
        IconPath := EditIconPath.Text;
        WorkDir  := EditWorkDir.Text;
      END;
END;

procedure TGrpModForm.SaveWithBackup(Sender: TObject);
VAR
  NameTemp, NameSave : String[80];
  S : String;
begin
  IF NOT TGF.Changed THEN
    BEGIN
      MessageDlg('Group file has not changed.  No need to save.',
        mtWarning, [mbOk], 0);
      Exit;
    END;
  Screen.Cursor := crHourglass;
  UpdateItem(ComboItemList.ItemIndex);
  NameTemp := ChangeFileExt(TGF.GrpFileName, '.$$$');
  NameSave := ChangeFileExt(TGF.GrpFileName, '.~GR');
  TGF.SaveToFile(NameTemp);
  DeleteFile(NameSave);
  IF RenameFile(TGF.GrpFileName, NameSave) THEN
    IF RenameFile(NameTemp, TGF.GrpFileName) THEN
      {Use DDE to tell ProgMan to reload the file}
      WITH DdeClientConv1 DO
        BEGIN
          ConnectMode := ddeManual;
          SetLink('ProgMan','ProgMan');
          OpenLink;
          S := '[Reload('+TGF.WindowName+')]'+#0;
          IF NOT ExecuteMacro(@S[1], TRUE) THEN
            MessageBeep(MB_ICONSTOP);
          WHILE WaitStat DO
          Application.ProcessMessages;
          {bring our app back on top of progman}
          WITH Application.MainForm DO
            BringWindowToTop(handle);
          CloseLink;
        END;
  Screen.Cursor := crDefault;
end;

procedure TGrpModForm.FormCreate(Sender: TObject);
begin
  TGF := TGroupFileObj.Create;
end;

procedure TGrpModForm.ComboItemListClick(Sender: TObject);
CONST BoolName : ARRAY[Boolean] OF String[5] =
  ('FALSE', 'TRUE');
VAR
  TP        : TPoint;
  TheIcon   : TIcon;

  FUNCTION GetHandle(IP : String; Indx : Word) : THandle;
  {Get a handle for the item's icon}
  VAR
    Loc       : Word;
    Pt        : PChar;
    assoc     : ARRAY[0..80] OF Char;
  BEGIN
    IF Pos(' ', IP) > 0 THEN
      IP[0] := Char(Pred(Pos(' ', IP)));
    IF Pos('.', IP) = 0 THEN
      IP := IP + '.EXE';
    IP := IP + #0;
    Result := ExtractIcon(hInstance, @IP[1], Indx);
    IF Result > 1 THEN Exit;
    {If this is not an EXE, DLL, or ICO file,
     try getting the icon of its association}
    IF Result = 1 THEN
      BEGIN
        Loc := Pos('.', IP);
        IF Loc = 0 THEN Result := 0
        ELSE
          BEGIN
            {@IP[Loc+1] points to the iconpath's extension}
            GetProfileString('extensions', @IP[Loc+1],
              '_', Assoc, 80);
            IF StrComp(Assoc, '_') = 0 THEN Result := 0
            ELSE
              BEGIN
                Pt := StrScan(Assoc, ' ');
                IF Pt <> NIL THEN Pt[0] := #0;
                Result := ExtractIcon(hInstance,
                  Assoc, 1);
                IF Result = 1 THEN Result := 0;
              END;
          END;
      END;
    {If we've failed to get an icon, use the default}
    IF Result = 0 THEN
      Result := ExtractIcon(hInstance,
        'PROGMAN.EXE', 6);
  END;

begin
  WITH ComboItemList DO
    BEGIN
      IF Items.Count = 0 THEN Exit;
      UpdateItem(ItemWas);
      WITH Items.Objects[ItemIndex] AS TItemDataObj DO
        BEGIN
          PanelIndex.Caption := IntToStr(IconIndex);
          EditCmdLine.Text  := Command;
          EditIconPath.Text := IconPath;
          EditWorkDir.Text  := WorkDir;
          IF HotKey = 0 THEN
            BEGIN
              PanelHotKey.Caption := '(none)';
              PanelHotKeyStr.Caption := '';
            END
          ELSE
            BEGIN
              PanelHotKey.Caption := IntToHex(HotKey,4) + 'h';
              PanelHotKeyStr.Caption := HotKeyStr;
            END;
          TP := Point;
          WITH TP DO
            PanelLoc.Caption := Format('(%d,%d)', [X,Y]);
          PanelMin.Caption := BoolName[Minimized];
          TheIcon := TIcon.Create;
          WITH TheIcon DO
            Try
              Handle := GetHandle(IconPath, IconIndex);
              ImageIcon.Picture.Graphic := TheIcon;
            finally
              Free;
            END;
          END;
      ItemWas := ItemIndex;
    END;
end;

procedure TGrpModForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  UpdateItem(ComboItemList.ItemIndex);
  IF TGF.Changed THEN
    CASE MessageDlg('Data for group ' + TGF.WindowName +
      ' has changed.  Save?',
      mtConfirmation, [mbYes, mbNo, mbCancel, mbHelp], 7) OF
      ID_YES    : SaveWithBackup(Sender);
      ID_NO     : ; {quit, don't save}
      ID_CANCEL : CanClose := FALSE;
    END;
end;

procedure TGrpModForm.FormDestroy(Sender: TObject);
begin
  TGF.Free;
end;

procedure TGrpModForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

end.

