unit Genvuu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Grids, Outline, Buttons, ExtCtrls;

type
  TGenViewer = class(TForm)
    Bevel1: TBevel;
    SpdBtnOpenAll: TSpeedButton;
    SpdBtnShutAll: TSpeedButton;
    SpdBtnFind: TSpeedButton;
    SpdBtnGrab: TSpeedButton;
    Outline1: TOutline;
    SpeedBtnLoad: TSpeedButton;
    MainMenu1: TMainMenu;
    Viewer1: TMenuItem;
    ExpandAll1: TMenuItem;
    CollapseAll1: TMenuItem;
    GrabLine1: TMenuItem;
    IniVuIco: TImage;
    GrpVuIco: TImage;
    Find1: TMenuItem;
    procedure SpdBtnOpenAllClick(Sender: TObject);
    procedure SpdBtnShutAllClick(Sender: TObject);
    procedure SpdBtnFindClick(Sender: TObject);
    procedure SpdBtnGrabClick(Sender: TObject);
    procedure Outline1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure SpeedBtnLoadClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure Viewer1Click(Sender: TObject);
  private
    { Private declarations }
    AlreadyLoaded : Boolean;
  public
    { Public declarations }
    PROCEDURE ReloadData;
    PROCEDURE InitAsRegVu;
    PROCEDURE LoadFromINIFile(FileName : String);
    PROCEDURE LoadFromGRPFile(FileName : String);
  end;

VAR
  GenViewer : TGenViewer;

implementation
USES MyString, RepFormU, MdiFormU,
  GroupFile, GroupItem, ShellApi, IniFiles;

{$R *.DFM}
PROCEDURE TGenViewer.LoadFromINIFile(FileName : String);
VAR
  S : String;
  T : TextFile;
  N, LastSec : Word;
BEGIN
  IF Outline1.Tag > 0 THEN Exit;
  WITH Outline1 DO
    BEGIN
      Tag := 1;
      PictureLeaf := PictureMinus;
    END;
  HelpContext := 14;
  Icon := IniVuIco.Picture.Icon;
  Caption := 'Viewer - ' +
    ExtractFileName(FileName);
  AssignFile(T, FileName);
  Reset(T);
  N := 0; LastSec := 0;
  WHILE NOT EoF(T) DO
    BEGIN
      ReadLn(T, S);
      S := Trim(S);
      IF S <> '' THEN
        BEGIN
          N := N + 1;
          {If it's a section head, add it at the top
           outline level}
          IF (S[1] = '[') AND (S[length(S)] = ']') THEN
            BEGIN
              Outline1.Add(0, S);
              LastSec := N;
            END
          ELSE
            BEGIN
              {Otherwise, if it's not a section head and
               NO section head has been entered, create
               a blank head}
              IF LastSec = 0 THEN
                BEGIN
                  Outline1.Add(0, '[(none)]');
                  LastSec := N;
                  N := N + 1;
                END;
              {add the key to the last section}
              Outline1.AddChild(LastSec, S);
            END;
        END;
    END;
  CloseFile(T);
  Enabled := True;
end;

PROCEDURE TGenViewer.LoadFromGRPFile(FileName : String);
VAR
  S      : String;
  LC, N, HoldLC  : Word;
  TGF    : TGroupFileObj;
BEGIN
  IF Outline1.Tag > 0 THEN Exit;
  WITH Outline1 DO
    BEGIN
      Tag := 2;
      PictureLeaf := PicturePlus;
    END;
  HelpContext := 15;
  Icon := GrpVuIco.Picture.Icon;
  Caption := 'Viewer - ' +
    ExtractFileName(FileName);
  Outline1.Clear;
  Cursor := crHourglass;
  Try
    TGF := TGroupFileObj.Create;
    TGF.LoadFromFile(FileName);
    LC := 0;
    IF TGF.Items.Count > 0 THEN
      FOR N := 1 TO TGF.Items.Count DO
        WITH TGF.Items.Objects[N-1] AS TItemDataObj, Outline1 DO
          BEGIN
            Add(0, ItemName); Inc(LC);
            HoldLC := LC;
            AddChild(HoldLC, 'COMMAND: ' + Command); Inc(LC);
            IF WorkDir <> '' THEN
              BEGIN
                AddChild(HoldLC, 'WORK DIR: ' + WorkDir);
                Inc(LC);
              END;
            AddChild(HoldLC, 'ICON PATH: ' + IconPath); Inc(LC);
          END;
  Finally
    Cursor := crDefault;
    IF Assigned(TGF) THEN TGF.Destroy;
  END;
  Enabled := True;
END;

procedure TGenViewer.InitAsRegVu;
BEGIN
  IF Outline1.Tag > 0 THEN Exit;
  Outline1.Tag := 3;
  HelpContext := 11;
  SpeedBtnLoad.Visible := True;
  Caption := 'Registration Database Viewer';
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      Left := ReadInteger('RegView', 'Left', 0);
      Top := ReadInteger('RegView', 'Top', 163);
      Width := ReadInteger('RegView', 'Width', 429);
      Height := ReadInteger('RegView', 'Height', 204);
    finally
      Free;
    END;
END;

procedure TGenViewer.SpdBtnOpenAllClick(Sender: TObject);
begin
  WITH Outline1 DO
    BEGIN
      BeginUpdate;
      FullExpand;
      EndUpdate;
    END;
end;

procedure TGenViewer.SpdBtnShutAllClick(Sender: TObject);
begin
  WITH Outline1 DO
    BEGIN
      BeginUpdate;
      FullCollapse;
      EndUpdate;
    END;
end;

procedure TGenViewer.SpdBtnFindClick(Sender: TObject);
VAR
  N, LastN : Word;
  Found : Boolean;
begin
  WITH Outline1, RepForm DO
    BEGIN
      IF EditFind.Text = '' THEN
        BEGIN
          MessageDlg('Please enter a value in the Find What line '+
            ' of the Find and Replace window', mtInformation,
            [mbOk, mbHelp], 10);
          Exit;
        END;
      IF ItemCount = 0 THEN Exit;
      N := SelectedItem;
      IF N < 1 THEN N := 1;
      IF N = 1 THEN LastN := ItemCount
      ELSE LastN := N-1;
      Found := False;
      WHILE (NOT Found) AND (N <> LastN) DO
        BEGIN
          N := N + 1;
          IF N > ItemCount THEN
            N := 1;
          Found := Contains(Items[N].Text, EditFind.Text,
            MainForm.MatchCase1.Checked);
        END;
      IF Found THEN
        BEGIN
          IF Items[N].Level > 1 THEN
            Items[Items[N].TopItem].FullExpand;
          SelectedItem := N;
        END
      ELSE
        MessageDlg('"'+EditFind.Text+'" not found',
          mtInformation, [mbOk], 0);
    END;
end;

procedure TGenViewer.SpdBtnGrabClick(Sender: TObject);
begin
  RepForm.GrabLine(Outline1);
end;

procedure TGenViewer.Outline1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Outline1.BeginDrag(False);
end;

procedure TGenViewer.FormCreate(Sender: TObject);
begin
  AlreadyLoaded := FALSE; {for reg. view}
end;

PROCEDURE TGenViewer.ReloadData;
BEGIN
  IF AlreadyLoaded THEN
    SpeedBtnLoadClick(Self);
END;

procedure TGenViewer.SpeedBtnLoadClick(Sender: TObject);
VAR
  LastItem : LongInt;

  PROCEDURE OneKey(hkFrom : hKey; SubKey : PChar; CurParent : LongInt);
  VAR
    hkNew          : hKey;
    buff, value    : ARRAY[0..80] OF Char;
    Index          : LongInt;
    ValSize        : LongInt;
  BEGIN
    IF RegOpenKey(hkFrom, SubKey, hkNew) = ERROR_SUCCESS THEN
      BEGIN
        Index := 0;
        WHILE RegEnumKey(hkNew, Index, buff, 80) = ERROR_SUCCESS DO
          BEGIN
            ValSize := 80;
            RegQueryValue(hkNew, buff, value, valSize);
            IF ValSize < 2 THEN
              Outline1.AddChild(CurParent,StrPas(buff))
            ELSE
              Outline1.AddChild(CurParent,StrPas(buff) + ' = ' +
                StrPas(Value));
            LastItem := LastItem + 1;
            OneKey(hkNew, buff, LastItem);
            Index := Index + 1;
          END;
        RegCloseKey(hkFrom);
      END;
  END;

begin
  IF AlreadyLoaded AND (Sender = SpeedBtnLoad) THEN
    IF MessageDlg('Registration database is already loaded. '+
      'Reload?', mtConfirmation, [mbYes, mbNo, mbHelp], 11) <> IDYES THEN
        Exit;
  Outline1.Clear;
  Outline1.Add(0,'\');
  Application.ProcessMessages;
  LastItem := 1;
  Cursor := crHourglass;
  Outline1.BeginUpdate;
  OneKey(HKEY_CLASSES_ROOT, NIL, 1);
  Outline1.FullExpand;
  Outline1.EndUpdate;
  Cursor := crDefault;
  AlreadyLoaded := TRUE;
end;

procedure TGenViewer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  IF Outline1.Tag <> 3 THEN
    Action := caFree;
end;

procedure TGenViewer.FormDestroy(Sender: TObject);
begin
  IF Outline1.Tag = 3 THEN
    BEGIN
      WindowState := wsNormal;
      WITH TIniFile.Create(ChangeFileExt(
        ExtractFileName(Application.ExeName),'.INI')) DO
        try
          WriteInteger('RegView', 'Left', Left);
          WriteInteger('RegView', 'Top', Top);
          WriteInteger('RegView', 'Width', Width);
          WriteInteger('RegView', 'Height', Height);
        finally
          Free;
        END;
    END;
end;

procedure TGenViewer.Viewer1Click(Sender: TObject);
begin
   Find1.Enabled := RepForm.EditFind.Text <> '';
end;

end.
