unit Inimodu;
{2/15/95}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, Outline, StdCtrls, ExtCtrls, Buttons, Menus,
  MyString, NuKeyDlg;

type
  TIniModForm = class(TForm)
    MainMenu1: TMainMenu;
    INIEditor1: TMenuItem;
    DeleteSection1: TMenuItem;
    AddSection1: TMenuItem;
    RemoveKey1: TMenuItem;
    NewKey1: TMenuItem;
    N1: TMenuItem;
    Savefile1: TMenuItem;
    Bevel1: TBevel;
    SpdBtnOpenAll: TSpeedButton;
    SpdBtnShutAll: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    PanelKeyName: TPanel;
    EditKeyVal: TEdit;
    Outline1: TOutline;
    SpdBtnFind: TSpeedButton;
    SpdBtnGrab: TSpeedButton;
    procedure SpdBtnOpenAllClick(Sender: TObject);
    procedure SpdBtnShutAllClick(Sender: TObject);
    procedure Outline1Click(Sender: TObject);
    procedure DeleteSection1Click(Sender: TObject);
    procedure AddSection1Click(Sender: TObject);
    procedure RemoveKey1Click(Sender: TObject);
    procedure NewKey1Click(Sender: TObject);
    procedure EditKeyValKeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SaveWithBackup(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure SpdBtnFindClick(Sender: TObject);
    procedure SpdBtnGrabClick(Sender: TObject);
    procedure Outline1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Outline1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Outline1DragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    { Private declarations }
    IniChanged : Boolean;
    IniName : String;
    ItemWas : LongInt;
    PROCEDURE UpdateKey;
  public
    { Public declarations }
    PROCEDURE LoadFromFile(Filename : String);
  end;


implementation
USES RepFormU, MdiFormU;

{$R *.DFM}

PROCEDURE TIniModForm.UpdateKey;
VAR
  S   : String;
  Loc : Word;
begin
  IF EditKeyVal.Modified THEN
    WITH Outline1 DO
      BEGIN
        S := Items[ItemWas].Text;
        Loc := Pos('=', S);
        S := Copy(S,1,Loc) + EditKeyVal.Text;
        Items[ItemWas].Text := S;
        EditKeyVal.Modified := FALSE;
        IniChanged := TRUE;
      END;
END;

PROCEDURE TIniModForm.LoadFromFile(FileName : String);
VAR
  S : String;
  T : TextFile;
  N, LastSec : Word;
BEGIN
  IniName := Filename;
  Caption := 'Editor - ' +
    ExtractFileName(FileName);
  AssignFile(T, FileName);
  Reset(T);
  N := 0; LastSec := 0;
  WHILE NOT EoF(T) DO
    BEGIN
      ReadLn(T, S);
      S := Trim(S);
      IF S <> '' THEN
        BEGIN
          N := N + 1; {Section? add at top level}
          IF (S[1] = '[') AND (S[length(S)] = ']') THEN
            BEGIN
              Outline1.Add(0, S);
              LastSec := N;
            END
          ELSE
            BEGIN
              {Add below last section. If no last section
               create a blank section head}
              IF LastSec = 0 THEN
                BEGIN
                  Outline1.Add(0, '[(none)]');
                  LastSec := N;
                  N := N + 1;
                END;
              Outline1.AddChild(LastSec, S);
            END;
        END;
    END;
  CloseFile(T);
  Enabled := True;
end;

procedure TIniModForm.Outline1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Outline1.BeginDrag(False);
end;

procedure TIniModForm.Outline1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  WITH Outline1 DO
    IF (Source = Outline1) AND (Y >= 0) THEN
        Accept := (GetItem(X,Y) <> SelectedItem) AND
          (Items[GetItem(X,Y)].Parent = Items[SelectedItem].Parent)
    ELSE Accept := False;
end;

procedure TIniModForm.Outline1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  WITH Outline1 DO
    Items[SelectedItem].MoveTo(GetItem(X,Y), oaInsert);
  IniChanged := True;
end;

procedure TIniModForm.SpdBtnOpenAllClick(Sender: TObject);
begin
  WITH Outline1 DO
    BEGIN
      BeginUpdate;
      FullExpand;
      EndUpdate;
    END;
end;

procedure TIniModForm.SpdBtnShutAllClick(Sender: TObject);
begin
  WITH Outline1 DO
    BEGIN
      BeginUpdate;
      FullCollapse;
      EndUpdate;
    END;
end;

procedure TIniModForm.Outline1Click(Sender: TObject);
VAR
  S : String;
  Loc : Word;
begin
  WITH Outline1, Items[SelectedItem] DO
    BEGIN
      IF SelectedItem = ItemWas THEN Exit;
      UpdateKey;
      ItemWas := SelectedItem;
      S := Text;
      IF (S[1] = '[') OR (S[1] = ';') THEN
        BEGIN
          PanelKeyName.Caption := '';
          EditKeyVal.Text := '';
          EditKeyVal.ReadOnly := TRUE;
        END
      ELSE
        BEGIN
          Loc := Pos('=', S);
          IF Loc = 0 THEN Exit;
          PanelKeyName.Caption := Copy(S, 1, Loc-1);
          EditKeyVal.Text := Copy(S, Loc+1, 255);
          EditKeyVal.Modified := FALSE;
          EditKeyVal.ReadOnly := FALSE;
        END;
    END;
end;

procedure TIniModForm.DeleteSection1Click(Sender: TObject);
VAR
  S : String;
  Item : TOutlineNode;
begin
  IF Outline1.SelectedItem >= 0 THEN
    WITH Outline1 DO
      BEGIN
        Item := Items[SelectedItem];
        S := Item.Text;
        IF S[1] <> '[' THEN
          BEGIN
            Item := Item.Parent;
            S    := Item.Text;
          END;
        IF MessageDlg('Delete section ' + S +
          ' and all the keys it contains?',
          mtConfirmation,
          [mbOK, mbCancel, mbHelp], 8) = IDOK THEN
          BEGIN
            Delete(Item.Index);
            ItemWas := -1;
            Outline1Click(Outline1);
            IniChanged := True;
          END;
      END;
end;

procedure TIniModForm.AddSection1Click(Sender: TObject);
VAR S : String;
begin
  S := '';
  IF InputQuery('Add New Section', 'New Section Name', S) THEN
    BEGIN
      S := Trim(S);
      IF S[1] <> '[' THEN S := '[' + S;
      IF S[length(S)] <> ']' THEN S := S + ']';
      Outline1.Add(0,S);
      IniChanged := TRUE;
    END;
end;

procedure TIniModForm.RemoveKey1Click(Sender: TObject);
begin
  WITH Outline1 DO
    BEGIN
      IF Items[SelectedItem].Level = 1 THEN Exit;
      IF MessageDlg('Remove key "' +
        Items[SelectedItem].Text + '"?',
        mtConfirmation,
        [mbOk, mbCancel, mbHelp], 9) = IDOK THEN
        BEGIN
          Delete(Items[SelectedItem].Index);
          ItemWas := -1;
          Outline1Click(Outline1);
          IniChanged := TRUE;
        END;
    END;
end;

procedure TIniModForm.NewKey1Click(Sender: TObject);
VAR
  S     : String;
  Where : LongInt;
begin
  WITH Outline1 DO
    BEGIN
      WITH Items[SelectedItem] DO
        IF Level = 1 THEN
          BEGIN
            S := Text;
            Where := Index;
          END
        ELSE
          BEGIN
            S := Parent.Text;
            Where := Parent.Index;
          END;
      WITH FormNewKey DO
        BEGIN
          EditName.Text := '';
          EditValue.Text := '';
          PanelSec.Caption := S;
          IF ShowModal = mrOK THEN
            BEGIN
              Items[Where].Expand;
              S := Trim(EditName.Text)
                + '=' + Trim(EditValue.Text);
              SelectedItem := AddChild(Where, S);
              IniChanged := TRUE;
            END;
        END;
    END;
end;

procedure TIniModForm.SaveWithBackup(Sender: TObject);
VAR
  N : Word;
  T : TextFile;
  S : String;
  BakName, TmpName : String;
begin
  UpdateKey;
  BakName := ChangeFileExt(IniName, '.~IN');
  TmpName := ChangeFileExt(IniName, '.$$$');
  Screen.Cursor := crHourglass;
  AssignFile(T, TmpName);
  Rewrite(T);
  try
    WITH Outline1 DO
      IF ItemCount > 0 THEN
        BEGIN
          S := Items[1].Text;
          {Don't write "(none)" section header}
          IF S <> '[(none)]' THEN
            WriteLn(T, S);
          FOR N := 2 TO ItemCount DO
            BEGIN
              S := Items[N].Text;
              {Insert a blank line before section header}
              IF S[1] = '[' THEN WriteLn(T);
              WriteLn(T, S);
            END;
        END;
  finally
    System.Close(T);
  end;
  DeleteFile(BakName);
  Screen.Cursor := crDefault;
  IF RenameFile(IniName, BakName) THEN
    IF RenameFile(TmpName, IniName) THEN
      BEGIN
        {flush cached values}
        IniName[length(IniName)+1] := #0;
        WritePrivateProfileString(NIL, NIL, NIL, @IniName[1]);
        IniChanged := FALSE;
        IF MessageDlg(IniName + ' was changed.  '+
          'Changes may not take effect until you '+
          'restart Windows.  Restart now?',
         mtConfirmation, [mbYes, mbNo, mbHelp], 17) = IDYES THEN
           ExitWindows(EW_RESTARTWINDOWS, 0);
      END;
end;

procedure TIniModForm.EditKeyValKeyPress(Sender: TObject; var Key: Char);
begin
  IF Key = #13 THEN
    BEGIN
      Key := #0;
      UpdateKey;
    END;
end;

procedure TIniModForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  UpdateKey;
  IF IniChanged THEN
    CASE MessageDlg('INI file ' + IniName +
      ' has changed.  Save?',
      mtConfirmation, [mbYes, mbNo, mbCancel, mbHelp], 7) OF
      ID_YES : SaveWithBackup(Sender);
      ID_NO  : ; {don't bother}
      ID_CANCEL : CanClose := FALSE;
    END;
end;

procedure TIniModForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TIniModForm.FormResize(Sender: TObject);
begin
  EditKeyVal.Width := Width - 168;
  PanelKeyName.Width := EditKeyVal.Width;
end;

procedure TIniModForm.SpdBtnFindClick(Sender: TObject);
VAR
  N, LastN : Word;
  Found : Boolean;
begin
  WITH Outline1, RepForm DO
    BEGIN
      IF EditFind.Text = '' THEN
        BEGIN
          MessageDlg('Please enter a value in the Find What line '+
            ' of the Find and Replace window', mtInformation,
            [mbOk, mbHelp], 10);
          Exit;
        END;
      IF ItemCount = 0 THEN Exit;
      N := SelectedItem;
      IF N < 1 THEN N := 1;
      IF N = 1 THEN LastN := ItemCount
      ELSE LastN := N-1;
      Found := False;
      WHILE (NOT Found) AND (N <> LastN) DO
        BEGIN
          N := N + 1;
          IF N > ItemCount THEN N := 1;
          Found := Contains(Items[N].Text, EditFind.Text,
            MainForm.MatchCase1.Checked);
        END;
      IF Found THEN
        BEGIN
          IF Items[N].Level > 1 THEN
            Items[Items[N].TopItem].FullExpand;
          SelectedItem := N;
        END
      ELSE
        MessageDlg('"'+EditFind.Text+'" not found',
          mtInformation, [mbOk], 0);
    END;
end;

procedure TIniModForm.SpdBtnGrabClick(Sender: TObject);
begin
  RepForm.GrabLine(Outline1);
end;

end.
