/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: error.cpp $
* Version:      $Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Module to implement default error handling.
*
* $Id: error.cpp 1.2 1995/09/16 11:16:06 kjb release $
*
****************************************************************************/

#include "tcl\error.hpp"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

/*--------------------------- Global Variables ----------------------------*/

// Pointer to the currently installed error handler

void (*TCL_errorHandler)(int err) = TCL_defaultErrorHandler;

/*---------------------------- Implementation -----------------------------*/

void TCL_defaultErrorHandler(int err)
{
	cerr << "TECH: ";

	switch (err) {
		case STK_UNDERFLOW:
			cerr << "Stack underflow!\n";
			break;
		case STK_OVERFLOW:
			cerr << "Stack overflow!\n";
			break;
		default:
			cerr << "Unknown internal error!\n";
		}
	exit(EXIT_FAILURE);
}

void _TCL_checkFail(char *msg,char *cond,char *file,int line)
{
	fprintf(stderr,msg,cond,file,line);
	exit(EXIT_FAILURE);
}
