
request transform

#define AddThisDirectory                        ;
    !( left( aDir_[n,1], 1 ) == "." )

#define N_TOTALSPACE                            ;
    transform(nDisk,"999,999,999")

#define N_FREESPACE                             ;
    transform( diskspace(                       ;
    DriveNumber(cDrive)),                       ;
    "999,999,999")

#define C_DPARAM                                ;
    cVar +                                      ;
    if(len(aArray_) == 0,"*.*","\*.*")

#xtranslate NtoS(<n>) =>                        ;
    ltrim(str(<n>))

static nFsize, nNumFiles

function GetDirInfo(cVar)
    local aArray_
    local nLen
    local nDisk
    local nRow 
    local cDrive
    local cFree
    local cSpace
    local cTmp
    local nCursor := setcursor(0)

    if empty(nLen := len(cVar := alltrim(cVar)))
        ?"missing directory name"
        setcursor(nCursor)
        RETURN -1
    endif

    cVar := upper(cVar)

    if nLen == 3
        cVar := left(cVar,2)
        cTmp := cVar + "PRN"
    elseif nLen == 1
        cVar += ":"
    elseif nLen >3
        if right(cVar,1) == "\"
            cTmp := cVar + "PRN"
        else
            cTmp := cVar + "\PRN"
        endif
    endif

    // is drive available
    if .not. file(left(cVar,1) +":\PRN")
        ?"Drive not ready " + left(cVar,1)
        quit
    endif

    // is path valid
    if cTmp != nil
        if .not. file(cTmp)
            ?"Directory " + cVar + " not located"
            quit
        endif
    endif

    cVar      := strtran(strtran(cVar,"\*.*",""),"\*.")
    nFsize    := 0
    nNumFiles := 0
    nRow      := row()
    @nRow,0 say "Working..." 
    aArray_   := GetTree(cVar)

    aeval( directory( C_DPARAM, "HS"),{|a| nFsize += a[2], nNumFiles++ })

    cDrive    := upper(left(cVar,1))
    cSpace    := NtoS(ft_dskfree() / (nDisk := ft_dsksize()))
    cFree     := if( ft_dskfree() == ft_dsksize(), "100", cSpace )
    @nRow,0
    ?"   "  + cVar
    ?"    " + ltrim(transform(nFsize,"999,999,999")) +" total bytes in "
    ??ltrim(transform(nNumFiles,"999,999,999")) + " files"

    ?" Drive usage"
    ?"  " + N_TOTALSPACE + " bytes available on drive " + cDrive + ":"
    ?"  " + N_FREESPACE  + " bytes unused on drive "    + cDrive + ":,"
    ??strtran(cFree,"0.","") + "% unused"
    setcursor(nCursor)

    nFsize    := 0
    nNumFiles := 0
return 0

static function _Tree(cCurr)
    local aDir_
    local aTree_
    local nLen, n
    local nKey := inkey()
    local cName

    // see if we should continue if user pressed ESC
    if nKey == 27
        if alert("Abort",{"No","Yes"}) == 2
            quit
        endif
    endif

    aDir_  := directory(cCurr + "\*.*","DH")
    aTree_ := {}

    nLen := len(aDir_)
    for n := 1 to nLen
        if .not. left(aDir_[n,1],1) == "."
            cName := cCurr +"\"+ aDir_[n,1]+"\*.*"
            aeval(directory(cName,"HS"),{|a_| nFsize += a_[2], nNumFiles++ })
        endif
    next

    for n := 1 to len(aDir_)
        if aDir_[ n,5 ] == "D" .or. aDir_[ n,5 ] == "HD"
            if AddThisDirectory
                aAdd(aTree_,{aDir_[n,1],_Tree(cCurr + "\" + aDir_[n,1])})
            endif
        endif
    next
return aTree_

function GetTree(cDrive)
return _Tree(cDrive)

/*
*   Routine: DriveNumber(<cDrive>) 
*          : 
*   Purpose: returns a numeric for <cDrive> for use with functions like
*          : diskspace()
*          : 
* Arguments: <cDrive>   drive letter i.e. A: B: C: (without the colon)
*          : 
*  Comments: If a letter from A to Z is passed this routine returns the 
*          : element number where <cDrive> was found in aArr_ array.
*          : Note the lines have been broken down so it is easy to read
*          : the code.
*/
static function DriveNumber(cDrive)
return if(valtype(cDrive) == "C",                                   ;
    (   ascan(                                                      ;
        {                                                           ;
            "A","B","C","D","E","F","G","H","I","J","K","L",        ;
            "M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z" ;
         }, upper(cDrive)                                           ;
         )                                                          ;
    ) ,                                                             ;
        -1                                                          ;
)

