/*Ŀ
 ݳ                                                                         
 ݳ Program Name: LOAD.PRG          Copyright: Oregon Dept. Of Revenue      
 ݳ Date Created: 05/08/95           Language: Clipper 5.0                  
 ݳ Time Created: 19:18:11             Author: Kevin S Gallagher            
 Ĵ
 ݳ There are two routines contained here that fill arrays with either      
 ݳ directory names, or filenames.  LoadDir() and LoadFiles()               
 ݳ                                                                         
 ݳ  Use /dKG_TEST to compile for demoing                                  
 ݳ  Both routines could be coded with abunch less code if you eliminate   
 ݳ   error-checking.                                                       
 ݳ  Several support routines are included for the directory functions     
 ݳ  Each routine has a header with important information about it.        
 ݳ                                                                         
 ݳ                                                                         
 ݳ C>clipper load /n/m/w/dKG_TEST                                          
 ݳ C>blinker file load lib nanfor                                          
 
            */

#include "ftint86.ch"

#define D_UNKNOWN_ERROR -1
#define D_INVALID_PATH  -2
#define D_NOFILES        0

#xtranslate NtoS(<n>) =>;
    ltrim(str(<n>))

#ifdef KG_TEST
*
* This test module is tailored to my computer, and must be modified to
* conform to the directory structure on your system.
* Many programmers install CA-Clipper in C:\CLIPPER5, and i have it in
* C:\CLIPPER, which is what this module is setup for. Also i assume you
* have DOS installed under C:\DOS.
*
procedure main
    local aArray_
    local nLen
    local cPath := "c:\clipper"

    cls

    // get all sub-directories beneath C:\CLIPPER
    nLen := loaddir(@aArray_,cPath)
    if nLen > 0
        aeval(aArray_,{|a| qout(a)})
    else
        ?"No sub-directories in " + cPath
    endif
    ?
    ?

    // attempt to build array of various files within C:\DOS
    cPath:= "c:\dos"
    nLen := loadFiles(@aArray_,cPath,"a*.exe,d*.com,m*.ovl,de*.exe")
    if nLen >0
        ?"Press any key to see " + NtoS(nLen) + " file(s) found in " + cPath
        inkey(0)
        aeval(aArray_,{|a| qout(a),inkey(1)})
    else
        if nLen == D_UNKNOWN_ERROR
            ?"one or more errors occured while using LoadFiles()"
        elseif nLen == D_INVALID_PATH
            ?"Path not found '" + cPath + "'"
        elseif nLen == D_NOFILES
            ?"No file(s) matched your specs"
        endif
    endif
    ?
    ?

    // The path C:\KLIPPER does not exist - obvious error
    cPath:= "c:\klipper"
    nLen := loadFiles(@aArray_,cPath,"a*.exe,d*.com,m*.ovl,de*.exe")
    if nLen >0
        ?"Press any key to see " + NtoS(nLen) + " file(s) found in " + cPath
        inkey(0)
        aeval(aArray_,{|a| qout(a),inkey(1)})
    else
        if nLen == D_UNKNOWN_ERROR
            ?"one or more errors occured while using LoadFiles()"
        elseif nLen == D_INVALID_PATH
            ?"'"+ cPath + "' not found, you may want to check the spelling!"
        elseif nLen == D_NOFILES
            ?"No file(s) matched your specs"
        endif
    endif
    ?
    ?

    // C:\CLIPPER exist but has no PPO files
    cPath:= "c:\clipper"
    nLen := loadFiles(@aArray_,cPath,"a*.ppo")
    if nLen >0
        ?"Press any key to see " + NtoS(nLen) + " file(s) found in " + cPath
        inkey(0)
        aeval(aArray_,{|a| qout(a),inkey(1)})
    else
        if nLen == D_UNKNOWN_ERROR
            ?"one or more errors occured while using LoadFiles()"
        elseif nLen == D_INVALID_PATH
            ?"'"+ cPath + "' not found, you may want to check the spelling!"
        elseif nLen == D_NOFILES
            ?"No file(s) matched your specs"
        endif
    endif
return
#endif

/*
*   Routine: LoadDir( <aArray_>, <cPath> ) --> N
*          : 
*   Purpose: Used to load an array with only directory names
*          : 
* Arguments: <aArray>   pass it by reference
*          : 
*          : <cPath>    path to build array from
*          : 
*  Comments: This function is for novice programmers or lazy
*          : programmers who do not want to re-code the same
*          : old routine time and time again.
*          : 
*   Returns: Length of the array, or zero if no directories
*          : in <cPath> and -1 if errors, such as <cPath>
*          : directory was not found.
*          : 
*/
function loaddir(aArray_,cPath)
    local aDirs_ := {}
    local cSpecs
    local nLen
    local nCount := 0
    local i

    if ft_isdir(cPath) .and. valtype(cPath) == "C"
        cSpecs  := strtran(alltrim(cPath),"*.*","")

        if right(cPath,1) == "\"
            cSpecs += "*.*"
        else
            cSpecs += "\*.*"
        endif

        if (nLen := len(aArray_ := directory(cSpecs,"HD"))) > 0
            for i := 1 to nLen
                if aArray_[i,5] == "D" .or. aArray_[i,5] == "HD"
                    if !(left(aArray_[i,1],1) == ".")
                        aadd(aDirs_,aArray_[i,1])
                        ++nCount
                    endif
                endif
            next
        else
            nCount := 0
        endif
        aArray_ := asort(aDirs_)
    else
        aArray_ := {}
        nCount  := -1
    endif
return nCount

/*
*   Routine: LoadFiles(<aArray_>,<cPath>,<cTypes>,<lHidden>) --> N
*          : 
*   Purpose: Used tp load an array with filenames
*          : 
* Arguments: <aArray_>  pass it by reference, to hold filenames
*          : 
*          : <cPath>    path to get filenames from for aArray_
*          : 
*          : <cType>    a character string that has one type of file
*          :            or a delimited string of multiple file types
*          :            which are delimited by chr(59).
*          : 
*          : <lHidden>  a logical which determines if hidden files
*          :            are to be included in the return array
*          : 
*   Returns: Length of the array, or zero if no directories
*          : in <cPath> and -1 if errors, such as <cPath>
*          : directory was not found.
*          : 
*  Comments: 
*          : 
*/
function LoadFiles(aArray_,cPath,cTypes,lHidden)
    local i
    local nLen
    local cSpecs
    local cDelimitor:= ""
    local lDelimitor:= .f.
    local aFiles_   := {}
    local aHouse_   := {}
    local aCombine_ := {}
    local nCount    := 0
    local oErrHand  := errorblock({|e| break(e)})
    local oMy

    begin sequence
        lHidden   := if(lHidden == nil,.f.,lHidden)
        lDelimitor:= DelimChar(cTypes,@cDelimitor)
        if ft_isdir(cPath)
            cPath := alltrim(cPath)
            if lDelimitor
                aFiles_ := KG_StoA(cTypes,cDelimitor)
                if !empty(nLen := len(aFiles_))
                    for i := 1 to nLen
                        cSpecs  := cPath + "\" + aFiles_[i]
                        cSpecs  := strtran(cSpecs,"\\","\")
                        aHouse_ := directory(cSpecs,if(lHidden,"HS",))
                        if !empty(aHouse_)
                            aHouse_ := asort(aHouse_)
                            aeval(aHouse_,{|a| aadd(aCombine_,a[1]),++nCount})
                        endif
                    next
                    aArray_ := aCombine_
                else
                    aArray_ := {}
                endif
            else
                if right(cPath,1) == "\"
                    cSpecs  := cPath + cTypes
                else
                    cSpecs  := cPath + "\" + cTypes
                endif
                aArray_ := {}
                cSpecs  := cPath + "\" + cTypes
                if !empty(aHouse_ := directory(cSpecs,if(lHidden,"HS",)))
                    aeval(aHouse_, {|a| aadd(aArray_,a[1]),++nCount})
                    aArray_ := asort(aArray_)
                endif
            endif
        else
            aArray_ := {}    
            nCount  := -2
        endif
    recover using oMy
        nCount := -1
        aArray_:= {}
    end sequence
    errorblock(oErrhand)
return nCount

/*
*   Routine: ft_isdir(<cDir>) --> L
*          : 
*   Purpose: Test the existence of a directory
*          : 
* Arguments: <cDir> directory to test if it exist or not.
*          : 
*   Returns: logical true if cDir exist and logical false if not
*          : 
*  Comments: This code was downloaded from CIS from the Clipper
*          : forum. It was labeled as Public Domain
*          : 
*/
function ft_isdir(cDir)
    local aRegs[ 10 ]

    iif(!(Right(cDir,1)=="\"),cDir+= "\", )

    aRegs[AX] := makehi(78)
    aRegs[DS] := cDir + "*.*" + chr( 0 )
    aRegs[DX] := REG_DS
    aRegs[CX] := 63

    FT_Int86(33,aRegs)

return (aRegs[FLAGS] % 2 == 0)

/*
*   Routine: KG_StoA(<cString>[, <cDelim>]) --> A
*          : 
*   Purpose: converts a delimited character string into an array
*          : 
* Arguments: <cString>  string to convert into an array
*          : 
*          : <cDelim>   optional, wihich defaults to chr(44) 
*          : 
*  Comments: If your lazy and always use the same delimitor, then
*          : change the default below to your fav delimitor.
*/
function KG_StoA(cString, cDelim)
    local nEle, aArray_ := {}
    if valtype( cString ) == "C"
        cDelim  := IF(cDelim == NIL, ",", cDelim)
        cString := ALLTRIM(cString)
        WHILE (nEle := AT(cDelim, cString)) <> 0
            aadd(aArray_, IF(nEle > 1, rtrim(left(cString, nEle-1)), ""))
            cString := if(len(cString) > nEle,ltrim(subs(cString,nEle+1)),"")
        ENDDO
        aadd(aArray_, cString)
    endif
return(aArray_)

/*
*   Routine: DelimChar(<cType>,<cDelimitor>)
*          : 
*   Purpose: internal use to determine a delimitor for KG_StoA()
*          : 
* Arguments: <cType>        character string
*          : <cDelimitor>   character string passed by reference
*          : 
*  Comments: By passing <cDelimitor> by reference we can return
*          : two things - the delimtor to use and a logical that
*          : tells the caller we have a delimitor to use. You
*          : could achive the same results in several other ways
*          : with arrays or file-wide variables if desired.
*/
static function DelimChar(cType,cDelimitor)
    cDelimitor := ""
    if ";" $ cType
        cDelimitor := ";"
    elseif ":" $ cType
        cDelimitor := ":"
    elseif "," $ cType
        cDelimitor := ","
    elseif "|" $ cType
        cDelimitor := "|"
    endif
return .not. empty(cDelimitor)
