/*Ŀ
 ݳ                                                                      
 ݳ Program Name: JUNK.PRG          Copyright: Oregon Dept. Of Revenue   
 ݳ Date Created: 05/07/95           Language: Clipper 5.0               
 ݳ Time Created: 13:52:31             Author: Kevin S Gallagher         
 Ĵ
 ݳ PURPOSE:                                                             
 ݳ To seek out unwanted file(s) and query the operator to either delete 
 ݳ each file or not to delete it. Deletion if requested will fail on    
 ݳ files that have RO,System or hidden attributes. Also i do not try to 
 ݳ touch file(s) residing in the root directory. If a install program   
 ݳ has altered your startup files it may have renamed them with .BAK    
 ݳ and you might want to keep them!                                     
 ݳ                                                                      
 ݳ By default when compiling this utility it will NOT remove files even 
 ݳ if you respond to the prompts with <Y>. You must review the code and 
 ݳ compile with the proper constant with #define or /d                  
 ݳ                                                                      
 ݳ There is some C code which is commented out, and may be used to      
 ݳ alter the hit list of junk files by cycling through the DOS command  
 ݳ line for adding to the hit list or creating a fresh hit list.        
 Ĵ
 ݳ REQUIRES:                                                            
 ݳ The Nanforum ToolKit, which could be eliminated since i use it for   
 ݳ showing disk information and is not used for anything to do with the 
 ݳ main purpose of this utility.                                        
 
            */

#include "trees.h"

static aTank_ := {}

static aHitList_

function GetDirInfo(cVar)
    local aKill_
    local aArray_
    local aFiles_
    local cDrive
    local cExt
    local nLen
    local nErr
    local n,i,z,k
    local nCursor := setcursor(0)

    if empty(nLen := len(cVar := alltrim(cVar)))
        ?"Missing Drive"
        setcursor(nCursor)
        RETURN -1
    endif                  

    // enable DOS help by defining this constant, default is no help.
    #ifdef KG_ABOUT
    if "/" $ cVar .or. "-" $ cVar .or. "?" $ cVar
        about()
    endif
    #endif

    if aHitList_ == nil
        FillHits()
    endif

    cVar := upper(cVar)

    if nLen >1
        cVar := left(cVar,1) + ":"
    elseif nLen == 1
        cVar += ":"
    endif

    // for non-networked drives
    if .not. file(cVar + "\PRN")
        ?"Drive not ready " + cVar
        quit
    endif

    @0,0 say " Working please wait... " color "w+*/r"

    aTank_  := {}
    aKill_  := {}
    aArray_ := GetTree(cVar)
    cDrive  := upper(left(cVar,1))

    if !empty(nLen := len(aTank_))
        cls
        @0,0 say padr("Searching for Junk files on drive " + cDrive,80)
        for n := nLen to 1 step -1
            @1,0 say padr(aTank_[n],80)
            if !empty(aArray_ := directory(aTank_[n] + "\*.*") )
                if inkey() == 27
                    if alert("Abort",{"Yes","No"}) == 1
                        quit
                    endif
                endif
                for i := 1 to len(aArray_)
                    if (z := at(".",aArray_[i,1])) > 0
                        cExt := substr(aArray_[i,1],z,4)
                        if (k := ascan(aHitList_,{|xx| xx == cExt} )) > 0
                            aadd(aKill_,aTank_[n] + "\" + aArray_[i,1])
                        endif
                    endif
                next
            endif
        next

        if !empty(aKill_)
            @1,0
            nLen := len(aKill_)
            for k := 1 to nLen
                DelFile(aKill_[k])
            next
        else
            ?"Nothing to remove!"
        endif
        // do root directory here (should have junk files here).
    else
        ?"Must specify a Drive..."
        quit
    endif

    aTank_    := {}

    #ifdef _SHOW_DISKINFO_
    KG_DiskInfo(cDrive)
    #endif

    setcursor(nCursor)

return 0

/*
*   Routine: _Tree(<cCurr>)
*          : 
*   Purpose: used to get all directories on the specified disk
*          : 
* Arguments: <cCurr> next path
*          : 
*  Comments: Since we are using recursion watch out for stack
*          : problems and array boundary errors.
*          : 
*/
static function _Tree(cCurr)
    local aDir_
    local aTree_
    local n
    local nKey := inkey()
    local cName

    if "\\" $ cCurr
        ?chr(7) + "Invalid path specified..."
        quit
    endif

    // see if we should continue if user pressed ESC
    if nKey == 27
        if alert("Abort",{"No","Yes"}) == 2
            quit
        endif
    endif

    aDir_  := directory(cCurr + "\*.*","DH")
    aTree_ := {}

    for n := 1 to len(aDir_)
        if aDir_[ n,5 ] == "D" .or. aDir_[ n,5 ] == "HD"
            if AddThisDirectory
                aadd(aTank_,cCurr +"\"+ aDir_[n,1])
                aAdd(aTree_,{aDir_[n,1],_Tree(cCurr + "\" + aDir_[n,1])})
            endif
        endif
    next
return aTree_

function GetTree(cDrive)
return _Tree(cDrive)

/*
*   Routine: DriveNumber(<cDrive>)
*          :
*   Purpose: returns a numeric for <cDrive> for use with functions like
*          : diskspace()
*          :
* Arguments: <cDrive>   drive letter i.e. A: B: C: (without the colon)
*          :
*  Comments: If a letter from A to Z is passed this routine returns the
*          : element number where <cDrive> was found in aArr_ array.
*          : Note the lines have been broken down so it is easy to read
*          : the code.
*/
static function DriveNumber(cDrive)
return if(valtype(cDrive) == "C",                                   ;
    (   ascan(                                                      ;
        {                                                           ;
            "A","B","C","D","E","F","G","H","I","J","K","L",        ;
            "M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z" ;
         }, upper(cDrive)                                           ;
         )                                                          ;
    ) ,                                                             ;
        -1                                                          ;
)

/*
*   Routine: FilHits()
*          : 
*   Purpose: used to define types of files to seek and eliminate
*          : 
* Arguments: none
*          : 
*  Comments: By using an array rather then a constant you can allow
*          : the hit-list to be modified at runtime. I use abit of
*          : help from two C routines (goto EOF for code) that by
*          : first seeing if there were params passed then if they
*          : meet my conditons make them the hit-list or add them to
*          : the hit-list. Questions, drop me a line on CIS.
*          : 
*/
static procedure FillHits()
    aHitList_ :=    ;
        { ".BAK", ".~", ".CHK", ".TMP", ".MAP", ".LOG", ".LST",     ;
          ".LIS", ".PPO"                                            }
return

/*
*   Routine: DelFile( <cName> )
*          : 
*   Purpose: Used to remove a file from disk
*          : 
* Arguments: <cName> contains a path and the filename to possibly delete
*          : 
*  Comments: First the user must press Y to delete <cName> or N to abort
*          : deletion. Other keys cause us to loop until either Y or N
*          : is entered.
*          : 
*          : I do not show ferror() on failure, and do not attempt to
*          : alter the files attributes in the event that the file had
*          : ReadOnly attributes you could remove it with ft_int86() in
*          : Nanforum library, Funcky or CA-Tools, or shell to DOS and
*          : use the DOS command attrib.exe
*          : 
*/
static procedure DelFile(cName)
    local lFlag,cKey
    while lFlag == NIL
        ?"Delete " + cName + " N/Y "
        if (cKey := upper( chr( inkey(0)))) $ "YN"
            lFlag := (cKey == "Y")
            #ifdef KG_DELFILES
            if ferase(cName) == -1
                qqout(" error removing")
            else
                qqout(" deleted")
            endif
            #else
            qqout(if(lFlag," delete it"," aborting" ) )
            #endif

        endif
    enddo
return

#ifdef KG_ABOUT
procedure about()
    ?
    ?"Search & Destroy Junk Files, Version 1.00 - by Kevin S. Gallagher 1995"
    ?"     Usage: Junk [d]"
    ?
    ?"The parameter [d] represents the drive to search for junk file(s)"
    ?"This utility will first search the entire drive specified and then if any junk"
    ?"file(s) are located you will be asked if it should be removed or not. Simply"
    ?"Answer with <Y>es or <N>o to process the current file."
    quit
return
#endif

#ifdef _SHOW_DISKINFO_
procedure KG_DiskInfo(cDrive)
    local cSpace
    local cFree
    local nDisk

    cSpace    := NtoS(ft_dskfree() / (nDisk := ft_dsksize()))
    cFree     := if( ft_dskfree() == ft_dsksize(), "100", cSpace )

    ?
    ?" Drive usage"
    ?"  " + N_TOTALSPACE + " bytes available on drive " + cDrive + ":"
    ?"  " + N_FREESPACE  + " bytes unused on drive "    + cDrive + ":,"
    ??strtran(cFree,"0.","") + "% unused"

return
#endif

****************************************************************************
** Compile with your C compiler                                           ** 
** cl /AL /W3 /G2s /Zlp /Fo$(o)\$* /c $args.c                             ** 
****************************************************************************
**   #include <extend.h>
**   #include <string.h>
**   #include <stdio.h>
**   
**   extern int __argc;
**   extern unsigned char**  __argv;
**   
**   Purpose: get count of parameters passed to the program, type numeric
**   CLIPPER getargc( void )
**   {
**       _retni( __argc - 1 );
**   }
**   
**   
**   Purpose: returns any parameters passed to the application, type char's
**   CLIPPER getargv( void )
**   {
**       int argnum;
**   
**       if (PCOUNT && ISNUM(1))
**           argnum = _parni( 1 );
**       else
**           argnum = 0;
**   
**   
**       if (argnum >= ( __argc ))  
**           _retc("");
**       else
**           _retclen( __argv[argnum], strlen( __argv[argnum]) );
**   
**   }
**   

#stdout ------------------------------------------------------------------------------
#ifdef KG_DELFILES
#stdout Compiling to allow removal of files
#else
#stdout Compiling in demo mode
#endif
