*****
* Langage     : CLIPPER 5.0 VF
* Version      : 1.1
* Date         : 30/10/92
* Auteur       : Philippe Bonnardel
* Objet        : Filtrage d'une Base de donne indexe. 
*              : L'utilisateur agit interactivement en tapant la cl du filtre
* Compilation  : /M/L/W
* Lien         : LineAide, Shadow
* Remarques    : Les champs indexs doivent tre de type Caractre seulement.
*              : Marc Mirville est l'auteur des code blocks du browse
*              : (Point DBF n 20) 
*****

// Fichiers de dfinition pour le prprocesseur
#include "inkey.ch"
#include "setcurs.ch"
#include "Box.ch"

#define MM_COMPILE(chaine) &("{||"+chaine+"}")

// Bordure du browse
#define HSEP          ""
#define CSEP          "  "
#define FSEP          ""

// Couleurs du programme
#define C_WIN           "G+/B"                  // couleur de la fentre
#define C_GET           "RB+/B, N/W"            // Couleurs du Get
#define C_BROWSE        "GR+/B, N/W, B+/B"      // Couleurs du browse
#define C_TOUCHE        "R+/B"                  // Couleur des touches
#define C_TEXT          "W+/B"                  // Couleur du texte

// Dfinitions du tableau aChamp 
#define F_CHAMP         1       // Nom du champ dans la base
#define F_NOM           2       // Nom  afficher
#define F_ORDER         3       // N de l'index correspondant
#define F_LENGET        4       // Longueur du get de la cl de filtre
#define F_XVALUE        5       // Contenu initial du get
#define F_PICT          6       // Picture du get

// Dfinitions pour le tableau aRect
#define W_TOP           1
#define W_LEFT          2
#define W_RIGHT         3
#define W_BOTTOM        4

* * *
*
*       Fonction InterFilt (aChamp, cTitre, cAlias, nLarg, nLong, lScrol)
*               - Fonction  appeler
*               - Paramtres :
*                   + aChamp : {"Nom du champ de la base", "Nom  afficher",
*                               Numro de l'index correspondant (0 si aucun),
*                               Longueur du Get de saisie,
*                               "Contenu prdfini du get", "Picture du get"} 
*                     Ex.: aChamp := {{"VILLE"    , "Ville", 1, 6, "A", "@!"}, 
*                                     {"CODE_POST", "CP"   , 0}}       
*                   + cTitre : "Titre de la fentre"
*                   + cAlias : "Alias de la base de donnes  filtrer"
*                   + nLarg  : Largeur de la fentre
*                   + nLong  : Longueur de la fentre
*                   + lScrol : Valeur logique pour afficher ou non le 
*                              scrollbar horizontal
*
*               - La fonction retourne un tableau contenant :
*                  1      Le recno() slectionn
*                  2      Le nom du champ ayant le filtre actif
*                  3      Le contenu du filtre actif
*                  4      Le contenu des champs dans l'ordre de aChamp
*                         de l'enr. slectionn
*                     
* * *

FUNCTION InterFilt (aChamp, cTitre, cAlias, nLarg, nLong, lScrol) 
LOCAL nOldOrder, nOldRecno, nOldSelect, cOldScreen:="", cOldColor, cOldAide
LOCAL nOldCurs, bInsSave, lModif, i, lUp, lDown
LOCAL Index, nRow, nCol, nKey, cKey, nMaxCol
LOCAL aReturn := {}, g, b, aRect := ARRAY (4), aScrol

// Sauve les donnes de la base courante
nOldOrder := INDEXORD()         // le numro de l'index courant
nOldRecno := RECNO ()           // l'enr. actif
IF cAlias != NIL
     nOldSelect := SELECT ()    // Le numro de la base de donne courante
     SELECT (SELECT(cAlias))    // Slectionne la base  filtrer
ENDIF

// Scrolbar ou non ?
lScrol := IF (lScrol == NIL, .F., lScrol)   // si NIL ==> .F.

// Construit le browse : b = instance du browse
MakeBrowse (@aRect, @b, aChamp, nLarg, nLong, lScrol)

// sauve l'environnement et en cre un
cOldColor := SETCOLOR (C_WIN)
cOldScreen := SaveScreen(aRect[W_TOP], aRect[W_LEFT], aRect[W_BOTTOM] + 1, aRect[W_RIGHT] + 2)
bInsSave := SETKEY (K_INS)

// Programme la touche 'Inser' pour qu'elle gre l'aspect du curseur
SETKEY (K_INS,{|| IF(ReadInsert(!ReadInsert()), SETCURSOR (SC_SPECIAL1),; 
        SETCURSOR (SC_NORMAL))})
nOldCurs := SETCURSOR (IF(ReadInsert(), SC_NORMAL, SC_SPECIAL1))

// Construit l'interface
MakeWin (aRect, cTitre, lScrol, @aScrol)

// Cherche le premier champ ayant un index 
// Considre qu'il en existe au moins un...
i := 1
DO WHILE (aChamp[i][F_ORDER] == 0)
        i++
ENDDO

// Construit le filtre et le get : g = instance du get
MakeFilter (aChamp, @g, aRect, @Index, i, @nRow, @nCol, @nMaxCol)

* Codes block de dplacement dans le browse et de filtrage      
* g:Buffer() = contenu du get  l'instant t                     
* ==> filtrage de la Base selon la cl saisie par l'utilisateur 
b:goTopBlock := { || MM_Haut (RTRIM(g:Buffer())) }
b:goBottomBlock := { || MM_Bas (RTRIM(g:Buffer())) }
b:skipBlock := {|n| MM_Deplace (n, RTRIM(g:Buffer()), Index, @lUp, @lDown, b)}

// Place le scrolbar horizontal s'il existe
// b:ColPos() = colonne active dans le browse
// b:ColCount() = nbre total de colonnes dans le browse
IF (lScrol)
        HScrolBarUpdate (aScrol, b:ColPos(), b:ColCount(), .T.)
ENDIF

lModif := lUp := lDown := .T.

// Cherche le premier enr. correspondant  la cl de l'index
GO TOP
SEEK RTRIM(g:Buffer())

DO WHILE (.T.)
     
     // si aucun enr. ne correspond  la cl du filtre => browse vide
     IF EOF()
          b:GoTop() 
          SKIP + 1
          lModif := b:Autolite := .F.  // empche alors la surbrillance
     ELSEIF ! b:Autolite .and. lModif
        // remet la surbrillance car filtre non vide
        b:Autolite := .T.                
     ENDIF
     
     // si l'action de l'utilisateur concerne le browse ==> demande de 
     // rafrachir  son contenu
     IIF (lModif, b:RefreshAll(), lModif := .T.)
     
// Enlever les fonctions de tampon vido si l'affichage est trop lent
***  BEGINPAINT ()  // Pour clipper 5.0
***  DISPBEGIN ()   // Pour Clipper > 5.0
        DO WHILE ! b:stabilize().AND.(nKey:=INKEY())==0  // mise  jour du browse
        ENDDO
***  DISPEND ()    // Pour Clipper > 5.0
***  ENDPAINT ()   // Pour Clipper 5.0
   
     // si la mise  jour du browse est complte
     IF b:stable 
          // force l'affichage du curseur
          SETCURSOR (IF(ReadInsert(), SC_NORMAL, SC_SPECIAL1))
          SETPOS (nRow, nCol)  // Met le curseur  sa place dans le get
          nKey := inkey(0)
     ELSE
        SETCURSOR (SC_NONE)// efface le curseur car browse non stable
                           // empche que le curseur se promne...
     ENDIF
     
     DO case
          
          // Si code block associ  une touche
          case SETKEY(nKey) != NIL
               EVAL (SETKEY(nKey), PROCNAME(0), PROCLINE(0), "")
               lModif := .F.  // pas de rafrachissement du browse
               LOOP
          
          // Browse : Si PageUp et monte autorise et filtre non vide
          case nKey == K_PGUP .AND. lUp .AND. b:Autolite .and. .not. bof()
               b:PageUp()
               LOOP
          
          // Browse : Si PageDown et descente autorise et filtre non vide
          case nKey == K_PGDN .AND. lDown .AND. b:Autolite
               b:PageDown()
               LOOP
          
          // Browse : idem que PgUp
          case nKey == K_UP .AND. lUp .AND. b:Autolite   .and. .not. bof()
               b:Up()
               LOOP
          
          // Browse : idem que PgDn
          case nKey == K_DOWN .AND. lDown .AND. b:Autolite
               b:Down()
               LOOP
          
          // Browse : idem que PgUp
          case nKey == K_CTRL_PGUP .AND. lUp .AND. b:Autolite
               b:GoTop()
               LOOP
          
          // Browse : idem que PgDn
          case nkey == K_CTRL_PGDN .AND. lDown .AND. b:Autolite
               IF EMPTY(g:buffer())   // si le get est vide...
                    GO BOTTOM         // va sur le dernier enr.de la base
                                      // ==> toute la base est affiche
               ELSE
                    b:GoBottom()      // va sur le dernier enr. correspondant
                                      //  la cl du filtre
               ENDIF
               LOOP
          
          // Browse : touches pour se dplacer dans les colonnes
          case nKey == K_CTRL_RIGHT .OR. nKey == K_CTRL_LEFT
               IF nKey == K_CTRL_RIGHT
                  b:Right()             // va sur la prochaine colonne  droite 
                                        // ds le browse
               ELSE
                  b:Left()              // opration inverse 
               ENDIF
               // rajuste le scrollbar horizontal s'il existe
               IF lScrol
                  HScrolBarUpdate (aScrol, b:ColPos(), b:ColCount())
               ENDIF
               lModif := .F.    // empche la mise  jour du browse
               LOOP
          
          
          // Change le filtre actif 
          case nKey == K_F3
               // Si le champ de la colonne active du browse est index et 
               // si cette colonne n'est pas dj le filtre courant
               IF (aChamp[b:ColPos][F_ORDER] != 0 .AND. b:ColPos != g:Cargo)
                   // Sauve le contenu du get courant dans un tableau
                   aChamp[g:Cargo][F_XVALUE] := g:Buffer()
                   // Cre le filtre de la colonne courante
                   MakeFilter (aChamp, @g, aRect, @Index, b:ColPos(), @nRow,; 
                               @nCol, @nMaxCol)
                   IF (lScrol)
                       HScrolBarUpdate (aScrol, b:ColPos(), b:ColCount())
                   ENDIF
                   SEEK RTRIM(g:Buffer())  // recherche la cl du filtre
               ELSE
                   lModif := .F.           // sinon pas de modif.
               ENDIF
               LOOP
          
          // sortie par abandon        
          case nKey == K_ESC               
               EXIT
          
          // sortie par slection autorise si le filtre n'est pas vide
          case nKey == K_ENTER .AND. b:Autolite
               // sauve alors le contenu du get
               aChamp[g:Cargo][F_XVALUE] := g:Buffer()
               EXIT
          
          // Get : va sur le premier caractre
          case nKey == K_HOME
               g:Home()
               nCol := COL()    // sauve alors la position hor. du curseur
               lModif := .F.    // empche le rafrachissement du browse
               LOOP
          
          // Get : va sur le dernier caractre
          case nKey == K_END
               g:End()
               nCol := COL()    
               lModif := .F.    
               LOOP
          
          // Get : dplace le curseur vers la droite
          case nKey == K_RIGHT
               g:Right()
               nCol := COL()
               lModif := .F.
               LOOP
          
          // Get : dplace le curseur vers la gauche
          case nKey == K_LEFT
               g:Left()
               lModif := .F.
               nCol := COL()
               LOOP
          
          // Get : BackSpace
          case nKey == K_BS
               g:Assign()                     // assigne le g:buffer a g:VarGet
               g:BackSpace()                  // ralise le backspace
               nCol := COL()
               IF g:VarGet() != g:Buffer()    // si le buffer est modifi
                  SEEK RTRIM(g:Buffer())      // recherche la nouvelle cl
               ELSE
                  lModif := .F.  // sinon empche la mise  jour du browse
               ENDIF
               LOOP
          
          // Get : touche de suppression
          case nKey == K_DEL
               g:Assign()
               g:Delete()                      // fait la suppression
               IF g:VarGet() != g:Buffer()
                  SEEK RTRIM(g:Buffer())
               ELSE
                  lModif := .F.
               ENDIF
               LOOP
          
          // Get : autre touches dont caractres
          otherwise
                  IF (nKey >= 32 .and. nKey <= 255)  // touches autorises
                     cKey := CHR(nKey)
                     IF ( SET(_SET_INSERT) )   // si mode insertion
                         g:Insert(cKey)        // insert la touche dans le get
                     ELSE
                         g:OverStrike(cKey)    // sinon mode refrappe
                     ENDIF
                     nCol := COL()             // sauve la position du curseur
                     IF ! g:Rejected           // si touche non rejete
                        SEEK RTRIM(g:Buffer()) // recherche la nouvelle cl
                     ELSE
                        lModif := .F.          // sinon pas de mise  jour
                     ENDIF
                  ELSE
                        lModif := .F.          // si touche non autorise
                  ENDIF
     ENDCASE
ENDDO

// si la touche de sortie est Escape
IF LASTKEY () == K_ESC
     aReturn := {0}       // aTableau == 0
ELSE
     // Cre le tableau retourne
     AADD (aReturn, RECNO())                      // le n de l'enr. courant
     AADD (aReturn, aChamp[g:cargo][F_CHAMP])     // le nom du champ courant
     AADD (aReturn, aChamp[g:cargo][F_XVALUE])    // la cl du filtre courant
     // retourne le contenu des champs de l'enr. slectionn
     FOR i := 1 TO LEN(aChamp)
         AADD (aReturn,  EVAL(FIELDBLOCK (aChamp[i][F_CHAMP])))
     NEXT  
ENDIF

// Restaure l'environnement
SETKEY(bInssave)
SETCOLOR (cOldColor)
SETCURSOR (nOldCurs)
RESTSCREEN (aRect[W_TOP], aRect[W_LEFT], aRect[W_BOTTOM] + 1, aRect[W_RIGHT] + 2, cOldScreen)

IF nOldSelect != NIL
     SELECT (nOldSelect)                // slectionne l'ancienne base
ENDIF

// Ces lignes sont utiles si vous faites un browse sur la base active
SET ORDER TO nOldOrder                  // slectionne l'ancien index
GO nOldRecno                            // retourne  l'ancien enr. courant

RETURN (aReturn)


/* * *
*  
*    Fonction MakeBrowse (aRect, b, aChamp, nLarg, nLong, lScrol)
*
*         - Construit l'interface de la fentre
*         - Paramtres :
*              + Tableau des coordonnes de la fentre
*              + Objet TBrowse (transmis par rfrence)
*              + dfinitions des champs  afficher
*              + Largeur de la fentre 
*              + Longueur de la fentre 
*              + Valeur logique du ScrolBar 
*
*/

STATIC FUNCTION MakeBrowse (aRect, b, aChamp, nLarg, nLong, lScrol)
LOCAL i, c, nLargWin

// si largeur demande est <  la largeur minimale de la fentre...
IIF (nLarg < 38, nLarg := 38, NIL)

// Si la largeur demande est < au maximum de l'cran, calcul la position
// de la fentre qui sera centre
IF (nLarg < MAXCOL() - 4)
     aRect[W_LEFT]  := (MAXCOL() - nLarg) / 2
     aRect[W_RIGHT] := aRect[W_LEFT] + nLarg - 1
ELSE
     aRect[W_LEFT]  := 1                // sinon cre un fentre maximale
     aRect[W_RIGHT] := MAXCOL() - 3
ENDIF

// pareil que prcdemment, mais sur la hauteur de la fentre
IIF (nLong < 10, nLong := 10, NIL)

IF (nLong < MAXROW() - 2)
     aRect[W_TOP]   := (MAXROW() - nLong) / 2
     aRect[W_BOTTOM] := aRect[W_TOP] + nLong - 1
ELSE
     aRect[W_TOP] := 1
     aRect[W_BOTTOM] := 22
ENDIF

// sauve la largeur de la fentre... utile plus loin
nLargWin := aRect[W_RIGHT] - aRect[W_LEFT] - 1 

// cre le browse en fonction de la largeur de la fentre et si scrollbar
b:= TBrowseDb(aRect[W_TOP] + 2, aRect[W_LEFT] + 1, ;
              aRect[W_BOTTOM] - IF(lScrol, 4, 3), aRect[W_RIGHT] - 1)
b:ColorSpec := C_BROWSE         // couleur du browse

// Cre les colonnes du browse
FOR i := 1 TO LEN (aChamp)
    c := TBcolumnNew (aChamp[i][F_NOM], FIELDWBLOCK(aChamp[i][F_CHAMP],SELECT()))
    
    // Si longueur du get + texte > largeur fentre ==> champ inactif
    IF (aChamp[i][F_ORDER] != 0 .AND. (LEN(aChamp[i][F_NOM]) + ;
        aChamp[i][F_LENGET] + 2) > nLargWin)
        aChamp[i][F_ORDER] := 0
    ENDIF
    
    // si pas d'index associ au champ ==> couleur spciale car inactif
    c:DefColor :=  IF(aChamp[i][F_ORDER] == 0, {3, 2}, {1, 2})
    b:AddColumn( c )     // ajoute la dfinition de la colonne cre au browse
NEXT

b:HeadSep   := HSEP     // type de ligne sparatrice de l'en-tte dans le browse
b:ColSep    := CSEP     // type de ligne sparatrice des colonnes
b:Footsep   := FSEP     // type de ligne sparatrice en bas du browse

RETURN (NIL)


/* * *
*  
*    Fonction MakeWin (aRect, cTitre, lScrol, aScrol)
*
*         - Construit l'interface de la fentre
*         - Paramtres :
*              + Tableau des coordonnes de la fentre
*              + Titre
*              + Valeur logique pour le scrolbar 
*              + Tableau de dfinition du scrolbar (transmis par rfrence)
*
*/

STATIC FUNCTION MakeWin (aRect, cTitre, lScrol, aScrol)
LOCAL nPos, nLargWin

// Construit la fentre
@ aRect[W_TOP], aRect[W_LEFT], aRect[W_BOTTOM], aRect[W_RIGHT] BOX B_SINGLE + CHR(32)

//Trace l'ombre
SHADOW (aRect[W_TOP] + 1, aRect[W_LEFT] + 2, aRect[W_BOTTOM] + 1, aRect[W_RIGHT] + 2)       

// si le titre existe, on l'affiche mme tronqu si plus large que la fentre
IF (cTitre != NIL)
        nLargWin := aRect[W_RIGHT] - aRect[W_LEFT] - 2
        @ aRect[W_TOP] , aRect[W_LEFT] + 2 SAY  IF (LEN(cTitre) > nLargWin,; 
                                     SUBSTR(cTitre, 1, nLargWin - 1), cTitre)
ENDIF

// quelques artifices pour les yeux
@ aRect[W_TOP]    + 3, aRect[W_LEFT]     SAY  "" 
@ aRect[W_TOP]    + 3, aRect[W_RIGHT]    SAY  ""

nPos := IF (lScrol, 4, 3)
@ aRect[W_BOTTOM] - nPos, aRect[W_LEFT]     SAY  "" 
@ aRect[W_BOTTOM] - nPos, aRect[W_RIGHT]    SAY  ""  

// affiche les touches actives dans le programme
SETCOLOR (C_TEXT)
@ aRect[W_BOTTOM] - 2, aRect[W_LEFT] + 2 SAY "Get :"
@ aRect[W_BOTTOM] - 1, aRect[W_LEFT] + 2 SAY "Browse:"

SETCOLOR (C_TOUCHE)
@ aRect[W_BOTTOM] - 2, aRect[W_LEFT] + 11 SAY  CHR(27) + CHR(26) + " Home End " ;
                                              + "Ins Suppr <"
@ aRect[W_BOTTOM] - 1, aRect[W_LEFT] + 11 SAY CHR(24) + CHR(25) + " (Ctrl+) " ; 
                                              + "PgUp PgDn " + CHR(27) + " " + CHR(26)

// Ligne d'aide
LAIDE ("Filter the current field:~F3    Choice:~Enter    Exit:~Esc")  

// Si scrolbar, on le cre
IF (lScrol)
        aScrol := HScrolBarNew( aRect[W_BOTTOM] - 3, aRect[W_LEFT] + 1, aRect[W_RIGHT] - 1)
        HScrolBarDisplay (aScrol)
ENDIF

RETURN (NIL)


/* * *
*  
*    Fonction MakeFilter (aChamp, g, aRect, Index, nChamp, nRow, nCol, nMaxCol)
*
*         - Construit le Get, le filtre
*         - Paramtres :
*              + Tableau de dfinition des champs 
*              + L'objet get (transmis par rfrence)
*              + Tableau des coordonnes de la fentre
*              + La cl de l'index (transmis par rfrence)
*              + le champ actif 
*              + Les coordonnes du get (transmises par rfrence) 
*
*/

STATIC FUNCTION MakeFilter (aChamp, g, aRect, Index, nChamp, nRow, nCol, nMaxCol)
LOCAL cSaisie, nLenSaisie, nLargWin, nPosGet, xValue, nLenGet, cFondColor

// largeur de la fentre
nLargWin := aRect[W_RIGHT] - aRect[W_LEFT] - 1

// si le champ courant possde un index
IF (aChamp[nChamp][F_ORDER] > 0)
      
      // Un peu de mnage
      @ aRect[W_TOP] + 1, aRect[W_LEFT] + 1 CLEAR TO aRect[W_TOP] + 1,;
                                                     aRect[W_LEFT] + nLargWin
      
      // Cre le nom du get avec le nom  afficher du champ
      cSaisie := aChamp[nChamp][F_NOM] + " :"
      
      // Calcul la longueur totale du texte + get
      nLenSaisie := LEN(cSaisie) + aChamp[nChamp][F_LENGET]
      
      // affiche le texte et le get centrs dans la fentre
      SETCOLOR (C_GET)
      @ aRect[W_TOP] + 1, aRect[W_LEFT] + ((nLargWin - nLenSaisie)/2) SAY cSaisie
      nPosGet := aRect[W_LEFT] + ((nLargWin - nLenSaisie) / 2) + LEN(cSaisie) + 1
      nLenGet := aChamp[nChamp][F_LENGET]
      
      // contenu initial du get
      xValue := PADR (aChamp[nChamp][F_XVALUE], nLenGet)
      
      // Construit le get 
      // (j'aurai peut-tre d acheter les livres de Rick Spence...)
      g := GETNEW (aRect[W_TOP] + 1, nPosGet, {|p| IF(PCOUNT() == 0, xValue,; 
                   xValue := p) }, "", aChamp[nChamp][F_PICT], C_GET)
      
      g:SetFocus()            // Active le get
      g:Cargo := nChamp       // place ds le cargo le n du champ activ

      // Active l'index du champ
      SET ORDER TO aChamp[nChamp][F_ORDER]
      Index := MM_COMPILE (INDEXKEY())    // compile la cl de l'index
      
      nRow := g:Row (); nCol := g:Col()   // sauve la position du curseur
      nMaxCol := nCol + LEN(xValue)       // Calcul la pos. maxi du curseur
                                          // dans le get
      // Active le curseur
      SETCURSOR (IF(ReadInsert(), SC_NORMAL, SC_SPECIAL1))
ENDIF      
RETURN (NIL)


*!***************************************************************************
*!
*!      Function: MM_Deplace( )
*!      Permet le dplacement dans le fichier
*!      Auteur : Marc Mirville (POINT DBF n 20 - Mars 1992 - Pages 14 - 17)
*!      Lgrement modifie pour s'adapter au prog.
*!***************************************************************************

STATIC FUNCTION MM_Deplace(num , _Clef , Index, lUp, lDown, b)
LOCAL x := 0

IF num == 0
    SKIP 0
ELSE
    DO WHILE !EOF() .AND. !BOF() .AND. x != num .AND. EVAL(Index) = _Clef
        IF num > 0
            SKIP
            x++
        ELSE
            SKIP -1
            x--
        ENDIF
    ENDDO
    
    lUp := !b:HitTop        // autorise de se dplacer vers le haut ou non
    lDown := !b:HitBottom   // inverse
    
    IF EOF()
        SKIP -1
        x--
    ELSEIF BOF()
        GO TOP
        x++
    ELSEIF EVAL(Index) != _Clef
        IF x > 0
            SKIP -1
            x--
        ELSE
            SKIP
            x++
        ENDIF
    ENDIF
ENDIF
RETURN (x)

*!***************************************************************************
*!
*!      Function: MM_Haut( _Clef )
*!      Provoque le dplacement au dbut du fichier
*!      Auteur : Marc Mirville (POINT DBF n 20 - Mars 1992 - Pages 14 - 17)
*!***************************************************************************

STATIC FUNCTION MM_Haut( _Clef)
SEEK _Clef
RETURN (NIL)

*!***************************************************************************
*!
*!      Function: MM_Bas( _Clef )
*!      Provoque le dplacement en fin de fichier
*!      Auteur : Marc Mirville (POINT DBF n 20 - Mars 1992 - Pages 14 - 17)
*!***************************************************************************

STATIC FUNCTION MM_Bas( _Clef)
LOCAL lSoft := SET(_SET_SOFTSEEK, .T.)  // autorise la recherche non exacte
// va sur le dernier enr. correspondant au filtre
SEEK SUBSTR(_Clef,1,LEN(_Clef)-1) + CHR(ASC(SUBSTR(_Clef, LEN(_Clef)))+1)
SKIP -1
SET(_SET_SOFTSEEK, lSoft)
RETURN (NIL)

