*****
* Language     : CLIPPER 5.0 VF
* Version      : 0.5
* Auteur       : BONNARDEL Philippe
* Date         : 21/10/92
* Objet        : WaitMsg : Affiche dans une fentre centre sur l'cran un 
*              :           message d'attente  l'utilisateur.
* Compilateur  : /M/L/W/N
* Lien         : Shadow.obj
*    
*****

// Fichiers de dfinition pour le prprocesseur
#include "Box.ch"
#include "Inkey.ch"
#include "SetCurs.ch"

// Variables Static
STATIC cWaitBuff, nCursor, nWaitLeft, nWaitRight


/* * *
*    Fonction WaitMsg (cText, cCouleur)
*
*         - Affiche la fentre d'attente
*         - Paramtres :
*              + cText : Une chane de caractre centre dans la fentre
*              + cCouleur : Dfinie la couleur du cadre et fond, du texte
*         - Rem. : Le mot du texte prcd de ~ sera clignotant. 
*                  Ex. : WaitMsg ("Indexation en cours~...", "G+/B, W+/B")
*   La fonction WaitMsg () sans paramtre restaure la portion de l'cran
*   et le curseur
*/

FUNCTION WAITMSG (cText, cCouleur)
LOCAL cOldColor, nLgItem, nPos, cClignText, cClignColor, cTextColor, nWaitTop

nWaitTop := INT (MAXROW () / 2) - 2

IF (cText != NIL)        

	// Sauve l'environnement courant
	nCursor := SETCURSOR(SC_NONE)
	cOldColor := SETCOLOR ()

	nLgItem := LEN(cText)

	// Recherche le signe de clignotement dans le texte
	IF "~" $ cText
		nPos := AT("~", cText)
		cClignText := SUBSTR(cText, nPos + 1)
		cText := STRTRAN (cText, "~")
		nLgItem--
	ENDIF

	// extrait les couleurs
	IF "," $ cCouleur
		cTextColor := SUBSTR (cCouleur, AT(",", cCouleur) + 1)
		cClignColor := STRTRAN (cTextColor, "/", "*/")
	ELSEIF cClignText != NIL
		cClignColor := STRTRAN (cCouleur, "/", "*/")
	ENDIF

	// Largeur minimale de la fentre
	nLgItem := IF(nLgItem < 10, 10, nLgItem)

	// Calcul la position de la fentre
	nWaitLeft := INT ((MAXCOL () - nLgitem - 2) / 2)
	nWaitRight := nWaitLeft + nLgItem + 3

	// Sauve la portion de l'cran
	cWaitbuff := SAVESCREEN (nWaitTop, nWaitLeft, nWaitTop + 3, nWaitRight + 2)

	// Dessine l'interface
	SETCOLOR (cCouleur)
	@ nWaitTop, nWaitLeft, nWaitTop + 2, nWaitRight BOX B_SINGLE + CHR(32)
	SHADOW (nWaitTop + 1, nWaitLeft + 2, nWaitTop + 3, nWaitRight + 2)
	
	@ nWaitTop, nWaitLeft + 1 SAY " Patientez "
	
	SETCOLOR (IF (cTextColor != NIL, cTextColor, cCouleur))
	@ nWaitTop + 1, nWaitLeft + 2 SAY cText
	
	IF cClignText != NIL
		SETCOLOR (cClignColor)
		@ nWaitTop + 1, nWaitLeft + nPos + 1 SAY cClignText
	ENDIF
	
	SETCOLOR (cOldColor)

ELSEIF cWaitBuff != NIL
	
	RESTSCREEN (nWaitTop, nWaitLeft, nWaitTop + 3, nWaitRight + 2, cWaitbuff)
	SETCURSOR (nCursor)
	// Kill des variables statics
	cWaitBuff := nCursor := nWaitLeft := nWaitRight := NIL
ENDIF
RETURN (NIL)

