*****
* Language     : CLIPPER 5.0 VF
* Version      : 1.0
* Date         : 23/10/92
* Objet        : Affiche une barre horizontal avec un curseur indiquant
*                la position dans la fentre
* Auteur       : Modification du ScrollBar.prg de Nantucket
* Compilation  : /M/L/N/W
* Lien         : Aucun
*
*****

// Les lments de Ascroll
#define TB_ELEMENTS     6       // Nbre d'lments

#define TB_ROWTOP       1       // Coordonne haute du scroll 
#define TB_COLTOP       2       // Coordonne gauche du scroll
#define TB_ROWBOTTOM    3       // Coordonne basse du scroll
#define TB_COLBOTTOM    4       // Coordonne droite du scroll
#define TB_COLOR        5       // Contient la couleur du scroll
#define TB_POSITION     6       // Position du curseur

// Les caractres semi-graphiques utiliss
#define TB_UPARROW      CHR ( 24)       // Flche haut
#define TB_DNARROW      CHR ( 25)       // Flche bas
#define TB_LTARROW      CHR ( 26)       // Flche gauche
#define TB_RTARROW      CHR ( 27)       // Flche droite
#define TB_HIGHLIGHT    CHR (219)       // Le curseur
#define TB_BACKGROUND   CHR (176)       // Le fond du scroll

/* * *
*
*  HScrolBarNew( <nTopRow>, <nLeftColumn>, <nRightColumn>, 
*     <cColorString>, <nInitPosition> ) --> aScrollBar
*  
*  Create a new scroll bar array with the specified coordinates
*
*/

FUNCTION HScrolBarNew( nTopRow, nLeftColumn, nRightColumn, ;
                        cColorString, nInitPosition )

LOCAL aScrollBar := ARRAY( TB_ELEMENTS )

aScrollBar[ TB_ROWTOP ]    := nTopRow
aScrollBar[ TB_COLTOP ]    := nLeftColumn
aScrollBar[ TB_ROWBOTTOM ] := nTopRow
aScrollBar[ TB_COLBOTTOM ] := nRightColumn

// Set the default color to White on Black if none specified
IF cColorString == NIL
      cColorString := "N/W"
ENDIF
aScrollBar[ TB_COLOR ]     := cColorString

// Set the starting position
IF nInitPosition == NIL
      nInitPosition := 1
ENDIF
aScrollBar[ TB_POSITION ]  := nInitPosition

RETURN aScrollBar


/* * *
*
*  HScrolBarDisplay( <aScrollBar> )
*  Display a scroll bar array to the screen
*
*/  

FUNCTION HScrolBarDisplay( aScrollBar )
LOCAL cOldColor, nCol

cOldColor := SETCOLOR( aScrollBar[ TB_COLOR ] )

// Draw the arrows
@ aScrollBar[ TB_ROWTOP ], aScrollBar[ TB_COLTOP ] SAY TB_RTARROW
@ aScrollBar[ TB_ROWBOTTOM ], aScrollBar[ TB_COLBOTTOM ] SAY TB_LTARROW

// Draw the background
FOR nCol := (aScrollBar[TB_COLTOP] + 1) TO (aScrollBar[TB_COLBOTTOM] - 1)
      @ aScrollBar[ TB_ROWTOP ], nCol SAY TB_BACKGROUND
NEXT

SETCOLOR( cOldColor )

RETURN (NIL)

/* * *
*
*  HScrolBarUpdate( <aScrollBar>, <nCurrent>, <nTotal>,
*     <lForceUpdate> ) --> aScrollBar
*
*  Update scroll bar array with new tab position and redisplay tab
*
*/

FUNCTION HScrolBarUpdate( aScrollBar, nCurrent, nTotal, lForceUpdate )
LOCAL cOldColor, nNewPosition
LOCAL nScrollHeight := (aScrollBar[TB_COLBOTTOM] - 1)-(aScrollBar[TB_COLTOP])

IF nTotal < 2
      nTotal := 2
ENDIF

IF lForceUpdate == NIL
      lForceUpdate := .F.
ENDIF

cOldColor := SETCOLOR( aScrollBar[ TB_COLOR ] )

// Determine the new position
nNewPosition := INT(((nCurrent-1) / (nTotal-1)) * nScrollHeight)

// Resolve algorythm oversights
IF( nNewPosition < 1)
   nNewPosition := 1
ELSEIF(nCurrent >= nTotal)
   nNewPosition := nScrollHeight
ENDIF

// Overwrite the old position (if different), then draw in the new one
IF nNewPosition <> aScrollBar[ TB_POSITION ] .OR. lForceUpdate
      @ aScrollBar[ TB_ROWTOP ], aScrollBar[ TB_COLTOP ] + ;
          aScrollBar[ TB_POSITION ] SAY TB_BACKGROUND
      SETCOLOR ("I")
      @ aScrollBar[ TB_ROWTOP ], aScrollBar[ TB_COLTOP ] + nNewPosition SAY ;
        TB_HIGHLIGHT
      aScrollBar[ TB_POSITION ] := nNewPosition
ENDIF

SETCOLOR( cOldColor )

RETURN aScrollBar

