UNIT Msg;
  {-------------------------------------------------------------------------
                    Quick and Dirty *.MSG creation
               By Mark Cole, 115:4401/1 - Aug 1st 1995
                Free for any use (at your own risk!)
               ---------------------------------------

     Usage:

         CreateMSG('C:\FD\NETMAIL\',
                   Dest,Org,
                   'All','Mark Cole',
                   'Test',
                   CrashMask+LocalMask');
         WriteToMSG('This is a test'#13);
         WriteToMsg('---'#13);
         CloseMsg;

         (LocalMask is generally required in flags)

     INTL       is always added.
     MSGID      is always added (serial number is unix time stamp)
     FMPT/TOPT  added if appropriate
  -------------------------------------------------------------------------}

{$I-}

{$DEFINE MSGX}   { To use zone/point extensions in header (FTS 0001-15}

INTERFACE


Uses Dos;

CONST

  MSG_PID: string = 'MSG 0/0';  { Set your own to add to msg }

 { Masks for use with message attribute flags }
  PrivateMask: word =  1;
  CrashMask:   word =  2;
  ReadMask:    word =  4;
  SentMask:    word =  8;
  FileMask:    word = 16;      { File Attach}
  FWDMask:     word = 32;      { in Transit }
  OrphanMask:  word = 64;
  KillMask:    word = 128;
  LocalMask:   word = 256;
  HoldMask:    word = 512;
  FRQMask:     word = 2048;    { File req    }
  RRQMask:     word = 4096;    { Reciept Req }
  CPTMask:     word = 8192;    { is Reciept  }
  ARQMask:     word = 16384;   { Audit Req   }
  URQMask:     word = 32768;   { Update Req  }

TYPE
  Str16 = string[16];
  Str20 = string[20];
  Str36 = string[36];
  Str72 = string[72];

  DomainStr = string[25];
  TNodeRec = record
    Zone,
    Net,
    Node,
    Point:   integer;
    Domain:  DomainStr;
  end;


   { Create a new message }
Function  CreateMSG(Dir:                DirStr;
                    Destination,Origin: TNodeRec;
                    ToName,FromName:    Str36;
                    Subject:            str72;
                    Flags:              word
                   ): boolean;

   { Write a string to the messsage (string must include CR/LF
     if appropriate, thay are not added here }
Function WriteToMSG(Str: string): boolean;

   { Close the message }
Function CloseMSG: boolean;

IMPLEMENTATION



CONST MonthNames: array[1..12] of string[3] =
                  ('Jan','Feb','Mar','Apr','May',
                   'Jun','Jul','Aug','Sep','Oct',
                   'Nov','Dec');

TYPE
  z40 = array[1..40] of char;
  z36 = array[1..36] of char;
  z20 = array[1..20] of char;
  z72 = array[1..72] of char;


  FidoMsgRec = record   { Structure of a FidoNet message header }
                 WhoFrom:   z36;
                 WhoTo:     z36;
                 Subj:      z72;
                 Date:      z20;
                 Times:     word;
                 dest:      integer;
                 orig:      integer;
                 cost:      integer;
                 orig_net:  integer;
                 dest_net:  integer;
                 DestZone:  integer;    { FTS0001-15 }
                 OrigZone:  integer;
                 DestPoint: integer;
                 OrigPoint: integer;
                { written:   longint; replaced by above in FTS0001-15 }
                { arrived:   longint;     "                           }
                 reply:     word;
                 attr:      word;
                 up:        word;
               end;

VAR
  LastMsgIDSerial: longint;  { Used to prevent duplicate MSGID time stamps
                               when 2 messages created within one second }

  MsgFile:           file;   { The file we write to }

{ ************************************ }
{ * Various functions that you may   * }
{ * be able to remove if you already * }
{ * have your own versions           * }
{ ************************************ }

Function StrInt(n: integer): str16;
 { Return string for LongInt }
var s: str16;
begin
  str(n,s);
  StrInt := s;
end;


Procedure CStr(s: string; var Ps; N: word);
  { Make a c type string, padded with nulls to lenght N }
var i: word;
begin
  fillchar(ps,n,0);
  i:=0;
  if s[0]>chr(n-1) then s[0]:=chr(n-1);
  for i:=1 to length(s) do mem[seg(ps):ofs(ps)+pred(i)]:=ord(s[i]);
end;

function StrFill(Num: word; Len: word; PadChar: char): string;
  { Fill a string to "Len" with given character (used by date routines) }
var s: string;

begin
  if Len>255 then Len := 255;
  s:='';
  str(Num,s);
  while length(s)<Len do insert(PadChar,s,1);
  StrFill:=s;
end;

Function MsgNumber(s: PathStr): integer;
 { return X.MSG as number (or -1 if not a numbered .MSG) }
var i,r: integer;
    d:   DirStr;
    n:   NameStr;
    e:   ExtStr;
begin
  fsplit(s,d,n,e);
  val(n,i,r);
  if r > 0 then i := -1;
  MsgNumber := i;
end;

Function HighMsg(Path: string): integer;
  { Return the highest msg number used in a directory }
var SRec: searchrec;
    i,
    High: integer;
    s: string[12];

begin
  FindFirst(Path+'*.MSG',0,SRec);
  i:=DosError;
  if i = 3 then
   begin
     HighMsg:=-1;
     exit;
   end;
  High:=0;
  if i = 0 then
  while DosError = 0 do
   begin
     i := MsgNumber(SRec.Name);
     if i>High then High:=i;
     FindNext(SRec);
   end;
   HighMsg:=High;
end;

Function MSG_Time: str20;
var ds:  string[10];
    s:   string[4];
    ts:  string[8];
    Hour,Min,Sec,S100: word;
    Year,Month,Day,DayOfWeek:word;

begin
  GetTime(Hour,Min,Sec,S100);
  GetDate(Year,Month,Day,DayOfWeek);
  str(Day,ds);
  if Day<10 then ds:='0'+ds;
  ds:=ds+' '+MonthNames[Month];
  str(Year,s);
  ds:=ds+' '+copy(s,3,2);
  ts:=StrFill(Hour,2,'0')+':'+StrFill(Min,2,'0')+':'+StrFill(Sec,2,'0');
  Msg_Time:=Ds + '  '+TS;
end;

Function AddressStr(Zone,Net,Node,Point: integer;
                    Domain: DomainStr): string;
var s: string;


begin
  s:='';
  if Zone > 0 then            { leave zone off if its zero }
   begin
     s := s + StrInt(Zone) + ':';
   end;
  s := s + StrInt(Net) + '/' + StrInt(Node);
  if (Point > 0) or (Domain > '') then s:=s+'.' + StrInt(Point);
  if Domain <> '' then s := s +'@'+Domain;
  AddressStr:=s;
end;

Function UnixTime(Day,Month,Year,Hour,Min,Sec: word): longint;
  { Return unix time (secs since 1/1/1970). On UNIX system this would#
    always be GMT so here we try to get to GMT using a GMT env var. If
    that's not set then we are stuck with whatever the system clock says.

   *** In case of future concern note that this routine has been checked
       against Turbo C's TIME function and returns an exactly correct
       value for all tests (including in/after leap years).

       This routine is *CORRECT*
  }
var Mf,l,r: longint;
    DayOfWeek,Sec100: word;

begin
  if Day = 0 then
   begin
     getdate(Year,Month,Day,DayOfWeek);
     gettime(Hour,Min,Sec,Sec100);
   end;
  Mf:=0;
  IF Month<3 then Mf:=1;
  if (Year < 1900) then if Year<70 then Year:=Year+2000
    else Year:=Year+1900;
  r:=longint((36525*(Year-Mf)) div 100) +
    longint((3060*(Month+1+Mf*12)) div 100)+longint(Day)-longint(719606);
  UnixTime := (r * 86400) + (longint(Hour) * 3600) + (Min * 60) + Sec;
end;

Function MSGIDStr(Zone,Net,Node,Point: integer;
                  Domain: DomainStr): string;
 { Return ^AMSGID: zone:net/node.point@domain<cr/lf> }

var l: longint;
    s: string[60];
    s1: string[10];
    i: integer;

type Long = record
         LowWord, HighWord : Word;
        end;

const Digits : array[0..$F] of Char = '0123456789abcdef';

  function HexW(W : Word) : string;
  {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexL(L : LongInt) : string;
  {-Return hex string for LongInt}
  begin
    with Long(L) do
     HexL := HexW(HighWord)+HexW(LowWord);
  end;


begin
  l := UnixTime(0,0,0,0,0,0);  { Rev 1.10, use Unix time and avoid dupes }
  while l <= LastMsgIDSerial do inc(l);
  LastMsgIDSerial := l;
  s1 := HexL(l);
  {DownCaseStr(s1);}
   { Note (Rev 1.3) We add domain ourselves because we want to be able
     to add a zero point which addressstr leaves off
   }
  s := #1'MSGID: '+AddressStr(Zone,Net,Node,Point,Domain);

   { AddressStr leaves off point if zero and no domain }
  if (Point = 0) and (Domain = '') then s:=s+'.0';
  MSGIDStr := s+' '+s1;
end;


{ *********************** }
{ *    The main bits    * }
{ *********************** }

Function WriteToMSG(Str: string): boolean;
begin
  blockwrite(MsgFile,Str[1],length(Str));
  WriteToMsg := IoResult = 0;
end;

Function CreateMSG(Dir:                DirStr;
                   Destination,Origin: TNodeRec;
                   ToName,FromName:    Str36;
                   Subject:            str72;
                   Flags:              word
                  ): boolean;
Var
  Err: Boolean;
  S:   string;
  i:   integer;
  High: integer;
  FidoMessageHeader: FidoMsgRec;
  MsgFileName:       String[12];



begin
  CreateMSG := False;  { Let's assume we fail! }
  if Dir[length(Dir)] <> '\' then Dir := Dir + '\';
  High:=HighMsg(Dir);
  if High < 0 then exit;  { Bad path }
  inc(High);
  MSGFileName := StrInt(High)+'.MSG';

  fillchar(FidoMessageHeader,sizeof(FidoMessageHeader),0);
   with FidoMessageHeader do
    begin
      cStr(ToName,WhoTo,36);
      cStr(FromName,WhoFrom,36);
      cStr(Subject,Subj,72);
      cStr(MSG_Time,Date,20);
      Attr := Flags;
      with Origin do begin
        Orig := Node;
        Orig_Net := Net;
        {$IFDEF MSGX}
        OrigZone := Zone;
        OrigPoint := Point;
        {$ENDIF}
      end;
      with Destination do begin
        Dest := Node;
        Dest_Net := Net;
        {$IFDEF MSGX}
        DestZone := Zone;
        DestPoint := Point;
        {$ENDIF}
      end;
    end;

  assign(MSGFile,Dir+MsgFileName);
  rewrite(MSGFile,1);
  if ioresult <> 0 then exit;
  blockwrite(MSGFile,FidoMessageHeader,sizeof(FidoMessageHeader));
  if ioresult <> 0 then
   begin
     close(MsgFile);
     exit;
   end;
  with Origin do
    Err := not WriteToMsg(MSGIDStr(Zone,Net,Node,Point,Domain)+#13);
  with Destination do S := #1'INTL '+AddressStr(Zone,Net,Node,0,'');
  with Origin do S := S +' '+AddressStr(Zone,Net,Node,0,'');
  Err := Not WriteToMsg(s+#13);
  with Destination do
    if Point <> 0 then Err := not WriteToMsg(#1'TOPT '+StrInt(Point)+#13);
  with Origin do
    if Point <> 0 then Err := not WriteToMsg(#1'FMPT '+StrInt(Point)+#13);
  Err := Not WriteToMsg(#1'PID: '+Msg_PID+#13);
  CreateMSG := not Err;
End;

Function CloseMSG: boolean;
Var
  Err: boolean;
Const
  EndB: byte = 0;
begin
  blockwrite(MsgFile,EndB,1);
  Err := ioresult <> 0;
  close(MsgFile);
  Err := ioresult <> 0;
  CloseMsg := NOT Err;
end;

begin
  LastMsgIDSerial := 0;
end.
