/* Listing 12, printf.c, version 3 */
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "check.h"    /* Listing 5  */
#include "printf.h"   /* Listing 10 */
#include "dbmeta.hi"  /* Listing 11 */

#undef printf	

DB_DEFN(
int, printf, (const char format[], ... ))
    {
    va_list ap;
    int returnValue;

    UNDEFINED_IF(format == NULL);
    WARNING_IF(strchr(format, '%') == 
               NULL);
    WARNING_IF(strstr(format, "%ul") != 
               NULL);
    WARNING_IF(strstr(format, "%p") != 
               NULL);
    va_start(ap, format);
    returnValue = vprintf(format, ap);
    va_end(ap);
    WARNING_IF(returnValue < 0);
    return returnValue;
    }

