/*****************************************************************************
 * v2.51 : Taskbar for OS/2 installation script
 *
 * (c)Copyright 1995 Rick Yoder
 *****************************************************************************/
SIGNAL ON SYNTAX

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

PARSE ARG destDir regInfo
IF destDir="" | destDir="?" | destDir="-?" | destDir="/?" | TRANSLATE(destDir)="HELP" | TRANSLATE(destDir)="/H" | TRANSLATE(destDir)="-H" THEN
    DO
        SAY 'Usage: INSTALL destDir ["regName" regID]'
        SAY ""
        SAY "       destDir     = Directory location where you want"
        SAY "                     the Taskbar program installed."
        SAY ""
        SAY "       regName     = optional parameter containing the registration"
        SAY "                     name found on your program registration ID card."
        SAY "                     Note that this parameter *MUST* be surrounded"
        SAY "                     by quotes."
        SAY ""
        SAY "       regID       = optional parameter containing the registration"
        SAY "                     ID found on your program registration ID card."
        SAY ""
        SAY "       See the 'Program installation' section in the on-line documentation"
        SAY "       for information on how to install the program."
        EXIT
    END

sourceDir = GetSourceDir()
CALL CheckSource sourceDir
destDir = CreateDestDir(destDir)
CALL DeleteObjects sourceDir

configChanged = 0
CALL UpdateLibpath sourceDir,destDir
IF configChanged = 1 THEN EXIT

IF regInfo \= "" THEN CALL RegisterProgram regInfo
CALL CopyProgramFiles sourceDir,destDir
CALL MakeObjects
SAY "Program installation complete."

EXIT

/***** SUBROUTINES *****/

/*****************************************************************************
 * IsWarp           - determines whether we are running OS/2 Warp version 3
 *                    or higher.
 *****************************************************************************/
IsWarp: PROCEDURE

    version = SysOS2Ver()
    IF version >= 2.30
        THEN fWarp = 1
        ELSE fWarp = 0

    RETURN fWarp
/*****************************************************************************/

/*****************************************************************************
 * GetSourceDir     - retrieves the directory name of the directory where
 *                    the installation program is located.
 *
 *                    Note: the returned source directory retains the
 *                          trailing slash ('\') character.
 *****************************************************************************/
GetSourceDir: PROCEDURE

    PARSE SOURCE unused1 unused2 sourceDir
    sourceDir = FILESPEC("drive",sourceDir)||FILESPEC("path",sourceDir)
    return sourceDir
/*****************************************************************************/

/*****************************************************************************
 * CheckSource      - makes sure that all necessary files are present
 *                    in the source directory. Terminates the install
 *                    script if an error occurs.
 *****************************************************************************/
CheckSource: PROCEDURE
    PARSE ARG sourceDir

    sourceList.0 = 8
    sourceList.1 = 'BootDriv.exe'
    sourceList.2 = 'tbwarp.dll'
    sourceList.3 = 'hookwarp.dll'
    sourceList.4 = 'tb2x.dll'
    sourceList.5 = 'hook2x.dll'
    sourceList.6 = 'close.exe'
    sourceList.7 = 'brand.exe'
    sourceList.8 = 'taskbar.hlp'

    DO n = 1 TO sourceList.0
        IF STREAM(sourceDir||sourceList.n,"C","QUERY EXISTS")="" THEN
            DO
                SAY "Unable to find file "||sourceDir||sourceList.n
                EXIT
            END
    END
    RETURN
/*****************************************************************************/

/*****************************************************************************
 * CreateDestDir    - procedure to create the destination directory.
 *                    Returns the fully qualified pathname of the
 *                    destination directory. Terminates the install script
 *                    if an error occurs.
 *****************************************************************************/
CreateDestDir: PROCEDURE
    PARSE ARG destDir

    CALL SETLOCAL
    target = DIRECTORY(destDir) /* check whether dest dir exists */
    IF target="" THEN /* dest dir doesn't exist so create it */
        DO
            IF 0\=SysMkDir(destDir) THEN
                DO
                    SAY "Error creating directory '"||destDir||"'"
                    EXIT
                END
            destDir = DIRECTORY(destDir) /* get fully qualified pathname of dest dir */
        END
    ELSE
        DO
            destDir = target
        END
    CALL ENDLOCAL

    IF destDir="" THEN
        DO
            SAY "Internal error in CreateDestDir procedure."
            EXIT
        END

    RETURN destDir
/*****************************************************************************/

/*****************************************************************************
 * CopyProgramFiles - procedure to copy the program files to the
 *                    specified directory. Terminates the install
 *                    script if an error occurs.
 *****************************************************************************/
CopyProgramFiles: PROCEDURE
    PARSE ARG sourceDir, destDir

    /* Delete files used by versions 2.0 and below of Taskbar */
    CALL SysFileDelete destDir||"\TaskBar.EXE"
    CALL SysFileDelete destDir||"\TskBarHk.DLL"
    CALL SysFileDelete destDir||"\MakeObjs.CMD"

    destlist.0 = 3
    destlist.1 = "\TaskBar.DLL"
    destlist.2 = "\TskBarHk.DLL"
    destlist.3 = "\Taskbar.HLP"

    srclist.0  = 3

    IF 1 = IsWarp() THEN
        DO
            srclist.1 = "tbwarp.dll"
            srclist.2 = "hookwarp.dll"
        END
    ELSE
        DO
            srclist.1 = "tb2x.dll"
            srclist.2 = "hook2x.dll"
        END

    srclist.3 = "taskbar.hlp"

    SAY "Copying program files to "||destDir||" ..."
    DO n=1 TO destlist.0
        '@COPY '||sourceDir||srclist.n||' '||destDir||destlist.n
        IF rc\=0 THEN
            DO
                SAY "Error copying "||sourceDir||srclist.n||" to "||destDir||destlist.n
                EXIT
            END
    END

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * UpdateLibpath    - procedure to revise, if necessary, the Config.Sys
 *                    LIBPATH and HELP statements. Terminates the install script
 *                    if an error occurs.
 *****************************************************************************/
UpdateLibpath: PROCEDURE EXPOSE configChanged
    PARSE ARG sourceDir,destDir

    SAY "Checking/revising Config.Sys ..."

    '@'||sourceDir||'BOOTDRIV.EXE'
    bootDrive = SUBSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ",rc,1)
    configSys = bootDrive||":\Config.Sys"

    IF STREAM(configSys,"C","QUERY EXISTS")="" THEN
        DO
            SAY "Error: Unable to find '"||configSys||"'."
            EXIT
        END

    tempfile = SysTempFileName(bootDrive||":\XX????.TMP")
    libpathFound = 0
    helpFound = 0

    DO WHILE LINES(configSys) > 0
        line = LINEIN(configSys)
        sline = TRANSLATE(STRIP(line))
        PARSE VAR sline first'='rest
        first = TRANSLATE(STRIP(first))
        rest = TRANSLATE(STRIP(rest))
        IF first = "LIBPATH" THEN
            DO
                libpathFound=1
                line = UpdateLine(line,destDir)
            END
        ELSE
            DO
                IF first = "SET HELP" THEN
                    DO
                        helpFound=1
                        line = UpdateLine(line,destDir)
                    END
            END
        CALL LINEOUT tempfile,line
    END
    CALL STREAM configSys,'C','CLOSE'
    CALL STREAM tempfile,'C','CLOSE'

    IF libpathFound=0 THEN
        DO
            SAY "LIBPATH=... statement not found in Config.Sys."
            CALL SysFileDelete tempfile
            EXIT
        END

    IF helpFound=0 THEN
        DO
            SAY "SET HELP=... statement not found in Config.Sys."
            CALL SysFileDelete tempfile
            EXIT
        END

    IF configChanged = 1 THEN
        DO
            backupFile = SysTempFileName( bootDrive||":\Config.???" )
            IF backupFile = "" THEN
                DO
                    SAY "Unable to backup existing Config.Sys."
                    SAY "The updated Config.Sys is in file "||tempfile||"."
                    EXIT
                END
            '@COPY '||configSys||' '||backupFile
            IF rc\=0 THEN
                DO
                    SAY "Unable to backup existing Config.Sys."
                    SAY "The updated Config.Sys is in file "||tempfile||"."
                    EXIT
                END
            '@COPY '||tempfile||' '||configSys
            IF rc\=0 THEN
                DO
                    SAY "Unable to write the updated Config.Sys."
                    SAY "A backup copy of the original Config.Sys is in file "||backupFile||"."
                    SAY "The updated Config.Sys is in file "||tempfile||"."
                    EXIT
                END

            SAY "Your Config.Sys has been updated. Please do the"
            SAY "following in order to complete the installation:"
            SAY " "
            SAY "  1) Shutdown your system and reboot."
            SAY "  2) Rerun this installation program."
        END
    ELSE
        DO
            SAY "Your Config.Sys required no modification."
        END

    CALL SysFileDelete tempfile
    RETURN
/*****************************************************************************/

/*****************************************************************************
 * UpdateLine   - procedure to add the destination directory to the
 *                specified path list.
 *****************************************************************************/
UpdateLine: PROCEDURE EXPOSE configChanged
    PARSE ARG line, destDir

    PARSE VAR line first"="rest
    rest = STRIP(rest,"t")
    restUpr = TRANSLATE(rest)
    pgmDir = TRANSLATE(destDir)
    pathFound = 0

    DO WHILE restUpr <> ""
        PARSE VAR restUpr thisPath";"restUpr
        IF thisPath=pgmDir THEN
            DO
                pathFound = 1
                LEAVE
            END
    END

    IF pathFound=0 THEN
        DO
            configChanged = 1
            rest = destDir||";"||rest
            line = first"="rest
        END

    RETURN line
/*****************************************************************************/

/*****************************************************************************
 * MakeObjects  - procedure to create the necessary Workplace Shell objects.
 *                Terminates the install script if an error occurs.
 *****************************************************************************/
MakeObjects: PROCEDURE

    SAY "Registering Taskbar WPS class."
    IF 0=SysRegisterObjectClass( "Taskbar","TASKBAR" ) THEN
        DO
            SAY "Unable to register Taskbar object class."
            EXIT
        END

    SAY "Creating Taskbar program object."
    objectSetup = "OBJECTID=<Taskbar_RFY>"
    IF 0=SysCreateObject( "Taskbar","Taskbar","<WP_DESKTOP>",objectSetup,"replace" ) THEN
        DO
            SAY "Unable to create program object."
            EXIT
        END

    SAY "Creating shadow in startup folder."
    objectSetup = "OBJECTID=<Taskbar_RFY_Shadow>;SHADOWID=<Taskbar_RFY>"
    IF 0=SysCreateObject( "WPShadow","Taskbar","<WP_START>",objectSetup,"replace" ) THEN
        DO
            SAY "Unable to create shadow object."
            EXIT
        END
    RETURN
/*****************************************************************************/

/*****************************************************************************
 * DeleteObjects    - procedure to delete existing Workplace Shell objects.
 *                    Terminates the install script if an error occurs.
 *****************************************************************************/
DeleteObjects: PROCEDURE
    PARSE ARG sourceDir

    SAY "Deleting old WPS objects ..."

    '@'||sourceDir||'CLOSE.EXE'     /* close pre-2.5 copy of Taskbar */
    CALL DeleteOldPgmObjects        /* destroy objects created by old versions */
    CALL DeregisterClass            /* deregister 'Taskbar' class if it exists */

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * DeleteOldPgmObjects    - deletes objects created by prior versions
 *                          of Taskbar. Terminates the install script if
 *                          an error occurs.
 *****************************************************************************/
DeleteOldPgmObjects: PROCEDURE

    /* Destroy the old shadow object if it exists */
    result = SysIni( 'USER','PM_Workplace:Location','<Taskbar_RFY_Shadow>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<Taskbar_RFY_Shadow>') THEN
                DO
                    SAY 'Error destroying old shadow object.'
                    EXIT
                END
        END

    /* Destroy the old program object if it exists */
    result = SysIni( 'USER','PM_Workplace:Location','<Taskbar_RFY>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<Taskbar_RFY>') THEN
                DO
                    SAY 'Error destroying old program object.'
                    EXIT
                END
        END

    /* Destroy beta objects */
    result = SysIni( 'USER','PM_Workplace:Location','<TASKBAR_BETA>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<TASKBAR_BETA>') THEN
                DO
                    SAY 'Error destroying beta test object.'
                    EXIT
                END
        END

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * DeregisterClass        - checks whether the Taskbar class is currently
 *                          registered with the Workplace Shell, and
 *                          deregisters it if it exists. Terminates the
 *                          install script if an error occurs.
 *****************************************************************************/
DeregisterClass: PROCEDURE

    CALL SysQueryClassList "list."
    DO i = 1 TO list.0
        PARSE VAR list.i ClassName DLLName
        IF ClassName = "Taskbar" THEN
            DO
                IF 0 = SysDeregisterObjectClass("Taskbar") THEN
                    DO
                        SAY "Error deregistering Taskbar object class."
                        EXIT
                    END
                RETURN
            END
    END

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * RegisterProgram      - enters the user's registration name and id.
 *                        Terminates the install script if an error occurs.
 *****************************************************************************/
RegisterProgram: PROCEDURE EXPOSE sourceDir
    PARSE ARG '"'regName'" 'regID

    IF regName = "" | regID = "" THEN
        DO
            SAY "ERROR: Bad or missing registration name or id."
            SAY ""
            SAY "       (Did you remember to put quotes around the"
            SAY "        registration name?)"
            EXIT
        END

    '@'||sourceDir||'BRAND.EXE "'||regName||'" '||regID
    IF rc \= 0 THEN
        DO
            SAY "Install terminated due to error in Brand.EXE"
            EXIT
        END

    SAY "Registration info saved."
    RETURN
/*****************************************************************************/

/*****************************************************************************/
 * Standard REXX program error handlers
 *****************************************************************************/
SYNTAX:
    SAY 'REXX error' rc 'in line' sigl
    SAY "Instruction = "||SOURCELINE(sigl)
    EXIT
/*****************************************************************************/
