
/*-
 * Copyright (c) 1995 The Apache Group. All rights reserved.
 * 
 *
 * Apache httpd license
 * ====================
 * 
 *
 * This is the license for the Apache Server. It covers all the
 * files which come in this distribution, and should never be removed.
 * 
 * The "Apache Group" has based this server, called "Apache", on
 * public domain code distributed under the name "NCSA httpd 1.3".
 * 
 * NCSA httpd 1.3 was placed in the public domain by the National Center 
 * for Supercomputing Applications at the University of Illinois 
 * at Urbana-Champaign.
 * 
 * As requested by NCSA we acknowledge,
 * 
 *  "Portions developed at the National Center for Supercomputing
 *   Applications at the University of Illinois at Urbana-Champaign."
 *
 * Copyright on the sections of code added by the "Apache Group" belong
 * to the "Apache Group" and/or the original authors. The "Apache Group" and
 * authors hereby grant permission for their code, along with the
 * public domain NCSA code, to be distributed under the "Apache" name.
 * 
 * Reuse of "Apache Group" code outside of the Apache distribution should
 * be acknowledged with the following quoted text, to be included with any new
 * work;
 * 
 * "Portions developed by the "Apache Group", taken with permission 
 *  from the Apache Server   http://www.apache.org/apache/   "
 *
 *
 * Permission is hereby granted to anyone to redistribute Apache under
 * the "Apache" name. We do not grant permission for the resale of Apache, but
 * we do grant permission for vendors to bundle Apache free with other software,
 * or to charge a reasonable price for redistribution, provided it is made
 * clear that Apache is free. Permission is also granted for vendors to 
 * sell support for for Apache. We explicitly forbid the redistribution of 
 * Apache under any other name.
 * 
 * The "Apache Group" makes no promises to support "Apache". Users and
 * sellers of Apache support, and users of "Apache Group" code, should be 
 * aware that they use "Apache" or portions of the "Apache Group" code at 
 * their own risk. While every effort has been made to ensure that "Apache"
 * is robust and safe to use, we will not accept responsibility for any
 * damage caused, or loss of data or income which results from its use.
 * 
 */



/*
 * http_script: keeps all script-related ramblings together.
 * 
 * Compliant to CGI/1.0 spec
 * 
 * Rob McCool
 *
 */

#include "httpd.h"

int pid;

void kill_children() {
    char errstr[MAX_STRING_LEN];
    sprintf(errstr,"killing CGI process %d",pid);
    log_error_noclose(errstr);

    kill(pid,SIGTERM);
    sleep(3); /* give them time to clean up */
    kill(pid,SIGKILL);
    waitpid(pid,NULL,0);
}

char **create_argv(char *av0, char *args, FILE *out) {
    register int x,n;
    char **av;
    char w[HUGE_STRING_LEN];
    char l[HUGE_STRING_LEN];

    for(x=0,n=2;args[x];x++)
        if(args[x] == '+') ++n;

    if(!(av = (char **)malloc((n+1)*sizeof(char *))))
        die(NO_MEMORY,"create_argv",out);
    av[0] = av0;
    strcpy(l,args);
    for(x=1;x<n;x++) {
        getword(w,l,'+');
        unescape_url(w);
        escape_shell_cmd(w);
        if(!(av[x] = strdup(w)))
            die(NO_MEMORY,"create_argv",out);
    }
    av[n] = NULL;
    return av;
}

void get_path_info(char *path, char *path_args, int *need_multi, 
                   struct stat *finfo)
{
    char *cp;
    char *end = &path[strlen(path)];
    char *last_cp = NULL;
    int rv;

    *need_multi = 0;
    path_args[0] = '\0';

    /* Advance over trailing slashes ... NOT part of filename */

    for (cp = end; cp > path && cp[-1] == '/'; --cp)
    continue;
    
    while (cp > path) {
      
    /* See if the pathname ending here exists... */
      
    *cp = '\0';
    rv = stat(path, finfo);
    if (cp != end) *cp = '/';
      
    if (!rv) {

        /* Aha!  Found something.  If it was a directory, we will
         * search contents of that directory for a multi_match, so
         * the PATH_INFO argument starts with the component after that.
         */
    
        if (S_ISDIR(finfo->st_mode) && last_cp) {
        cp = last_cp;
        *need_multi = 1;
        }
        else *need_multi = 0;
    
        strcpy (path_args, cp);
        *cp = '\0';
        return;
    }
    else {
        last_cp = cp;
    
        while (--cp > path && *cp != '/')
          continue;
    }
    }
}

  /* Apache adds REDIRECT_URL and REDIRECT_QUERY_STRING for
  custom error responses, and DOCUMENT_ROOT because we found it useful*/
  /* Also adds SERVER_ADMIN - useful for scripts to know who to mail when 
  they fail */
#define MAX_COMMON_VARS 13                     
#define MAX_CGI_VARS (MAX_COMMON_VARS+13)

char **add_cgi_vars(char **env,
                    char *method, char *path, char *path_args, char *args,
                    int *content,
                    FILE *out)
{
    int x;
    char t[HUGE_STRING_LEN],t2[HUGE_STRING_LEN];

    if(!(env = new_env(env,MAX_CGI_VARS,&x)))
        die(NO_MEMORY,"add_cgi_vars",out);

    env[x++] = make_env_str("GATEWAY_INTERFACE","CGI/1.1",out);

    env[x++] = make_env_str("SERVER_PROTOCOL",
              (assbackwards ? "HTTP/0.9" : "HTTP/1.0"),out);
    env[x++] = make_env_str("DOCUMENT_ROOT",document_root,out);
    env[x++] = make_env_str("SERVER_ADMIN",server_admin,out);
    env[x++] = make_env_str("REQUEST_METHOD",method,out);

    strcpy(t,path);
    unmunge_name(t);
    env[x++] = make_env_str("SCRIPT_NAME",t,out);
    if(path_args[0]) {
        env[x++] = make_env_str("PATH_INFO",path_args,out);
        strcpy(t2,path_args);
        if (translate_name(t2,out) != BAD_URL)
        env[x++] = make_env_str("PATH_TRANSLATED",t2,out);
    }
    env[x++] = make_env_str("QUERY_STRING",args,out);
    
    /* Apache custom error responses. If we have redirected, set two new vars */
    if (original_url[0]) {
           env[x++] = make_env_str("REDIRECT_QUERY_STRING",original_args,out);
           env[x++] = make_env_str("REDIRECT_URL",original_url+1,out);
    }

    if(content) {
        *content=0;
        if((!strcmp(method,"POST")) || (!strcmp(method,"PUT"))) {
            *content=1;
            sprintf(t,"%d",content_length);
            env[x++] = make_env_str("CONTENT_TYPE",content_type,out);
            env[x++] = make_env_str("CONTENT_LENGTH",t,out);
        }
    }
    env[x] = NULL;
    return env;
}

char **add_common_vars(char **env,FILE *out) {
    char t[HUGE_STRING_LEN],*env_path;
    int x;

    if(!(env = new_env(env,MAX_COMMON_VARS,&x)))
        die(NO_MEMORY,"add_common_vars",out);
    
    if(!(env_path = getenv("PATH")))
        env_path=DEFAULT_PATH;
    env[x++] = make_env_str("PATH",env_path,out);
    env[x++] = make_env_str("SERVER_SOFTWARE",SERVER_VERSION,out);
    env[x++] = make_env_str("SERVER_NAME",server_hostname,out);
    sprintf(t,"%d",port);
    env[x++] = make_env_str("SERVER_PORT",t,out);
    env[x++] = make_env_str("REMOTE_HOST",remote_name,out);
    env[x++] = make_env_str("REMOTE_ADDR",remote_ip,out);
    env[x++] = make_env_str("DOCUMENT_ROOT",document_root,out);
    env[x++] = make_env_str("SERVER_ADMIN",server_admin,out);
    if(user[0])
        env[x++] = make_env_str("REMOTE_USER",user,out);
    if(auth_type)
        env[x++] = make_env_str("AUTH_TYPE",auth_type,out);
    if(do_rfc931)
        env[x++] = make_env_str("REMOTE_IDENT",remote_logname,out);
      /* Apache custom error responses */
    if (original_url[0]) {
           env[x++] = make_env_str("REDIRECT_QUERY_STRING",original_args,out);
           env[x++] = make_env_str("REDIRECT_URL",original_url+1,out);
    } 

    env[x] = NULL;
    return env;
}

int cgi_stub(char *method, char *path, char *path_args, char *args,
             char **env, struct stat *finfo, int in, FILE *out)
{
    int p[2];
    int content, nph;
    char *argv0;
    FILE *psin;
    register int x;

#ifdef __EMX__
    int stdinpipe[2];
#endif        

    if(!can_exec(finfo)) {
        unmunge_name(path);
        die(FORBIDDEN,path,out);
    }

    if((argv0 = strrchr(path,'/')) != NULL)
        argv0++;
    else argv0 = path;

    chdir_file(path);

    if(pipe(p) < 0)
        die(SERVER_ERROR,"httpd: could not create IPC pipe",out);
    if((pid = fork()) < 0)
        die(SERVER_ERROR,"httpd: could not fork new process",out);

    nph = (strncmp(argv0,"nph-",4) ? 0 : 1);
    if(!pid) {
        close(p[0]);
        env = add_cgi_vars(env,method,path,path_args,args,&content,out);
        if(content)
#ifdef __EMX__
            /* Due to a limitation of EMX, inheriting socket handles is not
            allowed so we need to read the input and place it in a file or
            pipe and then pass that handle instead of the socket. */
            if (1) {
                char w[MAX_STRING_LEN];
                read(in,w,content_length);
                close(in);
                pipe(stdinpipe);
                write(stdinpipe[1],w,content_length);
                close(stdinpipe[1]);
                in = dup(stdinpipe[0]);
                close(stdinpipe[0]);
            }                                    
#endif        
            if(in != STDIN_FILENO) {
                dup2(in,STDIN_FILENO);
                close(in);
            }
        if(nph) {
            if(fileno(out) != STDOUT_FILENO) {
                dup2(fileno(out),STDOUT_FILENO);
                fclose(out);
            }
        } else {
            if(p[1] != STDOUT_FILENO) {
                dup2(p[1],STDOUT_FILENO);
                close(p[1]);
            }
        }
        error_log2stderr();

#ifdef HPUX
        signal(SIGCHLD, SIG_DFL);  /* HPsUX  screws up on exit status */
#endif

        /* Only ISINDEX scripts get decoded arguments. */
        if((!args[0]) || (ind(args,'=') >= 0)) {
#ifdef __EMX__
            int emxloop;
            char *emxtemp;
            /* For OS/2 place the variables in the current
            enviornment then it will be inherited. This way
            the program will also get all of OS/2's other SETs. */
            for (emxloop=0; ((emxtemp = env[emxloop]) != NULL); emxloop++)
                putenv(emxtemp);
            if (strstr(strupr(path), ".CMD") > 0) {
                /* Special case to allow use of REXX commands as scripts. */
                os2pathname(path);
                if(execl("CMD.EXE","CMD.EXE","/C",path,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            } else {
                if(execl(path,argv0,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",
                        path,errno);
                    exit(1);
                }
            }                        
#else        
            if(execle(path,argv0,(char *)0,env) == -1) {
                fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",
                        path,errno);
                exit(1);
            }
#endif            
        }
        else {
            if(execve(path,create_argv(argv0,args,out),env) == -1) {
                fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",
                        path,errno);
                exit(1);
            }
        }
    }
    else {
        close(p[1]);
    }

    if(!nph) {
        if(!(psin = fdopen(p[0],"r")))
            die(SERVER_ERROR,"could not read from script",out);

        scan_script_header(psin,out,path);
        /* Patch B18 ^^ and vv   we never redirect and die now 
          if(scan_script_header(psin,out)) {
              kill_children(); 
              return REDIRECT_URL;
          }
        */


        if(location[0] == '/') {
            char t[HUGE_STRING_LEN],a[HUGE_STRING_LEN],*argp;

            a[0] = '\0';
            fclose(psin);
            waitpid(pid,NULL,0);
            strcpy(t,location);
            if(argp = strchr(t,'?')) {
                *argp++ = '\0';
                strcpy(a,argp);
            }
            status = REDIRECT;
            log_transaction(0);
            
              /* Remember that this isn't the original URL */
            original_url[0] = ' ';
          
              /* Save existing info prior to the redirect */
            prepare_for_redirect(out, REDIRECT, t);
                                     
            process_get(in,out,"GET",t,a);
            return 0;
        }
        content_length = -1;
        if(!assbackwards)
            send_http_header(out);
        if(!header_only) {
            /* Patch B18 send a default body of text if the script
                failed to produce any, but ONLY for redirects */
            if (!send_fd(psin,out,NULL) && location[0]) {
                 title_html(out,"Document moved");
                 fprintf(out,"This document has moved <A HREF=\"%s\">here</A>.<P>%c",location,LF); 
            }
        } else
            kill_children();
        fclose(psin);
    }
    else bytes_sent = -1;
    waitpid(pid,NULL,0);
    return 0;
}

/* Called for ScriptAliased directories */
void exec_cgi_script(char *method, char *path, char *args, int in, FILE *out)
{
    struct stat finfo;
    char path_args[HUGE_STRING_LEN];
    char **env;
    int m=0;

    get_path_info(path,path_args,&m,&finfo);
    
    if (m || S_ISDIR(finfo.st_mode)) {
        /* We don't do multi in ScriptAlias'ed dirs; it's just not found. */
        unmunge_name(path);
        die(NOT_FOUND,path,out);
    }
    
    if((!strcmp(method,"GET")) || (!strcmp(method,"HEAD"))) m=M_GET;
    else if(!strcmp(method,"POST")) m=M_POST;
    else if(!strcmp(method,"PUT")) m=M_PUT;
    else if(!strcmp(method,"DELETE")) m=M_DELETE;

    evaluate_access(path,&finfo,m,&allow,&allow_options,out);
    if(!allow) {
        log_reason("client denied by server configuration",path);
        unmunge_name(path);
        die(FORBIDDEN,path,out);
    }
    if(!(env = add_common_vars(in_headers_env,out)))
        die(NO_MEMORY,"exec_cgi_script",out);

    bytes_sent = 0;
    if(cgi_stub(method,path,path_args,args,env,&finfo,in,out) == REDIRECT_URL)
        die(REDIRECT,location,out);
    /* cgi_stub will screw with env, but only after the fork */
    /*free_env(env);*/
    log_transaction(1);
}

char **set_env_NCSA(FILE *out) {
    char **env;
    int n;
    char t[MAX_STRING_LEN];

    if(!(env = (char **) malloc ((4+2)*sizeof(char *))))
        die(NO_MEMORY,"set_env_NCSA",out);
    n=0;
    env[n++] = make_env_str("PATH",getenv("PATH"),out);

    env[n++] = make_env_str("DOCUMENT_ROOT",document_root,out);
    env[n++] = make_env_str("SERVER_ADMIN",server_admin,out);
    env[n++] = make_env_str("SERVER_ROOT",server_root,out);
    env[n++] = make_env_str("REMOTE_HOST",remote_name,out);
    sprintf(t,"SERVER_NAME=%s:%d",server_hostname,port);
    if(!(env[n++] = strdup(t)))
        die(NO_MEMORY,"set_env_NCSA",out);
    env[n] = NULL;
    return env;
}

void exec_get_NCSA(char *path, char *args, int in, FILE *fd) {
    FILE *tfp;
    struct stat finfo;
    int pfd[2];
    char path_args[MAX_STRING_LEN];
    char t[MAX_STRING_LEN];
    register int n,x;
    char **env;

    env = set_env_NCSA(fd);

    path_args[0] = '\0';
    /* check if it's really a script with extra args */
    n=count_dirs(path);
    for(x=0;x<=n;x++) {
        make_dirstr(path,x+1,t);
        if(!(stat(t,&finfo))) {
            if(S_ISREG(finfo.st_mode)) {
                strcpy(path_args,&path[strlen(t)]);
                strcpy(path,t);
                goto run_script;
            }
        }
    }
    log_reason("script not found or unable to stat",path);
    unmunge_name(path);
    die(NOT_FOUND,path,fd);
  run_script:
    if(!can_exec(&finfo)) {
        log_reason("file permissions deny server execution",path);
        unmunge_name(path);
        die(FORBIDDEN,path,fd);
    }
    evaluate_access(path,&finfo,M_GET,&allow,&allow_options,fd);
    if(!allow) {
        unmunge_name(path);
        die(FORBIDDEN,path,fd);
    }

    if(pipe(pfd) < 0)
        die(SERVER_ERROR,"could not open pipe",fd);

    signal(SIGALRM,send_fd_timed_out);
    signal(SIGPIPE,send_fd_timed_out);
    alarm(timeout);

    if((pid = fork()) < 0)
        die(SERVER_ERROR,"could not fork",fd);
    else if(!pid) {
        char *argv0;

#ifdef __EMX__
        int emxloop;
        char *emxtemp;
        /* For OS/2 place the variables in the current
        enviornment then it will be inherited. This way
        the program will also get all of OS/2's other SETs. */
        for (emxloop=0; ((emxtemp = env[emxloop]) != NULL); emxloop++)
            putenv(emxtemp);    
#endif

        close(pfd[0]);
        if(pfd[1] != STDOUT_FILENO) {
            dup2(pfd[1],STDOUT_FILENO);
            close(pfd[1]);
        }
        if(argv0 = strrchr(path,'/'))
            argv0++;
        else
            argv0 = path;
        if(args[0] && path_args[0]) {
#ifdef __EMX__
            if (strstr(strupr(path), ".CMD") > 0) {
                /* Special case of use of REXX commands as scripts. */
                os2pathname(path);
                if(execl("CMD.EXE","CMD.EXE","/C",path,path_args,args,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            } else {
                if(execl(path,argv0,path_args,args,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            }
#else        
            if(execle(path,argv0,path_args,args,(char *)0,env) == -1) {
                fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                exit(1);
            }
#endif                
        }
        else if(args[0]) {
#ifdef __EMX__
            if (strstr(strupr(path), ".CMD") > 0) {
                /* Special case of use of REXX commands as scripts. */
                os2pathname(path);
                if(execl("CMD.EXE","CMD.EXE","/C",path,args,(char *)0) == -1) { 
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            } else {
                if(execl(path,argv0,args,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }       
            }
#else        
            if(execle(path,argv0,args,(char *)0,env) == -1) {
                fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                exit(1);
            }
#endif                
        }
        else if(path_args[0]) {
#ifdef __EMX__
            if (strstr(strupr(path), ".CMD") > 0) {
                /* Special case of use of REXX commands as scripts. */
                os2pathname(path);                
                if(execl("CMD.EXE","CMD.EXE","/C",path,path_args,(char *)0) == -1) { 
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            } else {
                if(execl(path,argv0,path_args,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }       
            }
#else        
            if(execle(path,argv0,path_args,(char *)0,env) == -1) {
                fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                exit(1);
            }
#endif                
        }
        else {
#ifdef __EMX__
            if (strstr(strupr(path), ".CMD") > 0) {
                /* Special case of use of REXX commands as scripts. */
                os2pathname(path);                
                if(execl("CMD.EXE","CMD.EXE","/C",path,(char *)0) == -1) { 
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }
            } else {
                if(execl(path,argv0,(char *)0) == -1) {
                    fprintf(stderr,"httpd: exec of %s failed, errno is %d\n",path,errno);
                    exit(1);
                }       
            }
#else        
            if(execle(path,argv0,(char *)0,env) == -1) 
                exit(1);
#endif                
        }
    }
    else
        close(pfd[1]);

    tfp = fdopen(pfd[0],"r");


    scan_script_header(tfp,fd,path);
    /* Patch B18 ^^ and vv    - don't force the redirect.. it'll happen
    if(scan_script_header(tfp,fd))
        die(REDIRECT,location,fd);
    */

    if(location[0] == '/') {
        char *t;
        if(!(t = strdup(location)))
            die(NO_MEMORY,"exec_get_NCSA",fd);
        location[0] = '\0';
        send_node(t,"",in,fd);
        htexit(0,fd);
    }

    if(!assbackwards)
        send_http_header(fd);

    if(!header_only) {
        /* Patch B18 send a default body of text if the script
            failed to produce any, but ONLY for redirects */
        if (!send_fd(tfp,fd,NULL) &&  location[0]) {
           title_html(fd,"Document moved");
           fprintf(fd,"This document has moved <A HREF=\"%s\">here</A>.<P>%c",location,LF);
        }
    } else
        kill_children();
    fclose(tfp);
    waitpid(pid,NULL,0);
}



void exec_post_NCSA(char *path, char *args, int in, FILE *out) {
    int inpipe[2],outpipe[2], x;
    char cl[MAX_STRING_LEN];
    FILE *psin,*psout;
    struct stat finfo;
    char **env;
    
    env = set_env_NCSA(out);

    sprintf(cl,"%d",content_length);

    if(stat(path,&finfo) == -1) {
        unmunge_name(path);
        if(errno == ENOENT) die(NOT_FOUND,path,out);
        die(FORBIDDEN,path,out);
    }
    evaluate_access(path,&finfo,M_POST,&allow,&allow_options,out);
    if(!allow)
        die(FORBIDDEN,path,out);

    if(pipe(inpipe) < 0)
        die(SERVER_ERROR,"httpd: could not create IPC pipe",out);
    if(pipe(outpipe) < 0)
        die(SERVER_ERROR,"httpd: could not create IPC pipe",out);
    if((pid = fork()) < 0)
        die(SERVER_ERROR,"httpd: could not fork new process",out);

    if(!pid) {
        char *argv0;

#ifdef __EMX__        
        int emxloop;
        char *emxtemp;
        /* For OS/2 place the variables in the current
        enviornment then it will be inherited. This way
        the program will also get all of OS/2's other SETs. */
        for (emxloop=0; ((emxtemp = env[emxloop]) != NULL); emxloop++) 
            putenv(emxtemp);              
#endif

        if(outpipe[1] != STDOUT_FILENO) {
            dup2(outpipe[1],STDOUT_FILENO);
            close(outpipe[1]);
        }
        if(in != STDIN_FILENO) {
            dup2(in,STDIN_FILENO);
            close(in);
        }
        if((argv0 = strrchr(path,'/')) != NULL)
            argv0++;
        else argv0 = path;
#ifdef __EMX__
        if (strstr(strupr(path), ".CMD") > 0) {
            /* Special case of use of REXX commands as scripts. */
            os2pathname(path);
            if(execl("CMD.EXE","CMD.EXE","/C",path,cl,args,(char *)0) == -1) { 
                fprintf(stderr,"httpd: NCSA9 exec of %s failed, errno is %d\n",path,errno);
                exit(1);
            }
        } else {
            if(execl(path,argv0,cl,args,(char *)0) == -1) {
                fprintf(stderr,"httpd: NCSA10 exec of %s failed, errno is %d\n",
                    path,errno);
                exit(1);
            }       
        }
#else            
        if(execle(path,argv0,cl,args,(char *)0,env) == -1)
            exit(1);
#endif            
    }
    else {
        close(outpipe[1]);
        close(inpipe[0]);
    }

    if(!(psin = fdopen(outpipe[0],"r")))
        die(SERVER_ERROR,"could not read from script",out);


    scan_script_header(psin,out,path);
    /* Patch B18 ^^ and vv   - don't force the redirect, it'll happen 
    if(scan_script_header(psin,out))
        die(REDIRECT,location,out);
    */

    if(location[0] == '/') {
        char *t;
        if(!(t = strdup(location)))
            die(NO_MEMORY,"exec_post_NCSA",out);
        location[0] = '\0';
        send_node(t,"",in,out);
        htexit(0,out);
    }

    content_length = -1;
    if(!assbackwards)
        send_http_header(out);

    /* Patch B18 send a default body of text if the script
       failed to produce any, but ONLY for redirects */
    if (!send_fd(psin,out,NULL) && location[0]) {
           title_html(out,"Document moved");
           fprintf(out,"This document has moved <A HREF=\"%s\">here</A>.<P>%c",location,LF);
    }
    fclose(psin);
    waitpid(pid,NULL,0);
}
