
/*-
 * Copyright (c) 1995 The Apache Group. All rights reserved.
 * 
 *
 * Apache httpd license
 * ====================
 * 
 *
 * This is the license for the Apache Server. It covers all the
 * files which come in this distribution, and should never be removed.
 * 
 * The "Apache Group" has based this server, called "Apache", on
 * public domain code distributed under the name "NCSA httpd 1.3".
 * 
 * NCSA httpd 1.3 was placed in the public domain by the National Center 
 * for Supercomputing Applications at the University of Illinois 
 * at Urbana-Champaign.
 * 
 * As requested by NCSA we acknowledge,
 * 
 *  "Portions developed at the National Center for Supercomputing
 *   Applications at the University of Illinois at Urbana-Champaign."
 *
 * Copyright on the sections of code added by the "Apache Group" belong
 * to the "Apache Group" and/or the original authors. The "Apache Group" and
 * authors hereby grant permission for their code, along with the
 * public domain NCSA code, to be distributed under the "Apache" name.
 * 
 * Reuse of "Apache Group" code outside of the Apache distribution should
 * be acknowledged with the following quoted text, to be included with any new
 * work;
 * 
 * "Portions developed by the "Apache Group", taken with permission 
 *  from the Apache Server   http://www.apache.org/apache/   "
 *
 *
 * Permission is hereby granted to anyone to redistribute Apache under
 * the "Apache" name. We do not grant permission for the resale of Apache, but
 * we do grant permission for vendors to bundle Apache free with other software,
 * or to charge a reasonable price for redistribution, provided it is made
 * clear that Apache is free. Permission is also granted for vendors to 
 * sell support for for Apache. We explicitly forbid the redistribution of 
 * Apache under any other name.
 * 
 * The "Apache Group" makes no promises to support "Apache". Users and
 * sellers of Apache support, and users of "Apache Group" code, should be 
 * aware that they use "Apache" or portions of the "Apache Group" code at 
 * their own risk. While every effort has been made to ensure that "Apache"
 * is robust and safe to use, we will not accept responsibility for any
 * damage caused, or loss of data or income which results from its use.
 * 
 */



/*
 * http_get.c: Handles things associated with GET
 * 
 * Rob McCool
 * 
 */

#include "httpd.h"


int header_only;
int num_includes;
int allow;
char allow_options;


void send_file(char *file, FILE *fd, struct stat *fi, 
               char *path_args, char *args, int in) 
{
    FILE *f;

    set_content_type(file);

    if (!strcmp (content_type, MAP_FILE_MAGIC_TYPE)
    &&! handle_map_file (file, MAX_STRING_LEN, 0, allow_options, fi, fd))
    {
    /* This should really be a 406 No Such Variant error */
    
    log_reason ("No acceptable MIME type in type map", file);
    unmunge_name(file);
    die (NOT_FOUND, file, fd);
    }
    
    if (!strcmp (content_type, CGI_MAGIC_TYPE)) {
        send_cgi("GET",file,path_args,args,fi,in,fd);
        return;
    }
      
    if((allow_options & OPT_INCLUDES) && (!content_encoding[0])) {
#ifdef XBITHACK
        if((fi->st_mode & S_IXUSR) ||
           (!strcmp(content_type,INCLUDES_MAGIC_TYPE)) ||
       (!strcmp(content_type,INCLUDES_MAGIC_TYPE3))) {
          /* XBITHACK users might want to also set the group X bit
              so that a "Last-modified: " date is sent */
           if (fi->st_mode & S_IXGRP)                /* GX-BIT */
                set_last_modified(fi->st_mtime,fd);  /* GX-BIT */
#else
        if(!strcmp(content_type,INCLUDES_MAGIC_TYPE)
       || !strcmp(content_type,INCLUDES_MAGIC_TYPE3)) {
#endif
            status = 200;
            bytes_sent = 0;
            send_parsed_file(file,fd,path_args,args,
                             allow_options & OPT_INCNOEXEC);
            log_transaction(1);
            return;
        }
    }

#ifdef __EMX__
    /* EMX defaults to text mode, we need binary mode. */
    if(!(f=fopen(file,"rb"))) {
#else
    if(!(f=fopen(file,"r"))) {
#endif    
        log_reason("file permissions deny server access",file);
        unmunge_name(file);
        die(FORBIDDEN,file,fd); /* we've already established that it exists */
    }
    status = 200;
    bytes_sent = 0;
    if(!assbackwards && strcmp(content_type, ASIS_MAGIC_TYPE)) {
        set_content_length(fi->st_size);
        set_last_modified(fi->st_mtime,fd);
        send_http_header(fd);
    }
    num_includes=0;
    
    if(!strcmp(content_type, ASIS_MAGIC_TYPE)) {
       scan_script_header(f, fd, file);
       if(!assbackwards)
         send_http_header(fd);
    }
       
       
    if(!header_only) 
        send_fd(f,fd,NULL);
    log_transaction(1);
    fclose(f);
}

void send_cgi(char *method, char *file, char *path_args, char *args, 
              struct stat *finfo, int in, FILE *fd) 
{
    char **env;
    int m;

    if((!strcmp(method,"GET")) || (!strcmp(method,"HEAD")))
        m = M_GET;
    else if(!strcmp(method,"POST"))
        m = M_POST;
    else if(!strcmp(method,"PUT"))
        m = M_PUT;
    else if(!strcmp(method,"DELETE"))
        m = M_DELETE;

    evaluate_access(file,finfo,m,&allow,&allow_options,fd);
    if((!allow) || (!(allow_options & OPT_EXECCGI))) {
        log_reason("client denied by server configuration",file);
        unmunge_name(file);
        die(FORBIDDEN,file,fd);
    }
    if(!(env = add_common_vars(in_headers_env,fd)))
        die(NO_MEMORY,"send_cgi",fd);
    bytes_sent = 0;
    if(cgi_stub(method,file,path_args,args,env,finfo,in,fd) == REDIRECT_URL)
        die(REDIRECT,location,fd);
    /*free_env(env);*/
    log_transaction(0);
}

void send_node(char *file, char *args, int in, FILE *fd)
{
    struct stat finfo;
    char pa[MAX_STRING_LEN], *name_ptr, *end_ptr, temp_name[HUGE_STRING_LEN];
    int need_multi;

    /* Do initial stat(); get PATH_INFO for *.cgi, *.shtml */
    get_path_info (file, pa, &need_multi, &finfo);
    
    evaluate_access(file,&finfo,M_GET,&allow,&allow_options, fd);
    if(!allow) {
        log_reason("client denied by server configuration",file);
        unmunge_name(file);
        die(FORBIDDEN,file,fd);
    }

    /* Do MultiViews if needed ---
     * We prefer scripts if PATH_INFO or QUERY_ARGS were supplied.
     */
    
    if (need_multi
    && !handle_multi (file, MAX_STRING_LEN, args[0] || (pa[0] && pa[1]),
              allow_options, &finfo, fd))
    {
    /* Should be a 406 No Such Variant error */
    
    log_reason ("No file(s) found to satisfy this request", file);
    unmunge_name(file);
    die (NOT_FOUND, file, fd);
    }
    
    if(S_ISDIR(finfo.st_mode)) {
        char ifile[MAX_STRING_LEN];

        if(pa[0] != '/') {
            char url[MAX_STRING_LEN];
            strcpy_dir(ifile,file);
            unmunge_name(ifile);
            construct_url(url,ifile);
            escape_url(url);
            die(REDIRECT,url,fd);
        }

        strncpy(temp_name, index_names, HUGE_STRING_LEN-1);
        end_ptr = name_ptr = temp_name;

        while (*name_ptr) {
          
          while (*name_ptr && isspace (*name_ptr)) ++name_ptr;
          end_ptr = name_ptr;
          if (strchr(end_ptr, ' ') ) {
             end_ptr = strchr(name_ptr, ' ');
             *end_ptr = '\0';
             end_ptr++;
          } else 
             end_ptr += strlen(end_ptr);
           
          make_full_path(file,name_ptr,ifile);  
          if(stat(ifile,&finfo) == -1) {
        if(allow_options & OPT_MULTI
           && handle_multi(ifile, MAX_STRING_LEN, 0, allow_options,
                   &finfo, fd)) {
            send_file (ifile,fd,&finfo,pa,args,in);
            return;
            } else if(! *end_ptr && (allow_options & OPT_INDEXES)) {
                index_directory(file,fd);
                return;
            } else if(! *end_ptr) {
                log_reason("file permissions deny server access",file);
                unmunge_name(file);
                die(FORBIDDEN,file,fd);
            }
          }
          else {
          send_file(ifile,fd,&finfo,pa,args,in);
          return;
          }
          name_ptr = end_ptr;
       }
    }
    if(S_ISREG(finfo.st_mode))
        send_file(file,fd,&finfo,pa,args,in);
    else {
        log_reason("improper file type",file);
        unmunge_name(file);
        die(FORBIDDEN,file,fd); /* device driver or pipe, no permission */
    }
}

void process_get(int in, FILE *out, char *m, char *url, char *args) {
    int s;

    if(assbackwards && header_only) {
        header_only = 0;
        die(BAD_REQUEST,"Invalid HTTP/0.9 method.",out);
    }
    s=translate_name(url,out);
    switch(s) {
      case STD_DOCUMENT:
        send_node(url,args,in,out);
        return;
      case REDIRECT_URL:
        die(REDIRECT,url,out);
      case SCRIPT_NCSA:
        exec_get_NCSA(url,args,in,out);
        return;
      case SCRIPT_CGI:
        exec_cgi_script(m,url,args,in,out);
        return;

      case BAD_URL:
        die(BAD_REQUEST, url, out);
    }
}
