/*
* tbapi.h  - Header file for the TriBBS API
* Copyright (c) 1994-1995 By TriSoft
*/
#ifndef __TBAPIH__
#define __TBAPIH__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <share.h>
#include <stdarg.h>

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

#ifndef SHORT
typedef short int SHORT;
#endif

#ifndef USHORT
typedef unsigned short int USHORT;
#endif

#ifndef LONG
typedef long LONG;
#endif

#ifndef ULONG
typedef unsigned long ULONG;
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef unsigned char BASICSINGLE[4];

typedef union {
		double Value;
		unsigned char Byte[8];
} IEEEDOUBLE;

enum SYSTEMDATABITFIELDS {
	PhoneNumberFlag, TestUploadsFlag, AutoANSIDetectFlag,
	CheckForWaitingMessagesFlag, ULDLRatioTypeFlag,
	PhoneOnHookDuringMaintenanceFlag, NoOneWordNamesFlag,
	NoBulletinMenuAtLogonFlag, AllowAliasesFlag,
	ClearScreenBeforeMenusFlag, ExactFileNameMatchingForDupesFlag,
	DisableNewUserBirthdayPromptFlag, DisableDetailedCallersLogFlag,
	EnableRIPscripEmulationFlag, UseAliasOrRealNamesFlag,
	ClearUploadsAndDownloadsFlag, ClearPrivateMessageAreasFlag,
    ClearPrivateFileAreasFlag, DisableUploadedByFlag, SD1LastBit };

typedef struct {
	char RegistrationCode[81];
	char BoardName[41];
	char SysopName[61];
	char DefaultArchiveExtension[4];
	char SystemPassword[16];
	char VirusCheckerCommandLine[81];
	char ZIPCompressCommandLine[81];
	char ZIPUnCompressCommandLine[81];
	char ARJCompressCommandLine[81];
	char ARJUnCompressCommandLine[81];
	char LZHCompressCommandLine[81];
	char LZHUnCompressCommandLine[81];
	char ARCCompressCommandLine[81];
	char ARCUnCompressCommandLine[81];
	char PAKCompressCommandLine[81];
	char PAKUnCompressCommandLine[81];
	char SDNCompressCommandLine[81];
	char SDNUnCompressCommandLine[81];
	char RARCompressCommandLine[81];
	char RARUnCompressCommandLine[81];
   	char BoardStartDate[9];
	SHORT TotalNodes;
	SHORT CallsToday;
	SHORT MessagesToday;
	SHORT UploadsToday;
	SHORT DownloadsToday;
	SHORT DefaultDailyTimeLimit;
	SHORT DefaultDailyLogons;
	SHORT DefaultTimePerLogon;
	SHORT MinimumSysopSecurityLevel;
	SHORT NewUserSecurityLevel;
	SHORT NewUserTimeLimit;
	SHORT UploadTimeCompensationRatio;
	SHORT MinimumFileAttachmentSecurityLevel;
	SHORT MinimumAtVariableSecurityLevel;
	SHORT FastLogonSecurityLevel;
	LONG TotalCalls;
	unsigned char BitFields[10];
	unsigned char ReservedDataArea[2625];
} SYSDAT1DATA;

typedef struct {
	char Node1sMainDirectory[81];
	char ReservedDataArea[175];
} SYSDAT2DATA;

enum NODEDATABITFIELDS {
	No300BaudCallersFlag, No1200BaudCallersFlag,
	No2400BaudCallersFlag, 	RTSCTSHandshakingFlag,
	LockSerialPortFlag, DirectScreenWriteFlag,
	PageBellOnFlag, UseNodeDISPLAYDirectoryFlag,
    PhoneOffHookDuringEventsFlag, EnableLocalRIPscripEmulationFlag,
	UseFossilDriverFlag, NDLastBit };

typedef struct {
	char InitializationString[81];
	char ErrorCorrectingConnectionMessage[5];
	char ATZString[16];
	char ATAString[16];
	char ATH0String[16];
	char ATH1String[16];
	char DateOfLastCall[9];
	SHORT NodeNumber;
	SHORT SerialPort;
	SHORT DelayBeforeATA;
	SHORT NumberOfRings;
	SHORT NodeSecurityLevel;
	SHORT MaximumKeyboardIdleTime;
	SHORT NonStandardIRQNumber;
	SHORT DelayAfterCONNECT;
	LONG MaximumBaudRate;
	unsigned char BitFields[10];
	unsigned char ReservedDataArea[3907];
} NODEDATA;

enum USERDATABITFIELDS {
	LockedOutFlag,
	MarkedForDeletionFlag, IncludeLOGON1InQWKFlag,
	IncludeGOODBYEInQWKFlag, IncludeBulletinsInQWKFlag,
	IncludeNewFilesInQWKFlag, IncludeNewsletterInQWKFlag,
	CheckWaitingMessagesFlag, GoodbyeAfterUploadFlag,
	AttachedFilesInQWKFlag, UDLastBit };

typedef struct {
	char Name[61];
    char Alias[61];
	char Password[16];
	char StreetAddress1[41];
	char StreetAddress2[41];
    char City[31];
	char State[31];
	char Country[31];
	char ZipCode[11];
	char PhoneNumber[31];
	char Birthday[9];
	char DateOfFirstCall[9];
	char DateOfLastFileCheck[9];
	char SubscriptionExpirationDate[9];
	char DateAndTimeOfLastCall[15];
	SHORT ExpertMode;
	SHORT SecurityLevel;
	SHORT NumberOfCalls;
	SHORT TimeLeftForToday;
	SHORT LastMessageConference;
	SHORT LastFileArea;
	SHORT DefaultProtocol;
	SHORT NumberOfCallsToday;
	SHORT QWKNetworkNode;
	SHORT DefaultEditor;
	SHORT InitialChatStatus;
	SHORT NumberOfFilesDownloadedToday;
	SHORT ArchiveUsedInQWK;
	LONG NumberOfFilesUploaded;
	LONG NumberOfFilesDownloaded;
	LONG NumberOfKBytesUploaded;
	LONG NumberOfKBytesDownloaded;
	LONG NumberOfMessagesPosted;
	LONG NumberOfBytesDownloadedToday;
	unsigned char NetworkFlags[2];
	unsigned char BitFields[10];
	unsigned char ReservedDataArea[556];
} USERSDATA;

enum USERSINDEXFILES { Users, Alias };

typedef struct {
	char Name[61];
	LONG RecordNumber;
} USERSINDEX;

enum USERSUPMESSAGESBITFIELDS {
	AccessPrivateConferenceFlag,
	CoSysopStatusFlag, USMLastBit };

typedef struct {
        LONG LastMessageRead;
		LONG LastWaitingMessageRead;
        SHORT WaitingMessageCounter;
		SHORT QueuedConference;
		unsigned char BitFields[1];
} USERSSUPMESSAGES;

enum USERSUPFILESBITFIELDS {
	AccessPrivateAreaFlag, USFLastBit };

typedef struct {
	unsigned char BitFields[1];
} USERSSUPFILES;

enum MCONFDATABITFIELDS {
	NetworkedConferenceFlag, PrivateConferenceFlag,
	FidoStyleNetMailFlag, AliasConferenceFlag,
	UserDeleteFlag, TriPackBackupFlag,
	DisablePrivateMessagesFlag, DisablePublicMessagesFlag,
	MCLastBit };

typedef struct {
	char Name[41];
	SHORT ReadSecurityLevel;
	SHORT PostSecurityLevel;
	SHORT TriPackNumberOfDaysToSave;
	LONG HighestMessageNumber;
	unsigned char NetworkFlags[2];
	unsigned char BitFields[10];
	unsigned char ReservedDataArea[961];
} MCONFDATA;

typedef struct {
	char Name[41];
	unsigned char ReservedDataArea[215];
} NETWORKDATA;

enum MHDRDATABITFIELDS {
	EchoMessageFlag, ThreadedMessageFlag,
	PrivateMessageFlag, DeletedMessageFlag,
	ReceivedMessageFlag, PermanentMessageFlag,
	TriTossEchoMessageFlag, MHLastBit };

typedef struct {
		char From[61];
		char To[61];
		char Subject[61];
		char NameOfAttachedFile[81];
		char DateAndTime[15];
		SHORT NetMailFromZone;
		SHORT NetMailFromNet;
        SHORT NetMailFromNode;
        SHORT NetMailFromPoint;
        SHORT NetMailToZone;
        SHORT NetMailToNet;
        SHORT NetMailToNode;
        SHORT NetMailToPoint;
        LONG OffsetIntoTextFile;
		LONG MessageLength;
		LONG Number;
        LONG NumberOfMessageThisRepliesTo;
		LONG FromHash, ToHash;
		unsigned char BitFields[10];
		unsigned char ReservedDataArea[695];
} MHDRDATA;

enum FAREADATABTIFIELDS {
	PrivateAreaFlag, CDROMFileAreaFlag,
	AliasAreaFlag, FADLastBit };

typedef struct {
	char Name[41];
	char FileAreaPath[81];
	char FileAreaUploadPath[81];
	char FileAreaFileList[81];
	char FileAreaUploadList[81];
	char FileAreaIndexFile[81];
	char AdditionalFileAreaPaths[10][81];
	SHORT SecurityLevel;
	SHORT ViewSecurityLevel;
	SHORT SortType;
	unsigned char BitFields[10];
	unsigned char ReservedDataArea[2824];
} FAREADATA;

enum DOORSTMPDATAFLAG {
	ANSIFlag, FrontEndFlag,
	FrontEndHangUpFlag, UserWindowFlag,
	ChatRequestedFlag, EventPendingFlag,
	GoodbyeFromDoorFlag, ForceBoardDownAfterCallFlag,
	RIPscripFlag, DOORSYSFlag,
	ErrorCorrectingConnectionFlag, DTLastBit };

typedef struct {
	SHORT TimeLeftAtLogon;
	SHORT CurrentFileArea;
	SHORT CurrentMessageConference;
	SHORT FrontEndTime;
	SHORT WhereTheDoorWasCalledFrom;
	SHORT LanguageNumber;
	SHORT NumberOfFilesFlagged;
	SHORT TimeInDOORSYS;
	LONG UserRecordNumber;
	LONG BaudRate;
	LONG FrontEndBaudRate;
	LONG TimeWhenUserLoggedOn;
	unsigned char BitFields[10];
} DOORSTMPDATA;

typedef struct {
	char Name[61];
	unsigned char ChatBuffer[1024];
	SHORT ChatStatus, NodeChattingWith, Head, Tail;
	unsigned char ReservedDataArea[3003];
} WHOSONDATA;

enum EVENTSDATABITFIELDS {
	EventExecutedTodayFlag, SlidingEventFlag, EDLastBit };

typedef struct {
	char Time[6], File[13];
	SHORT Day;
	unsigned char BitFields[1];
	unsigned char ReservedDataArea[234];
} EVENTSDATA;

typedef struct {
	FILE *file;
	unsigned char *bptr, *cptr;
	SHORT nbuff;
	LONG foffset, fend;
} BFILE;

extern void (*TBErrorRoutine)(char *f, ...);
#ifdef __cplusplus
extern "C" {
#endif
extern SHORT TBIsShare;
extern char TBNode1sMainDirectory[81];
extern char TBNodesMainDirectory[81];
extern SHORT TBNumberOfMessageAreas, TBNumberOfFileAreas;
#ifdef __cplusplus
}
#endif

inline void SetBit(unsigned char *s, SHORT n)
{
	s[n / 8] |= (unsigned char)(1 << (n % 8));
}

inline void ResetBit(unsigned char *s, SHORT n)
{
	s[n / 8] &= (unsigned char)(~(1 << (n % 8)));
}

inline SHORT GetBit(unsigned char *s, SHORT n)
{
	return (s[n / 8] & (1 << (n % 8))) ? 1 : 0;
}

inline void ModifyBit(unsigned char *s, SHORT n, SHORT f)
{
	if (f)
		SetBit(s, n);
	else
		ResetBit(s, n);
}

void ZeroBits(unsigned char *s, SHORT n, SHORT l);

inline void ZeroField(void *s, SHORT n)
{
	memset(s, 0, n);
}

template<class T> class DATAFILE {
private:
	SHORT OpenCloseFlag;
	FILE *File;
	char FileName[81];
public:
	T Data;

	DATAFILE() { OpenCloseFlag = FALSE; }
	~DATAFILE() { Close(); }
	void Open(char *s);
	void Close(void);
	void Read(LONG n);
	void Write(LONG n);
	LONG Length(void);
	void Add(void) { Write(Length() + 1); }
	void ClearIt(void) { ZeroField(&Data, sizeof(T)); }
};

template<class T> void DATAFILE<T>::Open(char *s)
{
	if (OpenCloseFlag)
		Close();
	strcpy(FileName, s);
	strupr(FileName);
	if ((File = fsopen(FileName, "r+b", SH_DENYNO)) == NULL) {
		if ((File = fsopen(FileName, "w+b", SH_DENYNO)) == NULL) {
			(*TBErrorRoutine)("Unable to open: %s", FileName);
			return;
		}
	}
	OpenCloseFlag = TRUE;
}

template<class T> void DATAFILE<T>::Close(void)
{
	if (OpenCloseFlag) {
		fclose(File);
		OpenCloseFlag = FALSE;
	}
}

template<class T> void DATAFILE<T>::Read(LONG n)
{
	SHORT flag = FALSE;

	while (TRUE) {
		if (flag)
			Open(FileName);
		if (!OpenCloseFlag)
			return;
		flag = TRUE;
		if (fseek(File, (LONG)((LONG)(n - 1L) * (LONG)sizeof(T)), SEEK_SET))
			continue;
		if (fsread(&Data, sizeof(T), 1, File))
			break;
	}
}

template<class T> void DATAFILE<T>::Write(LONG n)
{
	SHORT flag = FALSE;

	while (TRUE) {
		if (flag)
			Open(FileName);
		if (!OpenCloseFlag)
			return;
		flag = TRUE;
		if (fseek(File, (LONG)((LONG)(n - 1L) * (LONG)sizeof(T)), SEEK_SET))
			continue;
		if (fswrite(&Data, sizeof(T), 1, File))
			break;
	}
}

template<class T> LONG DATAFILE<T>::Length(void)
{
	long CurrentFilePtr, EndOfFilePtr;

	if (!OpenCloseFlag)
		return 0L;
	CurrentFilePtr = ftell(File);
	fseek(File, 0L, SEEK_END);
	EndOfFilePtr = ftell(File);
	fseek(File, CurrentFilePtr, SEEK_SET);
	return EndOfFilePtr / (LONG)sizeof(T);
}

class SYSDAT1_DAT {
private:
	DATAFILE <SYSDAT1DATA> SysDat1_Dat;
public:
	void Open(void);
	void Close(void) { SysDat1_Dat.Close(); }
	void Read(void) { SysDat1_Dat.Read(1); }
	void Write(void) {
		ZeroBits(SysDat1_Dat.Data.BitFields, SD1LastBit,
			sizeof(SysDat1_Dat.Data.BitFields));
		ZeroField(SysDat1_Dat.Data.ReservedDataArea,
			sizeof(SysDat1_Dat.Data.ReservedDataArea));
		SysDat1_Dat.Write(1);
	}
	void OpenRead(void) { Open(); Read(); }
	void WriteClose(void) { Write(); Close(); }
	void OpenReadClose(void) { OpenRead(); Close(); }
	void OpenWriteClose(void) { Open(); WriteClose(); }
	void ClearIt(void) { SysDat1_Dat.ClearIt(); }
	void Initialize(void);
	char *RegistrationCode(void) { return SysDat1_Dat.Data.RegistrationCode; }
	void RegistrationCode(char *s) {
		strcpy(SysDat1_Dat.Data.RegistrationCode, s); }
	char *BoardName(void) { return SysDat1_Dat.Data.BoardName; }
	void BoardName(char *s) { strcpy(SysDat1_Dat.Data.BoardName, s); }
	char *SysopName(void) { return SysDat1_Dat.Data.SysopName; }
	void SysopName(char *s) { strcpy(SysDat1_Dat.Data.SysopName, s); }
	char *DefaultArchiveExtension(void) {
		 return SysDat1_Dat.Data.DefaultArchiveExtension; }
	void DefaultArchiveExtension(char *s) {
		strcpy(SysDat1_Dat.Data.DefaultArchiveExtension, s); }
	char *SystemPassword(void) { return SysDat1_Dat.Data.SystemPassword; }
	void SystemPassword(char *s)	{
		strcpy(SysDat1_Dat.Data.SystemPassword, s);	}
	char *VirusCheckerCommandLine(void)	{
		return SysDat1_Dat.Data.VirusCheckerCommandLine; }
	void VirusCheckerCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.VirusCheckerCommandLine, s); }
	char *ZIPCompressCommandLine(void) {
		return SysDat1_Dat.Data.ZIPCompressCommandLine;	}
	void ZIPCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ZIPCompressCommandLine, s);	}
	char *ZIPUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.ZIPUnCompressCommandLine; }
	void ZIPUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ZIPUnCompressCommandLine, s); }
	char *ARJCompressCommandLine(void) {
		return SysDat1_Dat.Data.ARJCompressCommandLine;	}
	void ARJCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ARJCompressCommandLine, s);	}
	char *ARJUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.ARJUnCompressCommandLine; }
	void ARJUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ARJUnCompressCommandLine, s); }
	char *LZHCompressCommandLine(void) {
		return SysDat1_Dat.Data.LZHCompressCommandLine;	}
	void LZHCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.LZHCompressCommandLine, s);	}
	char *LZHUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.LZHUnCompressCommandLine; }
	void LZHUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.LZHUnCompressCommandLine, s); }
	char *ARCCompressCommandLine(void) {
		return SysDat1_Dat.Data.ARCCompressCommandLine;	}
	void ARCCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ARCCompressCommandLine, s);	}
	char *ARCUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.ARCUnCompressCommandLine; }
	void ARCUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.ARCUnCompressCommandLine, s); }
	char *PAKCompressCommandLine(void) {
		return SysDat1_Dat.Data.PAKCompressCommandLine;	}
	void PAKCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.PAKCompressCommandLine, s);	}
	char *PAKUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.PAKUnCompressCommandLine; }
	void PAKUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.PAKUnCompressCommandLine, s); }
    char *SDNCompressCommandLine(void) {
		return SysDat1_Dat.Data.SDNCompressCommandLine;	}
	void SDNCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.SDNCompressCommandLine, s);	}
	char *SDNUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.SDNUnCompressCommandLine; }
	void SDNUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.SDNUnCompressCommandLine, s); }
    char *RARCompressCommandLine(void) {
		return SysDat1_Dat.Data.RARCompressCommandLine;	}
	void RARCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.RARCompressCommandLine, s);	}
	char *RARUnCompressCommandLine(void) {
		return SysDat1_Dat.Data.RARUnCompressCommandLine; }
	void RARUnCompressCommandLine(char *s) {
		strcpy(SysDat1_Dat.Data.RARUnCompressCommandLine, s); }
	char *BoardStartDate(void) {
		return SysDat1_Dat.Data.BoardStartDate;	}
	void BoardStartDate(char *s) {
		strcpy(SysDat1_Dat.Data.BoardStartDate, s); }
	SHORT TotalNodes(void) { return SysDat1_Dat.Data.TotalNodes; }
	void TotalNodes(SHORT n) { SysDat1_Dat.Data.TotalNodes = n; }
	SHORT CallsToday(void) { return SysDat1_Dat.Data.CallsToday; }
	void CallsToday(SHORT n) { SysDat1_Dat.Data.CallsToday = n; }
	SHORT MessagesToday(void) { return SysDat1_Dat.Data.MessagesToday; }
	void MessagesToday(SHORT n) { SysDat1_Dat.Data.MessagesToday = n; }
	SHORT UploadsToday(void) { return SysDat1_Dat.Data.UploadsToday; }
	void UploadsToday(SHORT n) { SysDat1_Dat.Data.UploadsToday = n; }
	SHORT DownloadsToday(void) { return SysDat1_Dat.Data.DownloadsToday; }
	void DownloadsToday(SHORT n) { SysDat1_Dat.Data.DownloadsToday = n; }
	SHORT DefaultDailyTimeLimit(void) {
		return SysDat1_Dat.Data.DefaultDailyTimeLimit; }
	void DefaultDailyTimeLimit(SHORT n) {
		SysDat1_Dat.Data.DefaultDailyTimeLimit = n;	}
	SHORT DefaultDailyLogons(void) {
		return SysDat1_Dat.Data.DefaultDailyLogons;	}
	void DefaultDailyLogons(SHORT n) {
		SysDat1_Dat.Data.DefaultDailyLogons = n; }
	SHORT DefaultTimePerLogon(void) {
		return SysDat1_Dat.Data.DefaultTimePerLogon; }
	void DefaultTimePerLogon(SHORT n) {
		SysDat1_Dat.Data.DefaultTimePerLogon = n; }
	SHORT MinimumSysopSecurityLevel(void) {
		return SysDat1_Dat.Data.MinimumSysopSecurityLevel; }
	void MinimumSysopSecurityLevel(SHORT n) {
		SysDat1_Dat.Data.MinimumSysopSecurityLevel = n;	}
	SHORT NewUserSecurityLevel(void) {
		return SysDat1_Dat.Data.NewUserSecurityLevel; }
	void NewUserSecurityLevel(SHORT n) {
		SysDat1_Dat.Data.NewUserSecurityLevel = n; }
	SHORT NewUserTimeLimit(void) {
		return SysDat1_Dat.Data.NewUserTimeLimit; }
	void NewUserTimeLimit(SHORT n) {
		SysDat1_Dat.Data.NewUserTimeLimit = n; }
	SHORT UploadTimeCompensationRatio(void) {
		return SysDat1_Dat.Data.UploadTimeCompensationRatio; }
	void UploadTimeCompensationRatio(SHORT n) {
		SysDat1_Dat.Data.UploadTimeCompensationRatio = n; }
	SHORT MinimumFileAttachmentSecurityLevel(void) {
		return SysDat1_Dat.Data.MinimumFileAttachmentSecurityLevel; }
	void MinimumFileAttachmentSecurityLevel(SHORT n) {
		SysDat1_Dat.Data.MinimumFileAttachmentSecurityLevel = n; }
	SHORT MinimumAtVariableSecurityLevel(void) {
		return SysDat1_Dat.Data.MinimumAtVariableSecurityLevel;	}
	void MinimumAtVariableSecurityLevel(SHORT n) {
		SysDat1_Dat.Data.MinimumAtVariableSecurityLevel = n; }
	SHORT FastLogonSecurityLevel(void) {
		return SysDat1_Dat.Data.FastLogonSecurityLevel;	}
	void FastLogonSecurityLevel(SHORT n) {
		SysDat1_Dat.Data.FastLogonSecurityLevel = n; }
	LONG TotalCalls(void) {
		return SysDat1_Dat.Data.TotalCalls;	}
	void TotalCalls(LONG n) {
		SysDat1_Dat.Data.TotalCalls = n; }
	SHORT PhoneNumber(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, PhoneNumberFlag);	}
	void PhoneNumber(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, PhoneNumberFlag, n); }
	SHORT TestUploads(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, TestUploadsFlag);	}
	void TestUploads(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, TestUploadsFlag, n); }
	SHORT AutoANSIDetect(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, AutoANSIDetectFlag); }
	void AutoANSIDetect(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, AutoANSIDetectFlag, n); }
	SHORT CheckForWaitingMessages(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			CheckForWaitingMessagesFlag); }
	void CheckForWaitingMessages(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, CheckForWaitingMessagesFlag,
			n);	}
	SHORT ULDLRatioType(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, ULDLRatioTypeFlag); }
	void ULDLRatioType(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, ULDLRatioTypeFlag, n); }
	SHORT PhoneOnHookDuringMaintenance(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			PhoneOnHookDuringMaintenanceFlag); }
	void PhoneOnHookDuringMaintenance(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			PhoneOnHookDuringMaintenanceFlag, n); }
	SHORT NoOneWordNames(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, NoOneWordNamesFlag); }
	void NoOneWordNames(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, NoOneWordNamesFlag, n); }
	SHORT NoBulletinMenuAtLogon(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			NoBulletinMenuAtLogonFlag);	}
	void NoBulletinMenuAtLogon(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, NoBulletinMenuAtLogonFlag,
			n);	}
	SHORT AllowAliases(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, AllowAliasesFlag); }
	void AllowAliases(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, AllowAliasesFlag, n);	}
	SHORT ClearScreenBeforeMenus(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			ClearScreenBeforeMenusFlag); }
    void ClearScreenBeforeMenus(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			ClearScreenBeforeMenusFlag, n);	}
	SHORT ExactFileNameMatchingForDupes(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			ExactFileNameMatchingForDupesFlag);	}
	void ExactFileNameMatchingForDupes(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			ExactFileNameMatchingForDupesFlag, n); }
	SHORT DisableNewUserBirthdayPrompt(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			DisableNewUserBirthdayPromptFlag); }
	void DisableNewUserBirthdayPrompt(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			DisableNewUserBirthdayPromptFlag, n); }
	SHORT DisableDetailedCallersLog(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			DisableDetailedCallersLogFlag); }
	void DisableDetailedCallersLog(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, DisableDetailedCallersLogFlag,
			n); }
	SHORT EnableRIPscripEmulation(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			EnableRIPscripEmulationFlag); }
	void EnableRIPscripEmulation(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			EnableRIPscripEmulationFlag, n); }
	SHORT UseAliasOrRealNames(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, UseAliasOrRealNamesFlag);	}
	void UseAliasOrRealNames(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, UseAliasOrRealNamesFlag, n); }
	SHORT ClearUploadsAndDownloads(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			ClearUploadsAndDownloadsFlag); }
	void ClearUploadsAndDownloads(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			ClearUploadsAndDownloadsFlag, n); }
	SHORT ClearPrivateMessageAreas(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			ClearPrivateMessageAreasFlag); }
	void ClearPrivateMessageAreas(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields,
			ClearPrivateMessageAreasFlag, n); }
	SHORT ClearPrivateFileAreas(void) {
		return GetBit(SysDat1_Dat.Data.BitFields,
			ClearPrivateFileAreasFlag); }
	void ClearPrivateFileAreas(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, ClearPrivateFileAreasFlag, n); }
	SHORT DisableUploadedBy(void) {
		return GetBit(SysDat1_Dat.Data.BitFields, DisableUploadedByFlag); }
	void DisableUploadedBy(SHORT n) {
		ModifyBit(SysDat1_Dat.Data.BitFields, DisableUploadedByFlag, n); }
};

class SYSDAT2_DAT {
private:
	DATAFILE <SYSDAT2DATA> SysDat2_Dat;
public:
	void Open(void);
	void Close(void) { SysDat2_Dat.Close(); }
	void Read(void) { SysDat2_Dat.Read(1); }
	void Write(void) {
		ZeroField(SysDat2_Dat.Data.ReservedDataArea,
			sizeof(SysDat2_Dat.Data.ReservedDataArea));
		SysDat2_Dat.Write(1);
	}
	void OpenRead(void) { Open(); Read(); }
	void WriteClose(void) { Write(); Close(); }
	void OpenReadClose(void) { OpenRead(); Close(); }
	void OpenWriteClose(void) { Open(); WriteClose(); }
	void ClearIt(void) { SysDat2_Dat.ClearIt(); }
	void Initialize(void);
	char *Node1sMainDirectory(void) {
		return SysDat2_Dat.Data.Node1sMainDirectory; }
	void Node1sMainDirectory(char *s) {
		strcpy(SysDat2_Dat.Data.Node1sMainDirectory, s); }
};

class NODE_DAT {
private:
	DATAFILE <NODEDATA> Node_Dat;
public:
	void Open(void);
	void Close(void) { Node_Dat.Close(); }
	void Read(void) { Node_Dat.Read(1); }
	void Write(void) {
		ZeroBits(Node_Dat.Data.BitFields, NDLastBit,
			sizeof(Node_Dat.Data.BitFields));
		ZeroField(Node_Dat.Data.ReservedDataArea,
			sizeof(Node_Dat.Data.ReservedDataArea));
		Node_Dat.Write(1);
	}
	void OpenRead(void) { Open(); Read(); }
	void WriteClose(void) { Write(); Close(); }
	void OpenReadClose(void) { OpenRead(); Close(); }
	void OpenWriteClose(void) { Open(); Write(); Close(); }
	void ClearIt(void) { Node_Dat.ClearIt(); }
	void Initialize(void);
	char *InitializationString(void) {
		return Node_Dat.Data.InitializationString; }
	void InitializationString(char *s) {
		strcpy(Node_Dat.Data.InitializationString, s); }
	char *ErrorCorrectingConnectionMessage(void) {
		return Node_Dat.Data.ErrorCorrectingConnectionMessage; }
	void ErrorCorrectingConnectionMessage(char *s) {
		strcpy(Node_Dat.Data.ErrorCorrectingConnectionMessage, s); }
	char *ATZString(void) {
		return Node_Dat.Data.ATZString;	}
	void ATZString(char *s) {
		strcpy(Node_Dat.Data.ATZString, s);	}
	char *ATAString(void) {
		return Node_Dat.Data.ATAString;	}
	void ATAString(char *s) {
		strcpy(Node_Dat.Data.ATAString, s);	}
	char *ATH0String(void) {
		return Node_Dat.Data.ATH0String; }
	void ATH0String(char *s) {
		strcpy(Node_Dat.Data.ATH0String, s); }
	char *ATH1String(void) {
		return Node_Dat.Data.ATH1String; }
	void ATH1String(char *s) {
		strcpy(Node_Dat.Data.ATH1String, s); }
	char *DateOfLastCall(void) { return Node_Dat.Data.DateOfLastCall; }
	void DateOfLastCall(char *s) { strcpy(Node_Dat.Data.DateOfLastCall, s); }
	SHORT NodeNumber(void) { return Node_Dat.Data.NodeNumber; }
	void NodeNumber(SHORT n) { Node_Dat.Data.NodeNumber = n; }
	SHORT SerialPort(void) { return Node_Dat.Data.SerialPort; }
	void SerialPort(SHORT n) { Node_Dat.Data.SerialPort = n; }
	SHORT DelayBeforeATA(void) { return Node_Dat.Data.DelayBeforeATA; }
	void DelayBeforeATA(SHORT n) { Node_Dat.Data.DelayBeforeATA = n; }
	SHORT DelayAfterCONNECT(void) { return Node_Dat.Data.DelayAfterCONNECT; }
	void DelayAfterCONNECT(SHORT n) { Node_Dat.Data.DelayAfterCONNECT = n; }
	SHORT NumberOfRings(void) { return Node_Dat.Data.NumberOfRings; }
	void NumberOfRings(SHORT n) { Node_Dat.Data.NumberOfRings = n; }
	SHORT NodeSecurityLevel(void) { return Node_Dat.Data.NodeSecurityLevel; }
	void NodeSecurityLevel(SHORT n) { Node_Dat.Data.NodeSecurityLevel = n; }
	SHORT MaximumKeyboardIdleTime(void) {
		return Node_Dat.Data.MaximumKeyboardIdleTime; }
	void MaximumKeyboardIdleTime(SHORT n) {
		Node_Dat.Data.MaximumKeyboardIdleTime = n; }
	SHORT NonStandardIRQNumber(void) {
		return Node_Dat.Data.NonStandardIRQNumber; }
	void NonStandardIRQNumber(SHORT n) {
		Node_Dat.Data.NonStandardIRQNumber = n;	}
	LONG MaximumBaudRate(void) { return Node_Dat.Data.MaximumBaudRate; }
	void MaximumBaudRate(LONG n) { Node_Dat.Data.MaximumBaudRate = n; }
	SHORT No300BaudCallers(void) {
		return GetBit(Node_Dat.Data.BitFields, No300BaudCallersFlag); }
	void No300BaudCallers(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, No300BaudCallersFlag, n); }
	SHORT No1200BaudCallers(void) {
		return GetBit(Node_Dat.Data.BitFields, No1200BaudCallersFlag); }
	void No1200BaudCallers(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, No1200BaudCallersFlag, n); }
	SHORT No2400BaudCallers(void) {
		return GetBit(Node_Dat.Data.BitFields, No2400BaudCallersFlag); }
	void No2400BaudCallers(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, No2400BaudCallersFlag, n); }
	SHORT RTSCTSHandshaking(void) {
		return GetBit(Node_Dat.Data.BitFields, RTSCTSHandshakingFlag); }
	void RTSCTSHandshaking(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, RTSCTSHandshakingFlag, n); }
	SHORT LockSerialPort(void) {
		return GetBit(Node_Dat.Data.BitFields, LockSerialPortFlag);	}
	void LockSerialPort(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, LockSerialPortFlag, n); }
	SHORT DirectScreenWrite(void) {
		return GetBit(Node_Dat.Data.BitFields, DirectScreenWriteFlag); }
	void DirectScreenWrite(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, DirectScreenWriteFlag, n); }
	SHORT PageBellOn(void) {
		return GetBit(Node_Dat.Data.BitFields, PageBellOnFlag);	}
	void PageBellOn(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, PageBellOnFlag, n); }
	SHORT UseNodeDISPLAYDirectory(void) {
		return GetBit(Node_Dat.Data.BitFields, UseNodeDISPLAYDirectoryFlag); }
	void UseNodeDISPLAYDirectory(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, UseNodeDISPLAYDirectoryFlag, n);	}
	SHORT PhoneOffHookDuringEvents(void) {
		return GetBit(Node_Dat.Data.BitFields,
			PhoneOffHookDuringEventsFlag); }
	void PhoneOffHookDuringEvents(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields, PhoneOffHookDuringEventsFlag, n); }
	SHORT EnableLocalRIPscripEmulation(void) {
        return GetBit(Node_Dat.Data.BitFields,
			EnableLocalRIPscripEmulationFlag); }
	void EnableLocalRIPscripEmulation(SHORT n) {
        ModifyBit(Node_Dat.Data.BitFields,
			EnableLocalRIPscripEmulationFlag, n); }
	SHORT UseFossilDriver(void) {
		return GetBit(Node_Dat.Data.BitFields,
			UseFossilDriverFlag); }
	void UseFossilDriver(SHORT n) {
		ModifyBit(Node_Dat.Data.BitFields,
			UseFossilDriverFlag, n); }
};

class USERS_DAT {
private:
	DATAFILE <USERSDATA> Users_Dat;
public:
	void Open(void);
	void Close(void) { Users_Dat.Close(); }
	void Read(USHORT n) { Users_Dat.Read(n); }
	void Write(USHORT n) {
		ZeroBits(Users_Dat.Data.BitFields, UDLastBit,
			sizeof(Users_Dat.Data.BitFields));
		ZeroField(Users_Dat.Data.ReservedDataArea,
			sizeof(Users_Dat.Data.ReservedDataArea));
		Users_Dat.Write(n);
	}
	LONG Length(void) { return Users_Dat.Length(); }
	void OpenRead(USHORT n) { Open(); Read(n); }
	void WriteClose(USHORT n) { Write(n); Close(); }
	void OpenReadClose(USHORT n) { OpenRead(n); Close(); }
	void OpenWriteClose(USHORT n) { Open(); WriteClose(n); }
    void ClearIt(void) { Users_Dat.ClearIt(); }
	char *Name(void) { return Users_Dat.Data.Name; }
	void Name(char *s) { strcpy(Users_Dat.Data.Name, s); }
	char *Alias(void) { return Users_Dat.Data.Alias; }
	void Alias(char *s) { strcpy(Users_Dat.Data.Alias, s); }
	char *Password(void) { return Users_Dat.Data.Password; }
	void Password(char *s) { strcpy(Users_Dat.Data.Password, s); }
	char *StreetAddress1(void) { return Users_Dat.Data.StreetAddress1; }
	void StreetAddress1(char *s) { strcpy(Users_Dat.Data.StreetAddress1, s); }
	char *StreetAddress2(void) { return Users_Dat.Data.StreetAddress2; }
	void StreetAddress2(char *s) { strcpy(Users_Dat.Data.StreetAddress2, s); }
	char *City(void) { return Users_Dat.Data.City; }
	void City(char *s) { strcpy(Users_Dat.Data.City, s); }
	char *State(void) { return Users_Dat.Data.State; }
	void State(char *s) { strcpy(Users_Dat.Data.State, s); }
	char *Country(void) { return Users_Dat.Data.Country; }
	void Country(char *s) { strcpy(Users_Dat.Data.Country, s); }
	char *ZipCode(void) { return Users_Dat.Data.ZipCode; }
	void ZipCode(char *s) { strcpy(Users_Dat.Data.ZipCode, s); }
	char *PhoneNumber(void) { return Users_Dat.Data.PhoneNumber; }
	void PhoneNumber(char *s) { strcpy(Users_Dat.Data.PhoneNumber, s); }
	char *Birthday(void) { return Users_Dat.Data.Birthday; }
	void Birthday(char *s) { strcpy(Users_Dat.Data.Birthday, s); }
	char *DateOfFirstCall(void) { return Users_Dat.Data.DateOfFirstCall; }
	void DateOfFirstCall(char *s) {
		strcpy(Users_Dat.Data.DateOfFirstCall, s); }
	char *DateOfLastFileCheck(void) {
		return Users_Dat.Data.DateOfLastFileCheck; }
	void DateOfLastFileCheck(char *s) {
		strcpy(Users_Dat.Data.DateOfLastFileCheck, s); }
	char *SubscriptionExpirationDate(void) {
		return Users_Dat.Data.SubscriptionExpirationDate; }
	void SubscriptionExpirationDate(char *s) {
		strcpy(Users_Dat.Data.SubscriptionExpirationDate, s); }
	char *DateAndTimeOfLastCall(void) {
		return Users_Dat.Data.DateAndTimeOfLastCall; }
	void DateAndTimeOfLastCall(char *s) {
		strcpy(Users_Dat.Data.DateAndTimeOfLastCall, s); }
	SHORT ExpertMode(void) { return Users_Dat.Data.ExpertMode; }
	void ExpertMode(SHORT n) { Users_Dat.Data.ExpertMode = n; }
	SHORT SecurityLevel(void) { return Users_Dat.Data.SecurityLevel; }
	void SecurityLevel(SHORT n) { Users_Dat.Data.SecurityLevel = n; }
	SHORT NumberOfCalls(void) { return Users_Dat.Data.NumberOfCalls; }
	void NumberOfCalls(SHORT n) { Users_Dat.Data.NumberOfCalls = n; }
	SHORT TimeLeftForToday(void) { return Users_Dat.Data.TimeLeftForToday; }
	void TimeLeftForToday(SHORT n) { Users_Dat.Data.TimeLeftForToday = n; }
	SHORT LastMessageConference(void) {
		return Users_Dat.Data.LastMessageConference; }
	void LastMessageConference(SHORT n) {
		Users_Dat.Data.LastMessageConference = n; }
	SHORT LastFileArea(void) { return Users_Dat.Data.LastFileArea; }
	void LastFileArea(SHORT n) { Users_Dat.Data.LastFileArea = n; }
	SHORT DefaultProtocol(void) { return Users_Dat.Data.DefaultProtocol; }
	void DefaultProtocol(SHORT n) { Users_Dat.Data.DefaultProtocol = n; }
	SHORT NumberOfCallsToday(void) {
		return Users_Dat.Data.NumberOfCallsToday; }
	void NumberOfCallsToday(SHORT n) {
		Users_Dat.Data.NumberOfCallsToday = n; }
	SHORT DefaultEditor(void) { return Users_Dat.Data.DefaultEditor; }
	void DefaultEditor(SHORT n) { Users_Dat.Data.DefaultEditor = n; }
	SHORT InitialChatStatus(void) { return Users_Dat.Data.InitialChatStatus; }
	void InitialChatStatus(SHORT n) { Users_Dat.Data.InitialChatStatus = n; }
	SHORT NumberOfFilesDownloadedToday(void) {
		return Users_Dat.Data.NumberOfFilesDownloadedToday;	}
	void NumberOfFilesDownloadedToday(SHORT n) {
		Users_Dat.Data.NumberOfFilesDownloadedToday = n; }
	SHORT ArchiveUsedInQWK(void) { return Users_Dat.Data.ArchiveUsedInQWK; }
	void ArchiveUsedInQWK(SHORT n) { Users_Dat.Data.ArchiveUsedInQWK = n; }
	LONG NumberOfFilesUploaded(void) {
		return Users_Dat.Data.NumberOfFilesUploaded; }
	void NumberOfFilesUploaded(LONG n) {
		Users_Dat.Data.NumberOfFilesUploaded = n; }
	LONG NumberOfFilesDownloaded(void) {
		return Users_Dat.Data.NumberOfFilesDownloaded; }
	void NumberOfFilesDownloaded(LONG n) {
		Users_Dat.Data.NumberOfFilesDownloaded = n; }
	LONG NumberOfKBytesUploaded(void) {
		return Users_Dat.Data.NumberOfKBytesUploaded; }
	void NumberOfKBytesUploaded(LONG n) {
		Users_Dat.Data.NumberOfKBytesUploaded = n; }
	LONG NumberOfKBytesDownloaded(void) {
		return Users_Dat.Data.NumberOfKBytesDownloaded; }
	void NumberOfKBytesDownloaded(LONG n) {
		Users_Dat.Data.NumberOfKBytesDownloaded = n; }
	LONG NumberOfMessagesPosted(void) {
		return Users_Dat.Data.NumberOfMessagesPosted; }
	void NumberOfMessagesPosted(LONG n) {
		Users_Dat.Data.NumberOfMessagesPosted = n; }
	LONG NumberOfBytesDownloadedToday(void) {
		return Users_Dat.Data.NumberOfBytesDownloadedToday; }
	void NumberOfBytesDownloadedToday(LONG n) {
		Users_Dat.Data.NumberOfBytesDownloadedToday = n; }
	unsigned char *NetworkPtr(void) { return Users_Dat.Data.NetworkFlags; }
	SHORT Network(SHORT nw) {
        return GetBit(Users_Dat.Data.NetworkFlags, nw); }
    void Network(SHORT nw, SHORT n) {
        ModifyBit(Users_Dat.Data.NetworkFlags, nw, n); }
	SHORT LockedOut(void) {
		return GetBit(Users_Dat.Data.BitFields, LockedOutFlag);	}
	void LockedOut(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, LockedOutFlag, n); }
	SHORT MarkedForDeletion(void) {
		return GetBit(Users_Dat.Data.BitFields, MarkedForDeletionFlag);	}
	void MarkedForDeletion(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, MarkedForDeletionFlag, n); }
	SHORT IncludeLOGON1InQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, IncludeLOGON1InQWKFlag);	}
	void IncludeLOGON1InQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, IncludeLOGON1InQWKFlag, n); }
	SHORT IncludeGOODBYEInQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, IncludeGOODBYEInQWKFlag);	}
	void IncludeGOODBYEInQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, IncludeGOODBYEInQWKFlag, n); }
	SHORT IncludeBulletinsInQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, IncludeBulletinsInQWKFlag);	}
	void IncludeBulletinsInQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, IncludeBulletinsInQWKFlag, n); }
	SHORT IncludeNewFilesInQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, IncludeNewFilesInQWKFlag);	}
	void IncludeNewFilesInQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, IncludeNewFilesInQWKFlag, n); }
	SHORT IncludeNewsletterInQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, IncludeNewsletterInQWKFlag);	}
	void IncludeNewsletterInQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, IncludeNewsletterInQWKFlag, n); }
	SHORT CheckWaitingMessages(void) {
		return GetBit(Users_Dat.Data.BitFields, CheckWaitingMessagesFlag);	}
	void CheckWaitingMessages(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, CheckWaitingMessagesFlag, n); }
	SHORT GoodbyeAfterUpload(void) {
		return GetBit(Users_Dat.Data.BitFields, GoodbyeAfterUploadFlag);	}
	void GoodbyeAfterUpload(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, GoodbyeAfterUploadFlag, n); }
	SHORT AttachedFilesInQWK(void) {
		return GetBit(Users_Dat.Data.BitFields, AttachedFilesInQWKFlag);	}
	void AttachedFilesInQWK(SHORT n) {
		ModifyBit(Users_Dat.Data.BitFields, AttachedFilesInQWKFlag, n); }
};

class USERS_IDX {
private:
	DATAFILE <USERSINDEX> Users_Idx;
public:
	void Open(int t);
	void Close(void) { Users_Idx.Close(); }
	void Read(USHORT n) { Users_Idx.Read(n); }
	void Write(USHORT n) { Users_Idx.Write(n); }
	LONG Length(void) { return Users_Idx.Length(); }
	void OpenRead(int t, USHORT n) { Open(t); Read(n); }
	void WriteClose(USHORT n) { Write(n); Close(); }
	void OpenReadClose(int t, USHORT n) { OpenRead(t, n); Close(); }
	void OpenWriteClose(int t, USHORT n) { Open(t); WriteClose(n); }
    void ClearIt(void) { Users_Idx.ClearIt(); }
	LONG Search(char *s);
	LONG Insert(char *s, LONG n);
	void Replace(char *os, char *ns);
	char *Name(void) { return Users_Idx.Data.Name; }
	void Name(char *s) { strcpy(Users_Idx.Data.Name, s); }
    USHORT RecordNumber(void) { return (USHORT)Users_Idx.Data.RecordNumber; }
	void RecordNumber(USHORT n) { Users_Idx.Data.RecordNumber = n; }
};

class USERS_SPM {
private:
	DATAFILE <USERSSUPMESSAGES> Users_Spm;
public:
	void Open(void);
	void Close(void) { Users_Spm.Close(); }
	void Read(USHORT u, SHORT n) {
		Users_Spm.Read((LONG)(u - 1) * (LONG)TBNumberOfMessageAreas +
			(LONG)n); }
	void Write(USHORT u, SHORT n) {
		ZeroBits(Users_Spm.Data.BitFields, USMLastBit,
			sizeof(Users_Spm.Data.BitFields));
		Users_Spm.Write((LONG)(u - 1) * (LONG)TBNumberOfMessageAreas +
			(LONG)n); }
	void OpenRead(USHORT u, SHORT n) { Open(); Read(u, n); }
	void WriteClose(USHORT u, SHORT n) { Write(u, n); Close(); }
	void OpenReadClose(USHORT u, SHORT n) { OpenRead(u, n); Close(); }
	void OpenWriteClose(USHORT u, SHORT n) { Open(); WriteClose(u, n); }
	void ClearIt(void) { Users_Spm.ClearIt(); }
	LONG LastMessageRead(void) { return Users_Spm.Data.LastMessageRead; }
	void LastMessageRead(LONG n) { Users_Spm.Data.LastMessageRead = n; }
	LONG LastWaitingMessageRead(void) {
		return Users_Spm.Data.LastWaitingMessageRead; }
	void LastWaitingMessageRead(LONG n) {
		Users_Spm.Data.LastWaitingMessageRead = n; }
	SHORT WaitingMessageCounter(void) {
		return Users_Spm.Data.WaitingMessageCounter; }
	void WaitingMessageCounter(SHORT n) {
		Users_Spm.Data.WaitingMessageCounter = n; }
	SHORT QueuedConference(void) {
		return Users_Spm.Data.QueuedConference;	}
	void QueuedConference(SHORT n) {
		Users_Spm.Data.QueuedConference = n; }
	SHORT AccessPrivateConference(void) {
		return GetBit(Users_Spm.Data.BitFields, AccessPrivateConferenceFlag);	}
	void AccessPrivateConference(SHORT n) {
		ModifyBit(Users_Spm.Data.BitFields, AccessPrivateConferenceFlag, n); }
	SHORT CoSysopStatus(void) {
		return GetBit(Users_Spm.Data.BitFields, CoSysopStatusFlag);	}
	void CoSysopStatus(SHORT n) {
		ModifyBit(Users_Spm.Data.BitFields, CoSysopStatusFlag, n); }
};

class USERS_SPF {
private:
	DATAFILE <USERSSUPFILES> Users_Spf;
public:
	void Open(void);
	void Close(void) { Users_Spf.Close(); }
	void Read(USHORT u, SHORT n) {
		Users_Spf.Read((LONG)(u - 1) * (LONG)TBNumberOfFileAreas +
			(LONG)n); }
	void Write(USHORT u, SHORT n) {
		ZeroBits(Users_Spf.Data.BitFields, USFLastBit,
			sizeof(Users_Spf.Data.BitFields));
		Users_Spf.Write((LONG)(u - 1) * (LONG)TBNumberOfFileAreas +
			(LONG)n); }
	void OpenRead(USHORT u, SHORT n) { Open(); Read(u, n); }
	void WriteClose(USHORT u, SHORT n) { Write(u, n); Close(); }
	void OpenReadClose(USHORT u, SHORT n) { OpenRead(u, n); Close(); }
	void OpenWriteClose(USHORT u, SHORT n) { Open(); WriteClose(u, n); }
    void ClearIt(void) { Users_Spf.ClearIt(); }
	SHORT AccessPrivateArea(void) {
		return GetBit(Users_Spf.Data.BitFields, AccessPrivateAreaFlag);	}
	void AccessPrivateArea(SHORT n) {
		ModifyBit(Users_Spf.Data.BitFields, AccessPrivateAreaFlag, n); }
};

class MCONF_DAT {
private:
	DATAFILE <MCONFDATA> Mconf_Dat;
public:
	void Open(void);
	void Close(void) { Mconf_Dat.Close(); }
	void Read(SHORT n) { Mconf_Dat.Read(n); }
	void Write(SHORT n) {
		ZeroBits(Mconf_Dat.Data.BitFields, MCLastBit,
			sizeof(Mconf_Dat.Data.BitFields));
		ZeroField(Mconf_Dat.Data.ReservedDataArea,
			sizeof(Mconf_Dat.Data.ReservedDataArea));
		Mconf_Dat.Write(n); }
	LONG Length(void) { return Mconf_Dat.Length(); }
	void OpenRead(SHORT n) { Open(); Read(n); }
	void WriteClose(SHORT n) { Write(n); Close(); }
	void OpenReadClose(SHORT n) { OpenRead(n); Close(); }
	void OpenWriteClose(SHORT n) { Open(); WriteClose(n); }
	void ClearIt(void) { Mconf_Dat.ClearIt(); }
	char *Name(void) { return Mconf_Dat.Data.Name; }
	void Name(char *s) { strcpy(Mconf_Dat.Data.Name, s); }
	SHORT ReadSecurityLevel(void) { return Mconf_Dat.Data.ReadSecurityLevel; }
	void ReadSecurityLevel(SHORT n) { Mconf_Dat.Data.ReadSecurityLevel = n; }
	SHORT PostSecurityLevel(void) { return Mconf_Dat.Data.PostSecurityLevel; }
	void PostSecurityLevel(SHORT n) { Mconf_Dat.Data.PostSecurityLevel = n; }
	SHORT TriPackNumberOfDaysToSave(void) {
		return Mconf_Dat.Data.TriPackNumberOfDaysToSave; }
	void TriPackNumberOfDaysToSave(SHORT n) {
		Mconf_Dat.Data.TriPackNumberOfDaysToSave = n; }
	LONG HighestMessageNumber(void) {
		return Mconf_Dat.Data.HighestMessageNumber; }
	void HighestMessageNumber(LONG n) {
		Mconf_Dat.Data.HighestMessageNumber = n; }
	unsigned char *NetworkPtr(void) { return Mconf_Dat.Data.NetworkFlags; }
	SHORT Network(SHORT nw) {
		return GetBit(Mconf_Dat.Data.NetworkFlags, nw); }
	void Network(SHORT nw, SHORT n) {
		ModifyBit(Mconf_Dat.Data.NetworkFlags, nw, n); }
	SHORT NetworkedConference(void) {
		return GetBit(Mconf_Dat.Data.BitFields, NetworkedConferenceFlag);	}
	void NetworkedConference(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, NetworkedConferenceFlag, n); }
	SHORT PrivateConference(void) {
		return GetBit(Mconf_Dat.Data.BitFields, PrivateConferenceFlag);	}
	void PrivateConference(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, PrivateConferenceFlag, n); }
	SHORT FidoStyleNetMail(void) {
		return GetBit(Mconf_Dat.Data.BitFields, FidoStyleNetMailFlag);	}
	void FidoStyleNetMail(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, FidoStyleNetMailFlag, n); }
	SHORT AliasConference(void) {
		return GetBit(Mconf_Dat.Data.BitFields, AliasConferenceFlag);	}
	void AliasConference(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, AliasConferenceFlag, n); }
	SHORT UserDelete(void) {
		return GetBit(Mconf_Dat.Data.BitFields, UserDeleteFlag);	}
	void UserDelete(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, UserDeleteFlag, n); }
	SHORT TriPackBackup(void) {
		return GetBit(Mconf_Dat.Data.BitFields, TriPackBackupFlag);	}
	void TriPackBackup(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, TriPackBackupFlag, n); }
	SHORT DisablePrivateMessages(void) {
		return GetBit(Mconf_Dat.Data.BitFields, DisablePrivateMessagesFlag);	}
	void DisablePrivateMessages(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, DisablePrivateMessagesFlag, n); }
	SHORT DisablePublicMessages(void) {
		return GetBit(Mconf_Dat.Data.BitFields, DisablePublicMessagesFlag);	}
	void DisablePublicMessages(SHORT n) {
		ModifyBit(Mconf_Dat.Data.BitFields, DisablePublicMessagesFlag, n); }
};

class NETWORK_DAT {
private:
	DATAFILE <NETWORKDATA> Network_Dat;
public:
	void Open(void);
	void Close(void) { Network_Dat.Close(); }
	void Read(SHORT n) { Network_Dat.Read(n); }
	void Write(SHORT n) {
		ZeroField(Network_Dat.Data.ReservedDataArea,
			sizeof(Network_Dat.Data.ReservedDataArea));
		Network_Dat.Write(n); }
	LONG Length(void) { return Network_Dat.Length(); }
	void OpenRead(SHORT n) { Open(); Read(n); }
	void WriteClose(SHORT n) { Write(n); Close(); }
	void OpenReadClose(SHORT n) { OpenRead(n); Close(); }
	void OpenWriteClose(SHORT n) { Open(); WriteClose(n); }
	void ClearIt(void) { Network_Dat.ClearIt(); }
	char *Name(void) { return Network_Dat.Data.Name; }
	void Name(char *s) { strcpy(Network_Dat.Data.Name, s); }
};

class MNNNN_HDR {
private:
	DATAFILE <MHDRDATA> Mnnnn_Hdr;
public:
	void Open(SHORT c);
	void Close(void) { Mnnnn_Hdr.Close(); }
	void Read(SHORT n) { Mnnnn_Hdr.Read(n); }
	void Write(SHORT n) {
		ZeroBits(Mnnnn_Hdr.Data.BitFields, MHLastBit,
			sizeof(Mnnnn_Hdr.Data.BitFields));
		ZeroField(Mnnnn_Hdr.Data.ReservedDataArea,
			sizeof(Mnnnn_Hdr.Data.ReservedDataArea));
		Mnnnn_Hdr.Write(n); }
	LONG Length(void) { return Mnnnn_Hdr.Length(); }
	void OpenRead(SHORT c, SHORT n) { Open(c); Read(n); }
	void WriteClose(SHORT n) { Write(n); Close(); }
	void OpenReadClose(SHORT c, SHORT n) { OpenRead(c, n); Close(); }
	void OpenWriteClose(SHORT c, SHORT n) { Open(c); WriteClose(n); }
	void ClearIt(void) { Mnnnn_Hdr.ClearIt(); }
	SHORT Search(LONG n);
	SHORT GetNext(LONG n);
	SHORT GetYourNext(LONG h, LONG n);
	char *From(void) { return Mnnnn_Hdr.Data.From; }
	void From(char *s) { strcpy(Mnnnn_Hdr.Data.From, s); }
	char *To(void) { return Mnnnn_Hdr.Data.To; }
	void To(char *s) { strcpy(Mnnnn_Hdr.Data.To, s); }
	char *Subject(void) { return Mnnnn_Hdr.Data.Subject; }
	void Subject(char *s) { strcpy(Mnnnn_Hdr.Data.Subject, s); }
	char *NameOfAttachedFile(void) {
		return Mnnnn_Hdr.Data.NameOfAttachedFile; }
	void NameOfAttachedFile(char *s) {
		strcpy(Mnnnn_Hdr.Data.NameOfAttachedFile, s); }
	char *DateAndTime(void) { return Mnnnn_Hdr.Data.DateAndTime; }
	void DateAndTime(char *s) { strcpy(Mnnnn_Hdr.Data.DateAndTime, s); }
	SHORT NetMailFromZone(void) { return Mnnnn_Hdr.Data.NetMailFromZone; }
	void NetMailFromZone(SHORT n) { Mnnnn_Hdr.Data.NetMailFromZone = n; }
	SHORT NetMailFromNet(void) { return Mnnnn_Hdr.Data.NetMailFromNet; }
	void NetMailFromNet(SHORT n) { Mnnnn_Hdr.Data.NetMailFromNet = n; }
	SHORT NetMailFromNode(void) { return Mnnnn_Hdr.Data.NetMailFromNode; }
	void NetMailFromNode(SHORT n) { Mnnnn_Hdr.Data.NetMailFromNode = n; }
	SHORT NetMailFromPoint(void) { return Mnnnn_Hdr.Data.NetMailFromPoint; }
	void NetMailFromPoint(SHORT n) { Mnnnn_Hdr.Data.NetMailFromPoint = n; }
	SHORT NetMailToZone(void) { return Mnnnn_Hdr.Data.NetMailToZone; }
	void NetMailToZone(SHORT n) { Mnnnn_Hdr.Data.NetMailToZone = n; }
	SHORT NetMailToNet(void) { return Mnnnn_Hdr.Data.NetMailToNet; }
	void NetMailToNet(SHORT n) { Mnnnn_Hdr.Data.NetMailToNet = n; }
	SHORT NetMailToNode(void) { return Mnnnn_Hdr.Data.NetMailToNode; }
	void NetMailToNode(SHORT n) { Mnnnn_Hdr.Data.NetMailToNode = n; }
	SHORT NetMailToPoint(void) { return Mnnnn_Hdr.Data.NetMailToPoint; }
	void NetMailToPoint(SHORT n) { Mnnnn_Hdr.Data.NetMailToPoint = n; }
	LONG OffsetIntoTextFile(void) {
		return Mnnnn_Hdr.Data.OffsetIntoTextFile; }
	void OffsetIntoTextFile(LONG n) {
		Mnnnn_Hdr.Data.OffsetIntoTextFile = n; }
	LONG MessageLength(void) { return Mnnnn_Hdr.Data.MessageLength; }
	void MessageLength(LONG n) { Mnnnn_Hdr.Data.MessageLength = n; }
	LONG Number(void) { return Mnnnn_Hdr.Data.Number; }
	void Number(LONG n) { Mnnnn_Hdr.Data.Number = n; }
	LONG NumberOfMessageThisRepliesTo(void) {
		return Mnnnn_Hdr.Data.NumberOfMessageThisRepliesTo; }
	void NumberOfMessageThisRepliesTo(LONG n) {
		Mnnnn_Hdr.Data.NumberOfMessageThisRepliesTo = n; }
	LONG FromHash(void) { return Mnnnn_Hdr.Data.FromHash; }
	void FromHash(LONG n) { Mnnnn_Hdr.Data.FromHash = n; }
	LONG ToHash(void) { return Mnnnn_Hdr.Data.ToHash; }
	void ToHash(LONG n) { Mnnnn_Hdr.Data.ToHash = n; }
	SHORT EchoMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, EchoMessageFlag);	}
	void EchoMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, EchoMessageFlag, n); }
	SHORT ThreadedMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, ThreadedMessageFlag);	}
	void ThreadedMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, ThreadedMessageFlag, n); }
	SHORT PrivateMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, PrivateMessageFlag);	}
	void PrivateMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, PrivateMessageFlag, n); }
	SHORT DeletedMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, DeletedMessageFlag);	}
	void DeletedMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, DeletedMessageFlag, n); }
	SHORT ReceivedMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, ReceivedMessageFlag);	}
	void ReceivedMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, ReceivedMessageFlag, n); }
	SHORT PermanentMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, PermanentMessageFlag);	}
	void PermanentMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, PermanentMessageFlag, n); }
	SHORT TriTossEchoMessage(void) {
		return GetBit(Mnnnn_Hdr.Data.BitFields, TriTossEchoMessageFlag);	}
	void TriTossEchoMessage(SHORT n) {
		ModifyBit(Mnnnn_Hdr.Data.BitFields, TriTossEchoMessageFlag, n); }
};

class FAREA_DAT {
private:
	DATAFILE <FAREADATA> Farea_Dat;
public:
	void Open(void);
	void Close(void) { Farea_Dat.Close(); }
	void Read(SHORT n) { Farea_Dat.Read(n); }
	void Write(SHORT n) {
		ZeroBits(Farea_Dat.Data.BitFields, FADLastBit,
			sizeof(Farea_Dat.Data.BitFields));
		ZeroField(Farea_Dat.Data.ReservedDataArea,
			sizeof(Farea_Dat.Data.ReservedDataArea));
		Farea_Dat.Write(n); }
	LONG Length(void) { return Farea_Dat.Length(); }
	void OpenRead(SHORT n) { Open(); Read(n); }
	void WriteClose(SHORT n) { WriteClose(n); }
	void OpenReadClose(SHORT n) { OpenRead(n); Close(); }
	void OpenWriteClose(SHORT n) { Open(); WriteClose(n); }
    void ClearIt(void) { Farea_Dat.ClearIt(); }
	char *Name(void) { return Farea_Dat.Data.Name; }
	void Name(char *s) { strcpy(Farea_Dat.Data.Name, s); }
	char *FileAreaPath(void) { return Farea_Dat.Data.FileAreaPath; }
	void FileAreaPath(char *s) { strcpy(Farea_Dat.Data.FileAreaPath, s); }
	char *FileAreaUploadPath(void) {
		return Farea_Dat.Data.FileAreaUploadPath; }
	void FileAreaUploadPath(char *s) {
		strcpy(Farea_Dat.Data.FileAreaUploadPath, s); }
	char *FileAreaFileList(void) {
		return Farea_Dat.Data.FileAreaFileList; }
	void FileAreaFileList(char *s) {
		strcpy(Farea_Dat.Data.FileAreaFileList, s); }
	char *FileAreaUploadList(void) {
		return Farea_Dat.Data.FileAreaUploadList; }
	void FileAreaUploadList(char *s) {
		strcpy(Farea_Dat.Data.FileAreaUploadList, s); }
	char *FileAreaIndexFile(void) {
		return Farea_Dat.Data.FileAreaIndexFile; }
	void FileAreaIndexFile(char *s) {
		strcpy(Farea_Dat.Data.FileAreaIndexFile, s); }
	char *AdditionalFileAreaPaths(SHORT n) {
		return Farea_Dat.Data.AdditionalFileAreaPaths[n]; }
	void AdditionalFileAreaPaths(SHORT n, char *s) {
		strcpy(Farea_Dat.Data.AdditionalFileAreaPaths[n], s); }
	SHORT SecurityLevel(void) { return Farea_Dat.Data.SecurityLevel; }
	void SecurityLevel(SHORT n) { Farea_Dat.Data.SecurityLevel = n; }
	SHORT ViewSecurityLevel(void) { return Farea_Dat.Data.ViewSecurityLevel; }
	void ViewSecurityLevel(SHORT n) { Farea_Dat.Data.ViewSecurityLevel = n; }
	SHORT SortType(void) { return Farea_Dat.Data.SortType; }
	void SortType(SHORT n) { Farea_Dat.Data.SortType = n; }
	SHORT PrivateArea(void) {
		return GetBit(Farea_Dat.Data.BitFields, PrivateAreaFlag);	}
	void PrivateArea(SHORT n) {
		ModifyBit(Farea_Dat.Data.BitFields, PrivateAreaFlag, n); }
	SHORT CDROMFileArea(void) {
		return GetBit(Farea_Dat.Data.BitFields, CDROMFileAreaFlag);	}
	void CDROMFileArea(SHORT n) {
		ModifyBit(Farea_Dat.Data.BitFields, CDROMFileAreaFlag, n); }
	SHORT AliasArea(void) {
		return GetBit(Farea_Dat.Data.BitFields, AliasAreaFlag);	}
	void AliasArea(SHORT n) {
		ModifyBit(Farea_Dat.Data.BitFields, AliasAreaFlag, n); }
};

class DOORS_TMP {
private:
	DATAFILE <DOORSTMPDATA> Doors_Tmp;
public:
	void Open(void);
	void Close(void) { Doors_Tmp.Close(); }
	void Read(void) { Doors_Tmp.Read(1); }
	void Write(void) {
		ZeroBits(Doors_Tmp.Data.BitFields, DTLastBit,
			sizeof(Doors_Tmp.Data.BitFields));
		Doors_Tmp.Write(1); }
	void OpenRead(void) { Open(); Read(); }
	void WriteClose(void) { Write(); Close(); }
	void OpenReadClose(void) { OpenRead(); Close(); }
	void OpenWriteClose(void) { Open(); WriteClose(); }
	void ClearIt(void) { Doors_Tmp.ClearIt(); }
	SHORT TimeLeftAtLogon(void) { return Doors_Tmp.Data.TimeLeftAtLogon; }
	void TimeLeftAtLogon(SHORT n) { Doors_Tmp.Data.TimeLeftAtLogon = n; }
	SHORT CurrentFileArea(void) { return Doors_Tmp.Data.CurrentFileArea; }
	void CurrentFileArea(SHORT n) { Doors_Tmp.Data.CurrentFileArea = n; }
	SHORT CurrentMessageConference(void) {
		return Doors_Tmp.Data.CurrentMessageConference; }
	void CurrentMessageConference(SHORT n) {
		Doors_Tmp.Data.CurrentMessageConference = n; }
	SHORT FrontEndTime(void) { return Doors_Tmp.Data.FrontEndTime; }
	void FrontEndTime(SHORT n) { Doors_Tmp.Data.FrontEndTime = n; }
	SHORT WhereTheDoorWasCalledFrom(void) {
		return Doors_Tmp.Data.WhereTheDoorWasCalledFrom; }
	void WhereTheDoorWasCalledFrom(SHORT n) {
		Doors_Tmp.Data.WhereTheDoorWasCalledFrom = n; }
	SHORT LanguageNumber(void) { return Doors_Tmp.Data.LanguageNumber; }
	void LanguageNumber(SHORT n) { Doors_Tmp.Data.LanguageNumber = n; }
	SHORT NumberOfFilesFlagged(void) {
		return Doors_Tmp.Data.NumberOfFilesFlagged; }
	void NumberOfFilesFlagged(SHORT n) {
		Doors_Tmp.Data.NumberOfFilesFlagged = n; }
	SHORT TimeInDOORSYS(void) { return Doors_Tmp.Data.TimeInDOORSYS; }
	void TimeInDOORSYS(SHORT n) { Doors_Tmp.Data.TimeInDOORSYS = n; }
	LONG UserRecordNumber(void) { return Doors_Tmp.Data.UserRecordNumber; }
	void UserRecordNumber(LONG n) { Doors_Tmp.Data.UserRecordNumber = n; }
	LONG BaudRate(void) { return Doors_Tmp.Data.BaudRate; }
	void BaudRate(LONG n) { Doors_Tmp.Data.BaudRate = n; }
	LONG FrontEndBaudRate(void) { return Doors_Tmp.Data.FrontEndBaudRate; }
	void FrontEndBaudRate(LONG n) { Doors_Tmp.Data.FrontEndBaudRate = n; }
	LONG TimeWhenUserLoggedOn(void) { return Doors_Tmp.Data.TimeWhenUserLoggedOn; }
	void TimeWhenUserLoggedOn(LONG n) { Doors_Tmp.Data.TimeWhenUserLoggedOn = n; }
	SHORT ANSI(void) {
		return GetBit(Doors_Tmp.Data.BitFields, ANSIFlag);	}
	void ANSI(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, ANSIFlag, n); }
	SHORT FrontEnd(void) {
		return GetBit(Doors_Tmp.Data.BitFields, FrontEndFlag);	}
	void FrontEnd(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, FrontEndFlag, n); }
	SHORT FrontEndHangUp(void) {
		return GetBit(Doors_Tmp.Data.BitFields, FrontEndHangUpFlag);	}
	void FrontEndHangUp(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, FrontEndHangUpFlag, n); }
	SHORT UserWindow(void) {
		return GetBit(Doors_Tmp.Data.BitFields, UserWindowFlag);	}
	void UserWindow(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, UserWindowFlag, n); }
	SHORT ChatRequested(void) {
		return GetBit(Doors_Tmp.Data.BitFields, ChatRequestedFlag);	}
	void ChatRequested(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, ChatRequestedFlag, n); }
	SHORT EventPending(void) {
		return GetBit(Doors_Tmp.Data.BitFields, EventPendingFlag);	}
	void EventPending(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, EventPendingFlag, n); }
	SHORT GoodbyeFromDoor(void) {
		return GetBit(Doors_Tmp.Data.BitFields, GoodbyeFromDoorFlag);	}
	void GoodbyeFromDoor(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, GoodbyeFromDoorFlag, n); }
	SHORT ForceBoardDownAfterCall(void) {
		return GetBit(Doors_Tmp.Data.BitFields,
			ForceBoardDownAfterCallFlag);	}
	void ForceBoardDownAfterCall(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields,	ForceBoardDownAfterCallFlag, n); }
	SHORT RIPscrip(void) {
		return GetBit(Doors_Tmp.Data.BitFields, RIPscripFlag);	}
	void RIPscrip(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, RIPscripFlag, n); }
	SHORT DOORSYS(void) {
		return GetBit(Doors_Tmp.Data.BitFields, DOORSYSFlag);	}
	void DOORSYS(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields, DOORSYSFlag, n); }
	SHORT ErrorCorrectingConnection(void) {
		return GetBit(Doors_Tmp.Data.BitFields,
			ErrorCorrectingConnectionFlag);	}
	void ErrorCorrectingConnection(SHORT n) {
		ModifyBit(Doors_Tmp.Data.BitFields,
			ErrorCorrectingConnectionFlag, n); }
};

class WHOSON_DAT {
private:
	DATAFILE <WHOSONDATA> Whoson_Dat;
public:
	void Open(void);
	void Close(void) { Whoson_Dat.Close(); }
	void Read(SHORT n) { Whoson_Dat.Read(n); }
	void Write(SHORT n) {
		ZeroField(Whoson_Dat.Data.ReservedDataArea,
			sizeof(Whoson_Dat.Data.ReservedDataArea));
		Whoson_Dat.Write(n); }
	LONG Length(void) { return Whoson_Dat.Length(); }
	void OpenRead(SHORT n) { Open(); Read(n); }
	void WriteClose(SHORT n) { Write(n); Close(); }
	void OpenReadClose(SHORT n) { OpenRead(n); Close(); }
	void OpenWriteClose(SHORT n) { Open(); WriteClose(n); }
	void ClearIt(void) { Whoson_Dat.ClearIt(); }
	char *Name(void) { return Whoson_Dat.Data.Name; }
	void Name(char *s) { strcpy(Whoson_Dat.Data.Name, s); }
	SHORT ChatStatus(void) { return Whoson_Dat.Data.ChatStatus; }
	void ChatStatus(SHORT n) { Whoson_Dat.Data.ChatStatus = n; }
	SHORT NodeChattingWith(void) { return Whoson_Dat.Data.NodeChattingWith; }
	void NodeChattingWith(SHORT n) { Whoson_Dat.Data.NodeChattingWith = n; }
	SHORT kbhit(SHORT n);
	SHORT getch(SHORT n);
	void putch(SHORT n, SHORT c);
	void puts(SHORT n, char *s);
};

class EVENTS_DAT {
private:
	DATAFILE <EVENTSDATA> Events_Dat;
public:
	void Open(char *s = "EVENTS.DAT");
	void Close(void) { Events_Dat.Close(); }
	void Read(SHORT n) { Events_Dat.Read(n); }
	void Write(SHORT n) {
		ZeroBits(Events_Dat.Data.BitFields, EDLastBit,
			sizeof(Events_Dat.Data.BitFields));
		ZeroField(Events_Dat.Data.ReservedDataArea,
			sizeof(Events_Dat.Data.ReservedDataArea));
		Events_Dat.Write(n); }
	void OpenRead(SHORT n, char *s = "EVENTS.DAT") { Open(s); Read(n); }
	void WriteClose(SHORT n) { Write(n); Close(); }
	void OpenReadClose(SHORT n, char *s = "EVENTS.DAT") {
		Open(s); Read(n); Close(); }
	void OpenWriteClose(SHORT n, char *s = "EVENTS.DAT") {
		Open(s); WriteClose(n); }
	LONG Length(void) { return Events_Dat.Length(); }
	void ClearIt(void) { Events_Dat.ClearIt(); }
	char *Time(void) { return Events_Dat.Data.Time; }
	void Time(char *s) { strcpy(Events_Dat.Data.Time, s); }
	char *File(void) { return Events_Dat.Data.File; }
	void File(char *s) { strcpy(Events_Dat.Data.File, s); }
	SHORT Day(void) { return Events_Dat.Data.Day; }
	void Day(SHORT n) { Events_Dat.Data.Day = n; }
	SHORT EventExecutedToday(void) {
		return GetBit(Events_Dat.Data.BitFields, EventExecutedTodayFlag); }
	void EventExecutedToday(SHORT n) {
		ModifyBit(Events_Dat.Data.BitFields, EventExecutedTodayFlag, n); }
	SHORT SlidingEvent(void) {
		return GetBit(Events_Dat.Data.BitFields, SlidingEventFlag); }
	void SlidingEvent(SHORT n) {
		ModifyBit(Events_Dat.Data.BitFields, SlidingEventFlag, n); }
};

/* function prototypes */
SHORT TBInsertRecord(char *fn, char *e1, char *e2, LONG l, LONG n, LONG tn,
	void (*callback)(LONG, LONG));
SHORT TBDeleteRecord(char *fn, char *e1, char *e2, LONG l, LONG n, LONG tn,
	void (*callback)(LONG, LONG));

#ifdef __cplusplus
extern "C" {
#endif
void TBAdjustWaitingMessages(char *s, SHORT c, SHORT a);
void TBAdjustAllWaitingMessages(SHORT c, SHORT a);
double TBBasicSingleToDouble(BASICSINGLE OldNumber);
SHORT TBCheckForShareExe(void);
void TBCopyFile(char *s, char *d);
void TBDoubleToBasicSingle(BASICSINGLE *New, double Old);
SHORT TBFileExist(char *s);
LONG TBFileLength(FILE *file);
LONG TBHashIt(char *s);
char *TBInitialCaps(char *s);
void TBInitialize(void);
char *TBMakePathName(char *buffer, char *path, char *file);
FILE *TBOpenMnnnnTxt(SHORT c, char *s = "TXT");
USHORT TBSearchIndices(char *s);
char *TBStripNewline(char *s);
char *TBStripSpaces(char *s);
ULONG TBStrCrc32(char *s);
ULONG TBStrNCrc32(char *s, USHORT l);
void TBUpdateFromAndTo(char *f, char *t, SHORT c);
SHORT TBInsertSupRecord(char *fn, char *e1, char *e2, LONG nu, LONG l,
	LONG n, LONG tn);
SHORT TBDeleteSupRecord(char *fn, char *e1, char *e2, LONG nu, LONG l,
	LONG n, LONG tn);

/* file sharing versions of the C runtime file routines */
FILE *fsopen(const char *filename, const char *mode, int shflg);
size_t fswrite(const void *ptr, size_t size, size_t n, FILE *stream);
size_t fsread(void *ptr, size_t size, size_t n, FILE *stream);
int fsgetc(FILE *stream);
int fsputc(int c, FILE *stream);
char *fsgets(char *s, int n, FILE *stream);
int fsputs(char *s, FILE *stream);
int fsprintf(FILE *stream, char *f, ...);
char *fsgetstring(char *s, int n, FILE *stream);

/* buffered text file input routines */
BFILE *bopen(char *fn);
void bclose(BFILE *bfile);
void bcloseall(void);
int bgetc(BFILE *bfile);
char *bgets(char *s, int n, BFILE *f);

#ifndef __FLAT__
extern SYSDAT1_DAT far TBSysDat1_Dat;
extern SYSDAT2_DAT far TBSysDat2_Dat;
extern NODE_DAT far TBNode_Dat;
extern USERS_DAT far TBUsers_Dat;
extern USERS_IDX far TBUsers_Idx, far TBAlias_Idx;
extern USERS_SPM far TBUsers_Spm;
extern USERS_SPF far TBUsers_Spf;
extern MCONF_DAT far TBMconf_Dat;
extern NETWORK_DAT far TBNetwork_Dat;
extern MNNNN_HDR far TBMnnnn_Hdr;
extern FAREA_DAT far TBFarea_Dat;
extern DOORS_TMP far TBDoors_Tmp;
extern WHOSON_DAT far TBWhoson_Dat;
extern EVENTS_DAT far TBEvents_Dat;
#else
extern SYSDAT1_DAT TBSysDat1_Dat;
extern SYSDAT2_DAT TBSysDat2_Dat;
extern NODE_DAT TBNode_Dat;
extern USERS_DAT TBUsers_Dat;
extern USERS_IDX TBUsers_Idx, TBAlias_Idx;
extern USERS_SPM TBUsers_Spm;
extern USERS_SPF TBUsers_Spf;
extern MCONF_DAT TBMconf_Dat;
extern NETWORK_DAT TBNetwork_Dat;
extern MNNNN_HDR TBMnnnn_Hdr;
extern FAREA_DAT TBFarea_Dat;
extern DOORS_TMP TBDoors_Tmp;
extern WHOSON_DAT TBWhoson_Dat;
extern EVENTS_DAT TBEvents_Dat;
#endif

#ifdef __cplusplus
}
#endif

#endif

