/*------------------------------------------------
   SELWORD.C -- Extension DLL for E! - version 1.1

   To compile: nmake selword.mak

   Once compiled, copy SELWORD.EWD to your USER directory.

   To use this DLL simply load it from the user menu or add its name to the
   list of autoloaded Extension DLLs by using the Autoload dialog box from
   the User Menu of EW. That's all.

   This Extension DLL uses no hook. It merely uses some API functions to
   select the word at the cursor position.

   You can assign this extension to a keystroke. See the documentation for
   a description of how to assign DLL execution to a keystroke.
  ------------------------------------------------*/

#include <windows.h>
#include "ewapi.h"

int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
			LPSTR lpszCmdLine)
{
  if (wHeapSize > 0)
    UnlockData (0) ;
  return 1 ;
}

int FAR PASCAL EWExecute(unsigned int RoutineId)
{
  long WordBoundaries;
  int  CurrentLine;

  /* Get the first and last character of the current word */
  WordBoundaries = EWGetCurWord();
  if (WordBoundaries != -1L) {
    /* Get the current line */
    CurrentLine = HIWORD(EWGetCaretPos());
    /* Select the word */
    EWBeginSelection(EWSelection_Block, (int) LOWORD(WordBoundaries), CurrentLine);
    EWUpdateSelection((int) HIWORD(WordBoundaries), CurrentLine);
    EWStopSelection((int) HIWORD(WordBoundaries), CurrentLine);
    return(0);
  }
  else
    return(ewerr_EXTFAILED);
}
