{-EW API - Useful constants and types used in Extension DLLs}

const

{-Command codes used to identify EW functions within hooks}

ew_MFOpen            =  201;
ew_MFNew             =  202;
ew_MFClone           =  203;
ew_MFGet             =  204;
ew_MFWrite           =  205;
ew_MFAppend          =  206;
ew_MFSave            =  207;
ew_MFSaveAs          =  208;
ew_MFRefresh         =  209;
ew_MFGrep            =  210;
ew_MFAssociate       =  211;
ew_MFCC              =  215;
ew_MFPrint           =  217;
ew_MFPrintSetup      =  218;
ew_MFPageSetup       =  219;
ew_MFExit            =  221;
ew_MFExitEditor      =  222;

ew_MEUndo            =  301;
ew_MEClearUndo       =  302;
ew_MECut             =  304;
ew_MECutAppend       =  305;
ew_MECopy            =  306;
ew_MECopyAppend      =  307;
ew_MEPasteIns        =  308;
ew_MEPasteOvr        =  309;
ew_MEClear           =  311;
ew_MESelectAll       =  312;
ew_MEDelete          =  314;
ew_MEDraw            =  316;
ew_MERecordMac       =  318;
ew_MELoadMac         =  319;
ew_MESaveMac         =  320;
ew_MEReplayMac       =  321;
ew_MEReplayMacN      =  322;
ew_MEAsciiMode       =  323;

ew_MBSet             =  401;
ew_MBGotoMark1       =  403;
ew_MBGotoMark2       =  404;
ew_MBGotoMark3       =  405;
ew_MBRemoveMark1     =  407;
ew_MBRemoveMark2     =  408;
ew_MBRemoveMark3     =  409;
ew_MBGoto            =  411;
ew_MBGotoSel         =  412;
ew_MBCompare         =  414;

ew_MSFind            =  501;
ew_MSRepeatFind      =  502;
ew_MSFindWord        =  503;

ew_MCCompile         =  601;
ew_MCMake            =  602;
ew_MCRebuild         =  603;
ew_MCDebug           =  604;
ew_MCExecute         =  605;
ew_MCNext            =  607;
ew_MCPrevious        =  608;
ew_MCCommands        =  610;

ew_MLSet             =  701;
ew_MLSaveCnf         =  702;
ew_MLLoadCnf         =  703;
ew_MLAssign          =  705;
ew_MLExpansion       =  707;

ew_MWRibbon          =  801;
ew_MWHide            =  803;
ew_MWTile            =  805;
ew_MWCascade         =  806;
ew_MWHideAll         =  807;
ew_MWIconizeAll      =  808;
ew_MWScrolling       =  810;
ew_MWFont            =  812;

ew_MULoadExt         =  901;
ew_MUUnloadExt       =  902;
ew_MUExecuteExt      =  903;
ew_MUAutoLoad        =  904;
ew_DefineMenu        =  906;

ew_AddTab            = 9001;
ew_BlockShift        = 9010;
ew_BeginLine         = 9011;
ew_CasePrimUpper     = 9012;
ew_CasePrimLower     = 9013;
ew_CheckBrace        = 9014;
ew_ClearLine         = 9015;
ew_DeleteCurLine     = 9016;
ew_DeleteEOL         = 9017;
ew_DeleteLeftChar    = 9018;
ew_DeleteWord        = 9019;
ew_EndLine           = 9020;
ew_Enter             = 9021;
ew_GoNextPar         = 9022;
ew_GoNextTab         = 9023;
ew_GoPrevPar         = 9024;
ew_GoPrevTab         = 9025;
ew_InputPause        = 9026;
ew_InsertBrace       = 9027;
ew_InsertDate        = 9028;
ew_InsertFilename    = 9029;
ew_InsertTime        = 9030;
ew_JoinLine          = 9031;
ew_LoadUserFile      = 9032;
ew_NextCol           = 9041;
ew_NextLine          = 9042;
ew_NextWord          = 9043;
ew_PageBottom        = 9044;
ew_PageTop           = 9045;
ew_PageScrollHLeft   = 9046;
ew_PageScrollHRight  = 9047;
ew_PageScrollVDown   = 9048;
ew_PageScrollVUp     = 9049;
ew_PrevCol           = 9050;
ew_PrevLine          = 9051;
ew_PrevWord          = 9052;
ew_Reflow            = 9054;
ew_RemoveTab         = 9055;
ew_SetCurLine2Bottom = 9056;
ew_SetCurLine2Middle = 9057;
ew_SetCurLine2Top    = 9058;
ew_ShiftTextRight    = 9059;
ew_SplitLine         = 9072;
ew_StepScrollDown    = 9073;
ew_StepScrollLeft    = 9074;
ew_StepScrollRight   = 9075;
ew_StepScrollUp      = 9076;
ew_StripFlow         = 9077;
ew_SumBlock          = 9078;
ew_TextBoundBegin    = 9079;
ew_TextBoundEnd      = 9080;
ew_TextToCursor      = 9081;
ew_ToggleIns         = 9082;
ew_UpcaseFirst       = 9083;
ew_UserBlockSort     = 9084;
ew_UserFillBlock     = 9085;

{-Value that should be returned by EWExecute or by a hook if the extension  }
{ failed. Otherwise return 0 or leave the original EW return code unchanged.}

ewerr_EXTFAILED = 300;

{-Values returned by EWCallUserExt if the extension could not be executed}

ewerr_NOSUCHEXTENSION = 301;
ewerr_NOEXECEXPORTED  = 302;

{-Values that may be returned after execution of an editing function}

ewerr_CANTMOVE         = 351;  { The cursor could not be moved as requested }
ewerr_CANTPROCEED      = 352;  { The function could not be executed }

{-Values passed by EWSetHook and EWRemoveHook to EW}

EWHook_FunctionEntry    = 0;
EWHook_FunctionExit     = 1;
EWHook_KeyboardEntry    = 2;
EWHook_PaintEntry       = 3;
EWHook_LoadExit         = 4;
EWHook_Notify           = 5;

{-Values passed by EW to the callback notification hook to identify the event}

EWNotify_ExitEditor     = 0;
EWNotify_CreateClone    = 1;
EWNotify_DestroyClone   = 2;
EWNotify_FileAutosaved  = 3;
EWNotify_FontChanged    = 4;
EWNotify_PosChanged     = 5;
EWNotify_ActWinChanged  = 6;
EWNotify_CharEntry      = 7;
EWNotify_CharExit       = 8;

{-Possible assignment modes when using EWAddMenuEntry}

EWMNU_Program   = 0;
EWMNU_Command   = 1;
EWMNU_Macro     = 2;
EWMNU_Extension = 3;

{-Global Flags constants}

  EWGlbShow              =  1;     { Show edit window when created }
  EWGlbShowWild          =  2;     { Show windows created with wildcards }
  EWGlbMinCC             =  3;     { Iconize CC after creating window }
  EWGlbReShowCC          =  4;     { Reshow CC after edit window creation }
  EWGlbDispShortCuts     =  5;     { Display shortcuts in menus }
  EWGlbReplaceSel        =  6;     { Typing replace Selection }
  EWGlbAddOnLast         =  7;     { Insert with  on last line }
  EWGlbFormatFrom        =  8;     { Format from current line only }
  EWGlbExpansion         =  9;     { Syntax Expansion enabled }
  EWGlbAutoMacros        = 10;     { Auto Macros enabled }
  EWGlbEnterClassic      = 11;     { Split line with Enter }
  EWGlbInsert            = 12;     { Insert on by default }
  EWGlbAutoScroll        = 13;     { Use autoscroll mode }
  EWGlbAlarm             = 14;     { Beep on error }
  EWGlbLog               = 15;     { Maintain session logging }
  EWGlbBak               = 16;     { Create .BAK flags }
  EWGlbWarning           = 17;     { Warning before file overwrite }
  EWGlbLoadList          = 18;     { @xxxx.xxx files are lists }
  EWGlbAutosaveOpt       = 19;     { Autosave options }
  EWGlbAutosave          = 20;     { Autosave files }
  EWGlbDeleteOut         = 21;     { Suppress .ERR file }
  EWGlbGrepRegular       = 22;     { Grep uses Boolean Search }
  EWGlbGrepAnsi          = 23;     { Grep uses Ansi charset }
  EWGlbGrepCase          = 24;     { Grep makes a case sensitive search }
  EWGlbGrepSubDir        = 25;     { Grep searches in subdirectories }
  EWGlbJump              = 26;     { Jump on Home/End }
  EWGlbHasScrollbars     = 27;     { Edit Windows have Scrollbars }
  EWGlbHasRibbon         = 28;     { Edit Windows have a Ribbon }
  EWGlbRepaint           = 29;     { Scroll method }
  EWGlbStripJoin         = 30;     { Strip Spaces when joining Lines }

{-Local Flags constants}

  EWLclbBlank       =  1;          { Strip trailing blanks }
  EWLclbAutoBack    =  2;          { Backspace behaviour }
  EWLclbAutoTab     =  4;          { Autotab flag }
  EWLclbAutoInsert  =  5;          { AutoInsert braces }
  EWLclbAutoComp    =  6;          { AutoCompress tabs }
  EWLclbWordWrap    =  7;          { Wordwrap }
  EWLclbJustify     =  8;          { Right justification }
  EWLclbLoadAscii   =  9;          { Loaded file supposed to be Ascii file }
  EWLclbSaveAscii   = 10;          { Save file in Ascii format }
  EWLclbEOF         = 11;          { Add a Ctrl Z at the end of the file }
  EWLclbAutoIndent  = 12;          { Auto Indentation }

{-Search Flags constants}

  EWSearchbBackward  =  1;         { Backward search }
  EWSearchbBlock     =  2;         { Search within marked block only }
  EWSearchbCase      =  3;         { Case sensitive search }
  EWSearchbKeepCase  =  4;         { Keep case type when replacing string }
  EWSearchbGlobal    =  5;         { Global Search }
  EWSearchbGothru    =  6;         { Replace without prompting }
  EWSearchbRegular   =  7;         { Boolean search flag }
  EWSearchbWord      =  8;         { Word-only search }
  EWSearchbAcross    =  9;         { Search across edited files }

{-Compile command codes}

  EWCompileCommand   =  0;
  EWMakeCommand      =  1;
  EWBuildCommand     =  2;
  EWDebugCommand     =  3;
  EWExecuteCommand   =  4;

{-Macro string codes}

  EWMacro_Time       =  0;
  EWMacro_Date       =  1;
  EWMacro_FileName   =  2;

{-Position codes}

  EWPosition_Top     = 0;
  EWPosition_Middle  = 1;
  EWPosition_Bottom  = 2;

{-Selection modes}

  EWSelection_None   = 0;
  EWSelection_Line   = 1;
  EWSelection_Stream = 2;
  EWSelection_Block  = 3;

{-Write modes for EWWriteBlock}

  EWWrite_ReWrite    = 1;
  EWWrite_Append     = 2;

type

  PSelStruct = ^TSelStruct;
  TSelStruct = record
    SelType       : word;
    FirstSelLine,
    LastSelLine,
    FirstSelCol,
    LastSelCol,
    StartSelIndex,
    EndSelIndex   : integer;
  end;

  TEnumEditorsProc = procedure(EditorId : longint; Name : PChar);
  TEnumClonesProc  = procedure(CloneHandle : THandle; CloneId : byte);
  TFuncEntryHook   = function(command : word) : integer;
  TFuncExitHook    = function(command : word; pRetcode : PInteger) : integer;
  TKbdEntryHook    = function(Msg : TMsg) : integer;
  TPaintEntryHook  = function(DC : HDC; PaintInfo : PPaintStruct; SelInfo : PSelStruct; hWindow : word) : integer;
  TLoadExitHook    = function(EditorId : longint) : integer;
  TNotifyHook      = function(eventcode : word; wParam : word; lParam : longint) : integer;
  TExecFunc        = function(RoutineId : word) : integer;
