{************************************************}
{                                                }
{ E! for Windows                                 }
{ (c) - Patrick Philippot - 1992,1993            }
{                                                }
{ Sample Extension DLL - version 1.1             }
{                                                }
{ This DLL translates the current text from      }
{ ANSI to OEM or from OEM to ANSI.               }
{                                                }
{************************************************}

(*
ANSIOEM is a utility intended for people who have inadvertently loaded
an ANSI file while the current font is OEM or inversely, who have loaded
an ASCII file while the current font is ANSI.

To use this DLL simply load it from the user menu or add its name to the
list of autoloaded Extension DLLs using the Autoload dialog box from
the User Menu of EW. That's all.

This Extension DLL uses no hook. Since it attaches itself to the User Menu,
you don't need to run it from the User|Execute Extension Menu. Two new
options, "Convert to OEM" and "Convert to ANSI", will automatically appear
in the User Menu.

This DLL uses the Menu Dispatching feature. It shows you how multiple
entries can be added from a single Extension DLL to the User Menu.

ANSIOEM is intended to be triggered from the User Menu or attached to a
keystroke. When executed from anywhere else, including from another
Extension DLL, the Execute function will receive a null parameter. In that
case, the function will prompt the user to know which kind of conversion
should be applied.

If you want to attach this User Extension to a keystroke, please use
Routine Id = 1 for the ANSI to OEM translation and Routine Id = 2 for the OEM
to ANSI translation (this value can be set from the key assignment dialog box).

Please see explanations about the Menu Dispatching feature in the EW API
documentation.
*)

{$I compdir.inc}
{$C MOVEABLE PRELOAD DISCARDABLE}

library Ansi2Oem;

uses WinProcs, WinTypes, EWApiImp, Strings;

const
  OemTitle : PChar = 'Convert to OEM';
  AnsiTitle : PChar = 'Convert to ANSI';
  OemId = 1;   { Routine Id for Ansi to Oem translation }
  AnsiId = 2;  { Routine Id for Oem to Ansi translation }

var
  SaveExit    : Pointer;  { Save ExitProc }
  OemEntryId,             { Entry Id for the "Convert to Oem" menu }
  AnsiEntryId : longint;  { Entry Id for the "Convert to Ansi" menu }

function Convert(bOem : boolean) : integer;

var
  index : integer;
  P     : PChar;

begin
  for index := 0 to Pred(EWGetLineCount) do begin
 {-Convert every line of text}
    P := EWGetLineAt(index);
    if bOem then
      AnsiToOem(P, P)
    else
      OemToAnsi(P, P);
  end;
  Convert := 0; {-Function always successful}
end;

function EWExecute(RoutineId : word) : integer; export;

var
  H  : hWnd;
  result,
  rc : integer;

begin
  rc := -1;
  if RoutineId = 0 then begin
  {-We don't know which type of conversion is requested}
    result := MessageBox(GetFocus, 'Convert To OEM ?', 'OEM/ANSI Conversion', mb_IconQuestion or mb_YesNoCancel);
    if (result = idYes) or (result = idNo) then
      rc := Convert(result = idYes)
    else begin
      EWWriteMessage('Translation cancelled');
      EWExecute := 0;
      Exit;
    end;
 {-Otherwise we call the relevant conversion function}
  end else
    rc := Convert(RoutineId = OemId);
  if rc  = 0 then begin
   {-The window must now be repainted}
    H := EWGetTextWindowHandle;
    InvalidateRect(H, nil, false);
    UpdateWindow(H);
    EWWriteMessage('Text converted');
    EWSetModified; {-Signal to E! that the current text has been modified}
  end else
    EWWriteMessage('Error in Execution'); {-Should not occur}
  EWExecute := rc;
end;

procedure LibExit; far;
begin
 {-Remove menu items from the User Menu before unloading}
  EWRemoveMenuEntry(OemEntryId);
  EWRemoveMenuEntry(AnsiEntryId);
  ExitProc := SaveExit;
end;

exports
  EWExecute     index 1;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
 {-Extension attaches itself to the user Menu}
 { Two commands are made available. Therefore we create two menu entries}
  OemEntryId  := EWAddMenuEntry('ansioem', OemTitle, 0, EWMNU_Extension, OemId);
  AnsiEntryId := EWAddMenuEntry('ansioem', AnsiTitle, 0, EWMNU_Extension, AnsiId);
end.
