#ifndef __GRAPHIO_H__
#define	__GRAPHIO_H__

/*
 * Return codes for import_graphic
 */
#define	GRIMP_OK	0		/* Success */
#define	GRIMP_NOMEM	1		/* Out of memory */
#define	GRIMP_NOFILE	2		/* Cannot find the specified file */
#define	GRIMP_NOTYPE	3		/* The input file had no extension */
					/*   and there was no matching file */
					/*   among the extensions listed in */
					/*   WIN.INI */
#define	GRIMP_NOFILTER	4		/* Cannot find the appropriate filter */
#define	GRIMP_NOCONV	5		/* The filter cannot import the file */
#define	GRIMP_BADPARMS	6		/* Invalid parameters */
#define	GRIMP_NOSPACE	7		/* Out of disc space */
#define	GRIMP_NOINIFILT	8		/* The filter cannot be initialized */
/*
 * Return codes for save_meta
 */
#define	GREXP_OK	0		/* Success */
#define	GREXP_BADPARMS	1		/* Invalid parameters */
#define	GREXP_NOMEM	2		/* Out of memory */
#define	GREXP_NODISC	3		/* Out of disc space */
#define	GREXP_BADFNAME	4		/* Invalid filename */

typedef struct	{
  HANDLE	hmf;			/* Handle to the metafile */
  RECT		bbox;			/* Bounding box (in metafile units) */
  short		inch;			/* How many metafile units in one */
  } PICTINFO,  FAR *LPPICTINFO;		/*   inch (can be unreliable if the */
					/*   graphic is non-scalable */
#ifdef __cplusplus
extern "C" {
#endif

int FAR PASCAL	import_graphic(HDC hdc,HWND hwnd,LPSTR fname,
			LPPICTINFO pi,int dopref,LPSTR inisection);
int FAR PASCAL	save_meta(LPPICTINFO pi,int mm,LPSTR fname,int placeable);
int FAR PASCAL	get_openmask(LPSTR buf,int bufsz,LPSTR inisection);

#ifdef __cplusplus
}
#endif

#endif
