#ifdef __TURBOC__
#pragma inline
#endif
/*  <- declarations */
/*
 * These routines will decode PCX files produced by Microsoft Windows
 * Paint. Other programs may not produce files which will be successfully
 * decoded, most notably version 1.xx of PC Paint. The initial version of
 * the PCX reading code was written by Maurice Castro and Russell Lang.
 *
 * Adapted by Hippocrates Sendoukas, Los Angeles, September 1993
 */
#include "common1.c"

typedef struct
{
  Uns8		man;
  Uns8		ver;
  Uns8		enc;
  Uns8		bitperpix;
  Uns16		xmin;
  Uns16		ymin;
  Uns16		xmax;
  Uns16		ymax;
  Uns16		hres;
  Uns16		vres;
  Uns8		pal[48];
  Uns8		reserved;
  Uns8		colorplanes;
  Uns16		byteperline;
  Uns16		paltype;
  Uns8		fill[58];
} PCXHEAD;

#define	PCXHDRSIZE	128

/*  -> declarations */
/*  <- PCXgetpalette */

static void PASCAL NEAR
PCXgetpalette(FILE *f,PCXHEAD *hdr,RGBQUAD *pal)
{
  unsigned	i,j;
  RGBQUAD	*p;
  static RGBQUAD cdef[16] =
    { { 0x00,	0x00,	0x00,	0 },		/* The field inside each */
      { 0x00,	0x00,	0x80,	0 },		/* RGBQUAD are: B-G-R */
      { 0x00,	0x80,	0x00,	0 },
      { 0x00,	0x80,	0x80,	0 },
      { 0x80,	0x00,	0x00,	0 },
      { 0x80,	0x00,	0x80,	0 },
      { 0x80,	0x80,	0x00,	0 },
      { 0x80,	0x80,	0x80,	0 },
      { 0xc0,	0xc0,	0xc0,	0 },
      { 0x00,	0x00,	0xff,	0 },
      { 0x00,	0xff,	0x00,	0 },
      { 0x00,	0xff,	0xff,	0 },
      { 0xff,	0x00,	0x00,	0 },
      { 0xff,	0x00,	0xff,	0 },
      { 0xff,	0xff,	0x00,	0 },
      { 0xff,	0xff,	0xff,	0 }  };
  static RGBQUAD mdef[2] =
    { { 0x00,	0x00,	0x00,	0 },
      { 0xff,	0xff,	0xff,	0 }  };


  memset(pal,0,256*sizeof(RGBQUAD));
  switch (hdr->ver)
    {
      case 0:		/* version 2.5 of PC Paint Brush */
      case 2:		/* version 2.8 of PC Paint Brush with valid Palette */
	for (i=j=0;  i<16;  i++)
	  {
            p = pal+i;
            p->rgbRed	= hdr->pal[j++];
            p->rgbGreen	= hdr->pal[j++];
            p->rgbBlue	= hdr->pal[j++];
          }
        break;

      case 3:	/* version 2.8 of PC Paint Brush with no valid Palette */
        if (hdr->colorplanes != 1)
          memcpy(pal,cdef,16*sizeof(RGBQUAD));
        else
          memcpy(pal,mdef,2*sizeof(RGBQUAD));
        break;

      case 5:
      default:		/* version 3.0 of PC Paint Brush or Better */
        fseek(f, -769L, SEEK_END);
        /*
         * if signature byte is correct then read the palette
         * otherwise copy the existing palette
         */
        if (readUns8(f) == 12)
          for (i=0;  i<256;  i++)
            {
              p = pal + i;
              p->rgbRed		= readUns8(f);
              p->rgbGreen	= readUns8(f);
              p->rgbBlue	= readUns8(f);
            }
        else
          for (i=j=0;  i<16;  i++)
            {
              p = pal+i;
              p->rgbRed		= hdr->pal[j++];
              p->rgbGreen	= hdr->pal[j++];
              p->rgbBlue	= hdr->pal[j++];
            }
        break;
    }
}

/*  -> PCXgetpalette */
/*  <- PCXreadhead */

static int PASCAL NEAR
PCXreadhead(FILE *f,PCXHEAD *pcxh)
{
  pcxh->man		= readUns8(f);
  pcxh->ver		= readUns8(f);
  pcxh->enc		= readUns8(f);
  pcxh->bitperpix	= readUns8(f);
  pcxh->xmin		= readUns16(f);
  pcxh->ymin		= readUns16(f);
  pcxh->xmax		= readUns16(f);
  pcxh->ymax		= readUns16(f);
  pcxh->hres		= readUns16(f);
  pcxh->vres		= readUns16(f);
  fread(pcxh->pal,1,sizeof(pcxh->pal),f);
  pcxh->reserved	= readUns8(f);
  pcxh->colorplanes	= readUns8(f);
  pcxh->byteperline	= readUns16(f);
  pcxh->paltype		= readUns16(f);
  fread(pcxh->fill,1,sizeof(pcxh->fill),f);
  return ( pcxh->man==0x0a && pcxh->enc==0x01 && pcxh->byteperline!=0 &&
           !feof(f) );
}

/*  -> PCXreadhead */
/*  <- PCXreadline */

static int PASCAL NEAR
PCXreadline(FILE *f,Uns8 *buf,unsigned nbytes)
{
  int		c;
  unsigned	i;

  while (nbytes)
    {
      c = getc(f);
      if ((c & 0xc0) != 0xc0)
        {
          *buf++ = (Uns8) c;
          nbytes--;
        }
      else
        {
          i = min( ((unsigned)(c & 0x3f)), nbytes);
          memset(buf,getc(f),i);
          buf += i;
          nbytes -= i;
        }
    }
  return !feof(f);
}

/*  -> PCXreadline */
/*  <- comb3to1 */

static void PASCAL NEAR
comb3to1(Uns8 *dest,Uns8 *r2,Uns8 *r1,Uns8 *r0,unsigned nx)
{
#ifdef __TURBOC__
	/*
	 * The assembly code assumes that all three input
	 * rows reside in the same segment.
	 */
	asm	push	ds
	asm	mov	cx,nx
	asm	les	di,dest
	asm	lds	bx,r2
	asm	mov	dx,word ptr r1
	asm	mov	ax,word ptr r0
TOP:	asm	mov	si,bx
	asm	movsb
	asm	mov	bx,si
	asm	mov	si,dx
	asm	movsb
	asm	mov	dx,si
	asm	mov	si,ax
	asm	movsb
	asm	mov	ax,si
	asm	loop	TOP
	asm	pop	ds
#else
  unsigned i,j;

  for (i=j=0; i<nx; i++)
    {
      dest[j++] = r2[i];
      dest[j++] = r1[i];
      dest[j++] = r0[i];
    }
#endif
}

/*  -> comb3to1 */
/*  <- comb4to1 */

/*
 * This conversion is quite inefficient and would benefit a lot from
 * some assembly treatment.
 */
static void PASCAL NEAR
comb4to1(Uns8 *dest,Uns8 *src[],unsigned bpl)
{
  unsigned i,j,k,v1,v2;
  static Uns8 mask1[8] = { 0x40,0x80,0x10,0x20,0x04,0x08,0x01,0x02 };
  static Uns8 mask2[4] = { 0x01,0x02,0x04,0x08 };
  static Uns8 mask3[4] = { 0x10,0x20,0x40,0x80 };

  for (i=0; i<bpl; i++)
    for (j=0; j<8; j+=2)
      {
        for (k=v1=0; k<4; k++)
          {
            v2 = src[k][i];
            if (v2 & mask1[j])		v1 |= mask2[k];
            if (v2 & mask1[j+1])	v1 |= mask3[k];
          }
        *dest++ = (Uns8) v1;
      }
}

/*  -> comb4to1 */
/*  <- get_chunk */

static int PASCAL NEAR
get_chunk(FILE *f,Uns8 *dibbits,unsigned wpl,PCXHEAD *hdr,
          unsigned nx,unsigned ny,Uns8 *pcxbits[])
{
  unsigned y,i,planes,bpl;

  planes	= hdr->colorplanes;
  bpl		= hdr->byteperline;

  dibbits += 2*wpl*(ny-1);
  for (y=0;  y<ny;  y++)
    {
      for (i=0;  i<planes;  i++)
        if (!PCXreadline(f,pcxbits[i],bpl))  return IE_BAD_FILE_DATA;
      if (planes==1)
        memcpy(dibbits,pcxbits[0],bpl);
      else if (planes==4)
        comb4to1(dibbits,pcxbits,bpl);
      else if (planes==3)
        comb3to1(dibbits,pcxbits[2],pcxbits[1],pcxbits[0],nx);
      dibbits -= 2*wpl;
    }
  return IE_OK;
}

/*  -> get_chunk */
/*  <- make_meta */

static int PASCAL NEAR
make_meta(FILE *f,PCXHEAD *hdr,unsigned nx,unsigned ny,
          BITMAPINFO *bi,HPALETTE hpal,HANDLE *hmf)
{
  HDC		hdc;
  unsigned	wpl,y1,y2,dy,maxdy,planes,retcode;
  unsigned long temp;
  Uns8		*dibbits,*pcxbits[4];

  planes = hdr->colorplanes;
  temp = (unsigned long) hdr->byteperline * (unsigned long) planes;
#if ___16_BIT___
  if (temp>=65536LU) return IE_TOO_BIG;
#endif

  temp = (unsigned long) nx * (unsigned long) bi->bmiHeader.biBitCount;
  temp += 31;
  temp /= 32;
  temp *= 2;
  wpl = (unsigned) temp;
  maxdy = 16384u/wpl;                           /* 32K chunks */
  if (maxdy==0) return IE_TOO_BIG;
  if (maxdy>1) maxdy--;
  if (maxdy>ny) maxdy = ny;
  if ( (dibbits=malloc(2*wpl*maxdy)) == NULL )  return IE_MEM_FULL;

  dy = hdr->byteperline;
  if ( (pcxbits[0]=malloc(planes * dy)) == NULL )
    {
      free(dibbits);
      return IE_MEM_FULL;
    }
  for (y1=1; y1<planes; y1++) pcxbits[y1] = pcxbits[y1-1] + dy;

  if ( (hdc=CreateMetaFile(NULL)) == 0 )
    {
      free(pcxbits[0]);
      free(dibbits);
      return IE_MEM_FULL;
    }
  SetWindowOrg(hdc,0,0);
  SetWindowExt(hdc,nx,ny);
  if (hpal)
    {
      SelectPalette(hdc,hpal,0);
      RealizePalette(hdc);
    }
  /*
   * make sure that you start at the right point in the file
   */
  fseek(f,PCXHDRSIZE,SEEK_SET);
  for (y1=0,y2=ny;  y1<y2;  )
    {
      dy = min(y2-y1,maxdy);
      bi->bmiHeader.biHeight = dy;
      bi->bmiHeader.biSizeImage = 2*wpl*dy;
      retcode = get_chunk(f,dibbits,wpl,hdr,nx,dy,pcxbits);
      if (retcode!=IE_OK) break;
      if (!StretchDIBits(hdc,0,y1,nx,dy,0,0,nx,dy,(LPSTR)dibbits,bi,
                        DIB_RGB_COLORS,SRCCOPY))
        {
          retcode = IE_MEM_FULL;
          break;
        }
      y1 += dy;
    }
  free(pcxbits[0]);
  free(dibbits);
  *hmf = CloseMetaFile(hdc);
  if (*hmf && retcode!=IE_OK)
    {
      DeleteMetaFile(*hmf);
      *hmf = 0;
    }
  return retcode;
}

/*  -> make_meta */
/*  <- pcxgraph */

static int PASCAL NEAR
pcxgraph(char *fname,HANDLE *hmf,int *nx,int *ny)
{
  unsigned		width,height,colors;
  int			retcode,n;
  HPALETTE		hpal;
  FILE			*f;
  BITMAPINFO		*bi;
  BITMAPINFOHEADER	*bih;
  PCXHEAD		hdr;

  if ( (f=fopen(fname,"r")) == NULL ) return IE_NO_FILE;
  n = 0;
  if (PCXreadhead(f,&hdr))
    {
      if	(hdr.bitperpix==1 && hdr.colorplanes==1)	n = 1;
      else if	(hdr.bitperpix==1 && hdr.colorplanes==4)	n = 4;
      else if	(hdr.bitperpix==8 && hdr.colorplanes==1)	n = 8;
      else if	(hdr.bitperpix==8 && hdr.colorplanes==3)	n = 24;
    }
  if (n==0)
    {
      fclose(f);
      return IE_BAD_FILE_DATA;
    }
  if ((bi=malloc(sizeof(BITMAPINFOHEADER)+256*sizeof(RGBQUAD)))==NULL)
    {
      fclose(f);
      return IE_MEM_FULL;
    }
  hpal = 0;
  if (n!=24)
    {
      colors = 1 << n;
      PCXgetpalette(f,&hdr,&(bi->bmiColors[0]));
      hpal = make_palette(colors,&(bi->bmiColors[0]));
    }
  width			= (hdr.xmax - hdr.xmin) + 1;
  height		= (hdr.ymax - hdr.ymin) + 1;
  bih			= &(bi->bmiHeader);
  memset(bih,0,sizeof(BITMAPINFOHEADER));
  bih->biSize		= sizeof(BITMAPINFOHEADER);
  bih->biWidth		= width;
  bih->biHeight		= height;
  bih->biPlanes		= 1;
  bih->biBitCount	= n;
  retcode = make_meta(f,&hdr,width,height,bi,hpal,hmf);
  if (hpal)	DeleteObject(hpal);
  free(bi);
  fclose(f);
  *nx = width;
  *ny = height;
  return retcode;
}

/*  -> pcxgraph */
#define read_graphic(fname,hmf,x,y)	pcxgraph(fname,hmf,x,y)
#include "common2.c"
