@echo off
rem	This is a sample batch file to run metafont, convert the GF file to
rem	the PK format and store the PK font in the appropriate directory. It
rem	is meant to be called by dviwin and that's the reason for the absence
rem	of any parameter checking. It also assumes that metafont and gftopk
rem	are operating properly. This sample file attempts to cover as many
rem	devices as possible; you will probably get better and faster results
rem	if you write a smaller and more specialized batch file.
rem
rem	The plain base is a prerequisite: make sure that you generate it by
rem	running inimf on plain.mf, then input the file modes.mf and finally
rem	dump the format file. If you don't know what I am talking about,
rem	please read the documentation that comes with the metafont program,
rem	as well as the Metafont book. You MAY need to modify this batch file
rem	if the name of your metafont program is not mf.
rem
rem	You WILL need to modify the routine to place the PK files in the
rem	proper directory; the current method uses the environment variable
rem	DVIFONTS which is assumed to contain the base directory for the PK
rem	fonts. Any square-pixel fonts are assumed to be stored in the
rem	directories  $(DVIFONTS)\X  where X is the resolution of the font.
rem	Non-square-pixel fonts are assumed to stored in the directories
rem	$(DVIFONTS)\XxY where X is the horizontal resolution and Y is the
rem	vertical resolution.
rem
rem	It is trivial to modify the name of metafont and the base directory;
rem	just select the proper values for the first two statements after
rem	these comments. If you use another directory structure, you need
rem	to modify the next two statements.
rem
rem	You may also need to do more modifications if you have other devices;
rem	this batch file generates fonts for the screen, 300dpi laser and
rem	inkjet printers, 600dpi laserjets, as well as 9-pin and 24-pin dot
rem	matrix printers. If you want to use another device, you will have to
rem	understand the code below and modify it accordingly (maybe you will
rem	want to rewrite the code in a compiled language to improve the speed,
rem	the error handling and avoid all the ugly gotos). If you want to use
rem	a 9-pin dot matrix printer at 120x144dpi or 240x144dpi, add the
rem	following lines to the file modes.mf and regenerate the plain base.
rem
rem	mode_def epsmed =			% Epson-FX at 240x144dpi
rem		mode_param (pixels_per_inch, 240);
rem		mode_param (aspect_ratio, 144 / pixels_per_inch);
rem		EpsonMXFX_;
rem	enddef;
rem
rem	mode_def epswlo =			% Epson-FX at 120x144dpi
rem		mode_param (pixels_per_inch, 120);
rem		mode_param (aspect_ratio, 144 / pixels_per_inch);
rem		EpsonMXFX_;
rem	enddef;
rem
rem	If metafont does not recognize any other modes, it will generate
rem	its standard proofing fonts which are HUGE and inappropriate for
rem	your device. In that case, get the file modes.mf from CTAN and
rem	generate the plain base again using the command:
rem		inimf plain;input modes;dump
rem	Then you need to copy plain.bas to the appropriate directory. You
rem	may need to replace "inimf" by "mf -i" for some Metafont versions.
rem
rem	Here are the parameters passed by dviwin:
rem		%1:	fontname	(truncated to 8 chars)
rem		%2:	magstep
rem		%3:	xres		(hor. resolution of font)
rem		%4:	yres	        (vert. resolution of font)
rem		%5:	xbase		(base hor. resolution)
rem		%6:	ybase		(base vert. resolution)
rem		%7:	drive		(of current dvi file)
rem		%8:	path		(of current dvi file)
rem		%9:	gf extension	(truncated to 3 chars)
rem
rem	In most cases, you will only need to modify the next four statements:

set MF=mf
set PK_BASE=%DVIFONTS%
set PK_DIR=%PK_BASE%\%3x%4
if %5==%6 set PK_DIR=%PK_BASE%\%3

rem	If the font already exists, don't do anything

if exist %PK_DIR%\%1.pk goto GETOUT

rem	If you want to switch to the directory of the current dvi file,
rem	uncomment the next two statements. This is useful if you prefer
rem	to keep some mf sources in the dvi file directory instead of the
rem	MFINPUTS directory.
rem %7:
rem cd %8

rem	Devices with non-square pixels; we support the following modes:
rem	epsdraft (9-pin 120x72dpi), epswlo (9-pin 120x144dpi), epsmed
rem	(9-pin 240x144dpi), epsonfx (9-pin 240x216dpi) and lqmedres
rem	(24-pin 360x180dpi)

if %5==%6 goto SQUARE_PIXELS
set PK_MAG=%2
set PK_DEV=
if %6==72	set PK_DEV=epsdraft
if %6==216	set PK_DEV=epsonfx
if %6==180	set PK_DEV=lqmedres
if %6==144	goto FX_LOMED
if +%PK_DEV%==+	goto UNKNOWN
goto DO_IT
:FX_LOMED
if %5==120	set PK_DEV=epswlo
if %5==240	set PK_DEV=epsmed
if +%PK_DEV%==+	goto UNKNOWN
goto DO_IT

rem	Devices with square pixels. The current code supports the resolutions
rem	used by the Beebe drivers for the screen, 300dpi and 400dpi laser
rem	and inkjet printers, 600dpi laserjets, 24-pin printers at 180x180
rem	and 360x360dpi.

:SQUARE_PIXELS
set PK_DEV=
set PK_MAG=
if %3==58	set PK_MAG=-9
if %3==64	set PK_MAG=-8.5
if %3==70	set PK_MAG=-8
if %3==76	set PK_MAG=-7.5
if %3==84	set PK_MAG=-7
if %3==92	set PK_MAG=-6.5
if %3==100	set PK_MAG=-6
if %3==110	set PK_MAG=-5.5
if %3==121	set PK_MAG=-5
if %3==132	set PK_MAG=-4.5
if %3==145	set PK_MAG=-4
if %3==158	set PK_MAG=-3.5
if %3==174	set PK_MAG=-3
if %3==190	set PK_MAG=-2.5
if %3==208	set PK_MAG=-2
if %3==228	set PK_MAG=-1.5
if %3==250	set PK_MAG=-1
if %3==274	set PK_MAG=-0.5
if %3==300	set PK_MAG=0
if %3==329	set PK_MAG=0.5
if %3==360	set PK_MAG=1
if %3==394	set PK_MAG=1.5
if %3==432	set PK_MAG=2
if %3==473	set PK_MAG=2.5
if %3==518	set PK_MAG=3
if %3==568	set PK_MAG=3.5
if %3==622	set PK_MAG=4
if %3==681	set PK_MAG=4.5
if %3==746	set PK_MAG=5
if %3==818	set PK_MAG=5.5
if %3==896	set PK_MAG=6
if %3==981	set PK_MAG=6.5
if %3==1075	set PK_MAG=7
if %3==1178	set PK_MAG=7.5
if %3==1290	set PK_MAG=8
if +%PK_MAG%==+ goto OTHER_SQ
set PK_DEV=hplaser
goto DO_IT
:OTHER_SQ
set PK_MAG=%2
if %5==180	set PK_DEV=lqlores
if %5==360	set PK_DEV=lqhires
if %5==300	set PK_DEV=hplaser
if %5==400	set PK_DEV=nexthi
if %5==600	set PK_DEV=ljiv
if +%PK_DEV%==+ goto UNKNOWN

:DO_IT
echo on
%MF% \scrollmode;mode:=%PK_DEV%;mag:=magstep(%PK_MAG%);input %1
@echo off
if errorlevel 1 goto ERROR_EXIT

rem	DOS will complain if the directories already exist. Just ignore it.
md %PK_BASE%
md %PK_DIR%

rem	This stupid trick is necessary because some versions of Metafont
rem	use an extension of NNNgf (where NNN is the hor. resolution) and
rem	truncate it to 3 chars. while other versions use just NNN which
rem	they also truncate to 3 chars.
set GF_EXT=%3
if exist %1.%9 set GF_EXT=%9

gftopk %1.%GF_EXT%  %PK_DIR%\%1.pk
del %1.%GF_EXT%
del %1.log

rem	If you want to copy the TFM file to an appropriate directory,
rem	here is the place to do it.
del %1.tfm
goto GETOUT

:UNKNOWN
echo I don't know the metafont mode for this device. Please
echo add this information to the file %0

:ERROR_EXIT

rem	The next line creates a small file in the TEMP directory. When
rem	running under NT, this signals the error to the "genallnt.bat"
rem	file, so it doesn't call dviwin again.

echo ERROR > %TEMP%\error$_$
pause

:GETOUT
