/*********************************************************************/
/*                                                                   */
/*    Name:    HANDLEST.H                                            */
/*                                                                   */
/*    Copyright (c) Stewart A. Berman 1992, All rights reserved      */
/*                                                                   */
/*********************************************************************/
#ifndef __HANDLEST_H__
#define __HANDLEST_H__

#ifdef _cplusplus
extern "C" {
#endif /* _cplusplus */

typedef int (FAR PASCAL _export * lpfnHANDLESTATUS)( UINT nStatus1, UINT nStatus2, UINT nParam1, UINT nParam2, LONG lParam1, LONG lParam2 ) ;

int  FAR PASCAL _export HandleStatus ( UINT nStatus1, UINT nStatus2, UINT nParam1, UINT nParam2, LONG lParam1, LONG lParam2 ) ;

int  FAR PASCAL SABDUTimerFunc ( HWND hWnd, UINT nMsg, UINT nIDEvent, DWORD dwTime ) ;

/********************************************************************/
/*                                                                  */
/* The following structure is used to transfer information between  */
/* this routine and one that can access areas used by the WM_PAINT  */
/* routine.  A pointer to the structure is passed via a SendMessage */
/* call.  The first LPSTR points to the message to be used when     */
/* the application is running in Iconic state.  The second LPSTR    */
/* points to the message to be used when the application is not     */
/* running in Iconic state.  The UINT field contains the percent    */
/* complete for long running tasks such as formatting a diskette.   */
/*                                                                  */
/********************************************************************/

typedef struct tagSTMESSAGE
    {
    LPSTR pIconMessage ;
    LPSTR pNormalMessage ;
    UINT  nPercentageToColor ;
    } STMESSAGE ;

/********************************************************************/
/*                                                                  */
/* The following defines should be set to avoid conflicts with      */
/* existing message IDs in your applicateion                        */
/*                                                                  */
/********************************************************************/

#define USR_ACTIVE      WM_USER+555
                        /* lParam = &stMessage */
#define USR_UPDATE      WM_USER+556
                        /* lParam = &stMessage */
#define USR_INACTIVE    WM_USER+557

/********************************************************************/
/*                                                                  */
/* The following define should be set to avoid conflicts with       */
/* existing timer IDs in your application.                          */
/*                                                                  */
/********************************************************************/

#define TIMER_INTERVAL  3

#ifdef _cplusplus
           }
#endif /* _cplusplus */

#endif /* __HANDLEST_H__ */
