/*********************************************************************/
/*                                                                   */
/*    Name:    DISKDRIV.H                                            */
/*                                                                   */
/*    Copyright (c) Stewart A. Berman 1992, All rights reserved      */
/*                                                                   */
/*********************************************************************/
#ifndef __DISKDRIV_H__
#define __DISKDRIV_H__

#include <IO.h>

#define AUTOMATIC  1
#define ALWAYS     2
#define NEVER      3
#define FAST       4

#define FORMATFAST           0x0010
#define FORMATQUICK          0x0020

#ifdef __cplusplus
extern "C" {
#else
#define _CINTERFACE
#endif /* _cplusplus */

#ifndef _CPPINTERFACE

VOID far * FAR PASCAL DiskDriveCreateDrive  ( char cDrive, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateFile   ( LPCSTR lpczFileName, LPCSTR lpczApplicationTitle, LPCSTR lpczVersion, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateMemory ( UINT nMemory, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateVDrive ( VOID far *pCVDriveNew, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID       FAR PASCAL DiskDriveDelete ( VOID far *pCDiskDrive ) ;

VOID       FAR PASCAL DiskDriveCopy ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;
BOOL       FAR PASCAL DiskDriveCompare ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;

UINT       FAR PASCAL DiskDriveForceReset     ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveHasData        ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveIsTruncated    ( VOID far *pCDiskDrive ) ;
char       FAR PASCAL DiskDriveLetter         ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveReset          ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveSetRead        ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
VOID       FAR PASCAL DiskDriveSetType        ( VOID far *pCDiskDrive, UINT nNewType ) ;
UINT       FAR PASCAL DiskDriveSetWrite       ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
UINT       FAR PASCAL DiskDriveType           ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedCylinders  ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedHeads      ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectors    ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectorSize ( VOID far *pCDiskDrive ) ;

UINT       FAR PASCAL DiskDriveFormat       ( VOID far *pCDiskDrive, LPCSTR lpczVolumeLabel, UINT nFormatOption, LPBYTE lpbyBootSector, lpfnHANDLESTATUS lpfnHandleStatus ) ;
UINT       FAR PASCAL DiskDriveFormatTrack  ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveReadSectors  ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveWriteSectors ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

LPCSTR     FAR PASCAL DiskDriveGetVolumeDate  ( VOID far *pCDiskDrive, LPSTR  lpczOldVolumeDate  ) ;
LPCSTR     FAR PASCAL DiskDriveGetVolumeLabel ( VOID far *pCDiskDrive, LPSTR  lpczOldVolumeLabel ) ;
BOOL       FAR PASCAL DiskDriveSetVolumeLabel ( VOID far *pCDiskDrive, LPCSTR lpczNewVolumeLabel ) ;

VOID       FAR PASCAL DiskDriveSetWriteFormatOption ( VOID far *pCDiskDrive, UINT nWriteFormatOptionNew ) ;
VOID       FAR PASCAL DiskDriveSetWriteVerifyOption ( VOID far *pCDiskDrive, BOOL bWriteVerifyOptionNew ) ;

VOID       FAR PASCAL DiskDriveTruncate        ( VOID far *pCDiskDrive ) ;
VOID       FAR PASCAL DiskDriveTruncateReverse ( VOID far *pCDiskDrive ) ;

BOOL       FAR PASCAL DiskDriveWriteBootSector ( VOID far *pCDiskDrive, LPBYTE lpbyModelBootSector, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

#endif /* _CINTERFACE */

#ifdef __cplusplus
           }
#endif /* __cplusplus */

#ifdef __cplusplus

#ifndef _CINTERFACE

class CDiskDrive : public CDiskLogical
{                    

DECLARE_DYNAMIC ( CDiskDrive ) ;

public:
             CPPEXPORT  CDiskDrive ( char cDrive, UINT nType=FD0000, UINT nCylinders=0, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
             CPPEXPORT  CDiskDrive ( LPCSTR lpczFileName, LPCSTR lpczApplicationTitle, LPCSTR lpczVersion, UINT nType=FD0000, UINT nCylinders=0, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
             CPPEXPORT  CDiskDrive ( UINT nMemory, UINT nType=FD0000, UINT nCylinders=0, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
             CPPEXPORT  CDiskDrive ( class CVDrive CLASSPTR *pCVDriveNew, UINT nType=FD0000, UINT nCylinders=0, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
             CPPEXPORT ~CDiskDrive () ;

CDiskDrive & CPPEXPORT operator=( class CDiskDrive CLASSPTR &other ) ;
        BOOL CPPEXPORT operator==( class CDiskDrive CLASSPTR &other ) ;

        UINT CPPEXPORT ForceReset () ;
        char CPPEXPORT Letter() ;
        UINT CPPEXPORT Reset () ;
        UINT CPPEXPORT SetRead ( UINT nTempType, UINT nCylinders=0 ) ;
        UINT CPPEXPORT SetWrite ( UINT nTempType, UINT nCylinders=0 ) ;
        VOID CPPEXPORT SetWriteFormatOption ( UINT nWriteFormatOptionNew ) ;
        VOID CPPEXPORT SetWriteVerifyOption ( BOOL nWriteVerifyOptionNew ) ;

        UINT CPPEXPORT FormatTrack  ( UINT nCylinder, UINT nHead, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
        UINT CPPEXPORT ReadSectors  ( UINT nCylinder, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;
        UINT CPPEXPORT WriteSectors ( UINT nCylinder, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;

#ifdef DEBUG
    virtual void Dump ( CDumpContext& dc ) const ;
#endif

protected:

    CVDrive CLASSPTR *pCVDrive ;

private:

        BOOL bLocalVDrive ;
        BOOL bWriteVerifyOption ;

        UINT nWriteFormatOption ;

        VOID           CommonConstructor ( class CVDrive CLASSPTR *pCVDriveNew, UINT nType=FD0000, UINT nCylinders=0, lpfnHANDLESTATUS lpfnNewHandleStatus=NULL ) ;

} ;

#endif /* _CINTERFACE */

#endif /* __cplusplus */

#endif /* __DISKDRIV_H__ */


