// TestDI.c
// ========
//
// Test the Desktop Intercept DLL
//
// Copyright (C) 1993, Paul Butcher
//
// Formatted for 4 character tabs

#define STRICT
#include <windows.h>
#include <windowsx.h>

#include "dskint.h"

// Global Variables
// ================

HINSTANCE	hInst;
HWND		hWnd;
HANDLE		hDI;

// Function Prototypes
// ===================

BOOL InitApplication(HINSTANCE hinstCurrent);
BOOL InitInstance(HINSTANCE hinstCurrent, int nCmdShow);
int PASCAL WinMain(HINSTANCE hinstCurrent, HINSTANCE hinstPrevious,
	LPSTR lpszCmdLine, int nCmdShow);
LRESULT CALLBACK MainWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

extern BOOL CALLBACK __export FilterProc(UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT FAR *lplResult);

// InitApplication
// ===============

BOOL InitApplication(HINSTANCE hinstCurrent)
{
	WNDCLASS	wc;

	// Register window class for main program
	// ======================================

	wc.style = NULL;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.hInstance = hinstCurrent;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "MainWndClass";

	if(!RegisterClass(&wc))
		return FALSE;

	return TRUE;
}

// InitInstance
// ============

BOOL InitInstance(HINSTANCE hinstCurrent, int nCmdShow)
{
	// Create our main window
	// ======================

	if(!(hWnd = CreateWindow("MainWndClass", "TestDI", WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hinstCurrent, NULL)))
		return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

// Main Program
// ============

int PASCAL WinMain(HINSTANCE hinstCurrent, HINSTANCE hinstPrevious,
	LPSTR lpszCmdLine, int nCmdShow)
{
	MSG	msg;

	hInst = hinstCurrent;           /* Save instance handle for later */

	if(hinstPrevious == NULL)
		if(!InitApplication(hinstCurrent))
			return FALSE;

	if(!InitInstance(hinstCurrent, nCmdShow))
		return FALSE;

	while(GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}

// Main Window Procedure
// =====================

LRESULT CALLBACK MainWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg) {
		case WM_CREATE:
			// Register ourselves with the Desktop Intercept DLL
			// =================================================
			DiInitialise();
			if((hDI = DiRegisterFilter((LPDIFILTER)MakeProcInstance((FARPROC)FilterProc, hInst), "TestDI")) == NULL)
				MessageBox(hwnd, "Failed in DiRegisterFilter", "TestDI", MB_OK);
			DiAcceptFiles(hDI, TRUE);
			break;

		case WM_CLOSE:
			DiAcceptFiles(hDI, FALSE);
			if(!DiUnregisterFilter(hDI))
				MessageBox(hwnd, "Failed in DiUnregisterFilter", "TestDI", MB_OK);
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(hwnd, msg, wParam, lParam);
	}
	return NULL;
}

