{$A+,B-,D-,E-,F-,I-,L-,N-,O+,R-,S-,V-}
(******************************************************************************)
(*                      Hydra Bi-directional Protocol                         *)
(*                                                   *)
(*                                                                            *)
(*                               Hydra Timers                                 *)
(*                                                                            *)
(* BY: Adam Blake                                      Wandoo Valley Software *)
(*     Arjen Lentz                                         and Lentz Software *)
(* VER: 1.00                                                      Development *)
(* DATE: 5th August 1993                                   (c) Copyright 1993 *)
(* LANGUAGE: Turbo Pascal v6.0                  All Rights Reserved Worldwide *)
(******************************************************************************)
Unit h_Timers;
Interface

type
  h_Timer = longint;

const
  h_Timer_Reset = 0;


Function h_Timer_Get : longint;

Function h_Timer_Set( Duration : word ) : longint;

Function h_Timer_Running( Timer : longint ) : boolean;

Function h_Timer_Expired( Timer : longint ) : boolean;

(******************************************************************************)
Implementation

const
  TicksInDay = 1572480;

var
  Ticker : longint absolute $0040:$006c;


Function h_Timer_Get : longint;
begin
  h_Timer_Get := Trunc(Ticker / 18.2);
end;


Function h_Timer_Set( Duration : word ) : longint;
begin
  h_Timer_Set := Trunc(Ticker / 18.2) + Duration;
end;


Function h_Timer_Running( Timer : longint ) : boolean;
begin
  h_Timer_Running := (Timer <> 0);
end;


Function h_Timer_Expired( Timer : longint ) : boolean;
begin
  h_Timer_Expired := ((Ticker / 18.2) > Timer);
  (*** IMPORTANT: Midnight tick over is not checked, to be fixed ***)
end;

(**********************************MAINLINE************************************)

end.

