//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  STANDARD INPUT/OUTPUT LIBRARY (ANSI)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#if !defined(__STDIO_H_INCLUDED)

#define NULL    _NULL

// Minimum #guaranteed# simultaneously open files
#define FOPEN_MAX       15

#define _IOFBF          0x00        /* Full Buffering               */
#define _IOLBF          0x40        /* Line buffering               */
#define _IONBF          0x04        /* No buffering                 */
#define BUFSIZ          512         /* setbuf() buffer size         */
#define EOF             (-1)        /* End Of File                  */
#define FILENAME_MAX    63          /* Max filename length          */
#define L_tmpnam        63          /* Max len of tmpnam()          */
#define SEEK_CUR        1
#define SEEK_END        2
#define SEEK_SET        0
#define TMP_MAX         0x7FFF      /* Maximum no of names for tmpnam() */

#if _POSIX1_SOURCE > 0
#define L_ctermid       5           /* 'C' 'O' 'N' ':' '\000' */
#endif

#if _SYSV_SOURCE > 0
#define _NFILE          20
#define P_tmpnam        "\\"
#define SYS_OPEN        20
#endif

#ifndef _FPOS_T_DEFINED
typedef _Fpos_t fpos_t;
#define _FPOS_T_DEFINED
#endif

#ifndef _SIZE_T_DEFINED
typedef _Size_t size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _FILE_DEFINED
class FILE {
	FILE(const FILE &);             // Prevent initialisation by another
	FILE & operator=(const FILE &); // Prevent assignment
public:

	unsigned short  OpenFlags;      // OS/2 and DOS open flags
	unsigned short  OpenMode;       // OS/2 and DOS open mode
	unsigned short  Attribute;      // OS/2 and DOS file attribute

	unsigned short  flags;          // Status flags, see below
	int             fd;             // OS file number (may be table index)
	unsigned char * buf;            // Start of buffer.
	unsigned char * bufend;         // End of allocated buffer
	unsigned char * next;           // Next char to read or write. NEVER NULL.
    unsigned char * rdend;          // End of readables. NEVER NULL.
    unsigned char * rdendsave;      // Save for above when ungetc() called
    unsigned char * wrend;          // End of writables. NEVER NULL.
    unsigned char   pushback[2];    // Pushed back characters
    unsigned char   charbuf;        // Buffer if none allocated
    unsigned char   nback;          // Number of pushed back characters
    unsigned char * tmpnam;         // Pointer to temporary name

    // For Standard Library use only :-

    // Associate with and Dissociate from O/S files and change modes
    unsigned short  _CDECL  _fmode  (const char *) ;
	unsigned short  _CDECL  _fopen  (const char *) ;
    unsigned short  _CDECL  _fdopen (int) ;
    int             _CDECL  _fclose (void) ;

    void _CDECL _MakeBuf(size_t) ;          // Free up buffer allocation

    int  _CDECL _fsetpos(fpos_t *, long, int) ;
    long _CDECL _fgetpos(fpos_t *) ;

    int _CDECL  _frprep (void) ;
    int _CDECL  _fwprep (void) ;

    FILE() ;
    ~FILE() ;
    FILE(int, unsigned short, unsigned short) ;
    FILE(int, unsigned short, unsigned short, size_t) ;
    void *  operator new (size_t) ;
    void    operator delete (void *, size_t) ;
};
#define _FILE_DEFINED
#endif

extern "C" {

void    _CDECL  clearerr    (FILE *);
int     _CDECL  fclose      (FILE *);
int     _CDECL  feof        (FILE *);
int     _CDECL  ferror      (FILE *);
int     _CDECL  fflush      (FILE *);
int     _CDECL  fgetc       (FILE *);
int     _CDECL  fgetpos     (FILE *, fpos_t *);
char *  _CDECL  fgets       (char *, int, FILE *);
FILE *  _CDECL  fopen       (const char *, const char *);
int     _CDECL  fprintf     (FILE *, const char *, ...);
int     _CDECL  fputc       (int, FILE *);
int     _CDECL  fputs       (const char *, FILE *);
int     _CDECL  fread       (void *, size_t, size_t, FILE *);
FILE *  _CDECL  freopen     (const char *, const char *, FILE *);
int     _CDECL  fscanf      (FILE *, const char *, ...);
int     _CDECL  fseek       (FILE *, long, int);
int     _CDECL  fsetpos     (FILE *, fpos_t *);
long    _CDECL  ftell       (FILE *);
size_t  _CDECL  fwrite      (const void *, size_t, size_t, FILE *);
int     _CDECL  getc        (FILE *);
int     _CDECL  getchar     (void);
char *  _CDECL  gets        (char *);
void    _CDECL  perror      (const char *);
int     _CDECL  printf      (const char *, ...);
int     _CDECL  putc        (int, FILE *);
int     _CDECL  putchar     (int);
int     _CDECL  puts        (const char *);
int     _CDECL  remove      (const char *);
int     _CDECL  rename      (const char *, const char *);
void    _CDECL  rewind      (FILE *);
int     _CDECL  scanf       (const char *, ...);
void    _CDECL  setbuf      (FILE *, char *);
int     _CDECL  setvbuf     (FILE *, char *, int, size_t);
int     _CDECL  sprintf     (char *, const char *, ...);
int     _CDECL  sscanf      (const char *, const char *, ...);
FILE *  _CDECL  tmpfile     (void);
char *  _CDECL  tmpnam      (char *);
int     _CDECL  ungetc      (int, FILE *);
int     _CDECL  vfprintf    (FILE *, const char *, char *);
int     _CDECL  vprintf     (const char *, char *);
int     _CDECL  vsprintf    (char *, const char *, char *);

#if _POSIX1_SOURCE > 0
FILE *  _CDECL  fdopen      (int, const char *);
int     _CDECL  fileno      (FILE *);
#endif

#if _POSIX2_SOURCE > 0
FILE *  _CDECL  popen       (const char *, const char *);
int     _CDECL  pclose      (FILE *);
#endif

#if _MSDOS_SOURCE > 0
int     _CDECL  fgetchar    (void);
int     _CDECL  fputchar    (int);
int     _CDECL  getw        (FILE *);
int     _CDECL  putw        (FILE *);
FILE *  _CDECL  _fsopen     (const char *, const char *, int);
int     _CDECL  _pclose     (FILE *);
int     _CDECL  _popen      (const char *, const char *);
int     _CDECL  fcloseall   (void);
int     _CDECL  flushall    (void);
int     _CDECL  rmtmp       (void);
char *  _CDECL  tempnam     (char *, char *);
#endif

extern  FILE * _CDECL _Files[];

};

#define _IOFSLOTFREE    0x0001      /* FILE object is available     */
#define _IOFMYBUF       0x0010      /* Has an internal buffer       */
#define _IOFHEAPBUF     0x0020      /* Buffer was made by malloc()  */
#define _IOFHEAPFILE    0x0040      /* FILE was made by malloc()    */
#define _IOFEOF         0x0100      /* End-Of-File                  */
#define _IOFERR         0x0200      /* Error-on-File                */
#define _IOFLBUF        0x0400      /* Line buffering               */
#define _IOFNBUF        0x0800      /* No buffering                 */
#define _IOFAPPEND      0x1000      /* Append each write            */
#define _IOFBINARY      0x2000      /* Binary mode file             */
#define _IOFREAD        0x4000      /* Read after last seek         */
#define _IOFWRITTEN     0x8000      /* Write after last seek        */

// Do NOT rely on these being lvalues
#define stdin   ((FILE *const)(_Files[0]))
#define stdout  ((FILE *const)(_Files[1]))
#define stderr  ((FILE *const)(_Files[2]))

#if _MSDOS_SOURCE > 0
#define stdaux  ((FILE *const)(_Files[3]))
#define stdprn  ((FILE *const)(_Files[4]))
#endif

// Only getc() and putc() may have side effects
#define feof(s)     ((s)->flags & _IOFEOF)
#define ferror(s)   ((s)->flags & _IOFERR)
#define getc(s)     ((s)->next < (s)->rdend ? (int)(*(s)->next++) : fgetc(s))
#define putc(c,s)   ((s)->next < (s)->wrend ? (int)(*(s)->next++ = (unsigned char)(c)) : fputc((c),(s)))
#define getchar()   fgetc(stdin)
#define putchar(c)  fputc((c),stdout)

#define fgetpos(f,p)    (int)(f->_fgetpos(p))
#define ftell(f)        f->_fgetpos(NULL)
#define fsetpos(f,p)    f->_fsetpos(p,0L,SEEK_SET)
#define fseek(f,o,w)    f->_fsetpos(NULL,o,w)

#if _POSIX1_SOURCE > 0
#define fileno(fh)  ((int)(fh)->fd)
#endif

#define __STDIO_H_INCLUDED
#endif
