/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          matrix operations        */
/*                                   */
/*          MICROSOFT C 6.00         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#define NO_MTX_ERROR 0
#define NO_MULT 1
#define NON_INVERT 2
#define NEARLY_ZERO 1e-10

extern void zerovct( double m1[MAX_MET]);

extern void addvct( double m1[MAX_MET], double m2[MAX_MET],
                    double m3[MAX_MET], int r               );

extern void addmtx( double m1[], double m2[], double m3[], int r, int c );

extern void addmtxsm( double m1[MAX_MET][MAX_MET], double m2[MAX_MET][MAX_MET],
                      double s,                    double m3[MAX_MET][MAX_MET],
                      int r, int c                                              );
extern void addvctsm( double m1[MAX_MET], double m2[MAX_MET],
                      double s,           double m3[MAX_MET],
                      int r                                   );
extern void addvctsm2( double m1[MAX_MET], double s1,
                double m2[MAX_MET], double s2,
                double m3[MAX_MET], int r       );
extern void multmtx( double m1[MAX_STEP][MAX_MET], float m2[MAX_MET][MAX_MET],
                     double m3[MAX_STEP][MAX_MET], int  r1, int c1, int r2, int c2 );
extern void multmtxvsm( double m1[MAX_MET][MAX_MET], double m2[MAX_MET],
                        double s,                    double m3[MAX_MET],
                        int r1, int c1, int r2                           );
extern void multmtxv( double m1[MAX_MET][MAX_MET], double m2[MAX_MET],
                      double m3[MAX_MET], int r1, int c1, int r2       );
extern void multmtxs( double m1[MAX_MET][MAX_MET], double s,
                      double m2[MAX_MET][MAX_MET], int r, int c );
extern int lu_inverse( double (*m1)[MAX_MET][MAX_MET], double (*m2)[MAX_MET][MAX_MET], int n );
