#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*  net metabolite rates & jacobian  */
/*                                   */
/*        Zortech C/C++ 3.0 r4       */
/*          MICROSOFT C 6.00         */
/*          Visual C/C++ 1.0         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#include "globals.h"
#include "globvar.h"
#include "datab.h"

void calcfluxes( double s[] )
{
 register int j;

 for( j=0; j<nsteps; j++ )
  flux[j] = rateq[j](s, j);
}

void calcrates( double s[] )
{
 register int i, j;

 for(i=0;i<indmet;i++)
 {
  rate[i] = (double) 0;
  for( j=0; j<nsteps; j++ )
  {
   if( stoiu[i][j] != 0 )
    rate[i] += stoiu[i][j] * rateq[j](s, j);
  }
 }
 for( i=indmet; i<nmetab; i++)
 {
  rate[i] = (double) 0;
  for( j=0; j<indmet; j++)
   rate[i] -= ld[i][j] * rate[j];
 }
}

void resetj( void )
{
 register int i,j;

 for(i=0;i<nmetab;i++)
  for(j=0;j<nmetab;j++)
   jacob[i][j] = (double) 0;
}

void calcjacob( double s[] )
{
 register int i, j, k;

 resetj( );
 for(i=0;i<indmet;i++)
  for( k=0; k<nsteps; k++)
   if ( stoiu[i][k] != 0 )
    for( j=0; j<nmetab; j++ )
     jacob[i][j] += stoiu[i][k] * partder[k][j]( s, k, j );
 for( i=indmet; i<nmetab; i++)
  for( k=0; k<nmetab; k++)
  {
   jacob[i][k] = (double) 0;
   for( j=0; j<indmet; j++)
    jacob[i][k] -= ld[i][j] * jacob[j][k];
  }
}
