#define     no_TRACE_

#include    "c:\windev\include\windows.h"
#include    "c:\windev\include\memory.h"
#include    "c:\windev\include\string.h"
#include    "ewtdebug.h"

#define     WM_ALARM WM_USER+1

//static char bfr [80];

static char vktable[]= {
	VK_LBUTTON, VK_RBUTTON, VK_CANCEL, VK_MBUTTON, VK_BACK, VK_TAB,
	VK_CLEAR, VK_RETURN, VK_SHIFT, VK_CONTROL, VK_MENU, VK_PAUSE,
	VK_CAPITAL, VK_ESCAPE, VK_SPACE, VK_PRIOR, VK_NEXT, VK_END, VK_HOME,
	VK_LEFT, VK_UP, VK_RIGHT, VK_DOWN, VK_SELECT, VK_PRINT, VK_EXECUTE,
	VK_SNAPSHOT, VK_INSERT, VK_DELETE, VK_HELP, VK_NUMPAD0, VK_NUMPAD1,
	VK_NUMPAD2, VK_NUMPAD3, VK_NUMPAD4, VK_NUMPAD5, VK_NUMPAD6, VK_NUMPAD7,
	VK_NUMPAD8, VK_NUMPAD9, VK_MULTIPLY, VK_ADD, VK_SEPARATOR, VK_SUBTRACT,
	VK_DECIMAL, VK_DIVIDE, VK_F1, VK_F2, VK_F3, VK_F4, VK_F5, VK_F6, VK_F7,
	VK_F8, VK_F9, VK_F10, VK_F11, VK_F12, VK_F13, VK_F14, VK_F15, VK_F16,
	VK_NUMLOCK,
	0x91 // SCROLL LOCK
};

BOOL     bLAT= TRUE;
BOOL 	shift= FALSE;
BOOL 	altstate= FALSE;
BOOL 	ctrlstate= FALSE;
BOOL 	keystate;
BOOL	bF3= FALSE;

extern HANDLE   hMainWnd;
extern FARPROC  prevHook;
extern int      legal_use;
int             i= 100;

extern WORD     CyrTrs(WORD, WORD, WORD);
extern WORD	CyrNewTrs (WORD, WORD, WORD);

int	switch_ctrl (WORD, LONG);
int	switch_shift (WORD, LONG);
int	switch_ctsft (WORD, LONG);

int	(*_switchfunc [3]) (WORD, LONG) =
	{
	switch_ctrl,
	switch_shift,
	switch_ctsft
	};

extern	int nSwitch;

int  FAR PASCAL CyrKeyb(nCode, wParam, lParam)
	int			nCode;
	WORD		wParam;
	LONG		lParam;
{
	int retval= (int)DefHookProc(nCode, wParam, lParam, &prevHook);
	if (nCode < 0) return retval;

	keystate= (!(HIWORD(lParam) & 0x8000));

//	if (wParam != VK_CONTROL)	waictrl= FALSE;

	if ((*_switchfunc [nSwitch]) (wParam, lParam))
		{
		bLAT ^= 1;
		PostMessage (hMainWnd, WM_TIMER, bLAT, 0L);
		MessageBeep (0);
		}

	switch (wParam) {
		case VK_CONTROL:
			ctrlstate= keystate;
		break;
		case VK_MENU:
			altstate= keystate;
		break;
		case VK_SHIFT:
			shift= keystate;
		break;
		default:
            if (strchr(vktable, (unsigned char)wParam) == NULL &&
                !bLAT && !altstate && !ctrlstate) {
                if (!legal_use) {
					i--;
                    if (!i) {
						legal_use= TRUE;
						PostMessage(hMainWnd, WM_ALARM, 0, 0L);
                    }
                }
                if (keystate) {
                    PostMessage (GetFocus (), WM_CHAR,
						CyrNewTrs (LOBYTE (HIWORD (lParam)), shift, GetKeyState (VK_CAPITAL) & 1),
			 			lParam);
					return 1;
                }
            }
		break;
	}
	return 0;
}

int	waictrl= 0;
int	waishift= 0;
unsigned char	savedcode= 0;

	//
	// switch on 'Ctrl' key pressed/released
	//
int	switch_ctrl (WORD wParam, LONG lParam)
	{
	if (wParam == VK_CONTROL)
		{
		if (keystate)
			waictrl= TRUE;
		else
			if (waictrl)
				{
				waictrl= FALSE;
				savedcode= 0;
				return 1;
				}
		}
	else
		{
		waictrl= FALSE;
		}
	return 0;
	}

	//
	// switch on Shift-Shift keys
	//
int	switch_shift (WORD wParam, LONG lParam)
	{
	if (wParam == VK_SHIFT)				// SHIFT-key
		{
		if (keystate)				// pressed
			{
			if (waishift)			// wait for next 'Shift'
				{
				if (savedcode != LOBYTE (HIWORD (lParam)))
					{
					waishift= FALSE;
					savedcode= 0;
					return 1;
					}
				else
					{
					savedcode= LOBYTE (HIWORD (lParam));
					return 0;
					}
				}
			else
				waishift= TRUE;
				savedcode= LOBYTE (HIWORD (lParam));
			}
		else
			{
			waishift= FALSE;
			}
		}
	else
		{
		waishift= FALSE;
		}
	return 0;
	}

	//
	// switch on Ctrl-Shift keys
	//
int	switch_ctsft (WORD wParam, LONG lParam)
	{
		if (ctrlstate)
			{
			if (wParam == VK_SHIFT)
				{
				if (keystate)
					{
					if (savedcode == LOBYTE (HIWORD (lParam)))
						return 0;
					savedcode= LOBYTE (HIWORD (lParam));
					if (LOBYTE (HIWORD (lParam)) == 0x2A)
						{
						bLAT= FALSE;
						}
					else
						{
						bLAT= TRUE;
						}
					savedcode= 0;
					return 1;
					}
				}
			}
		return 0;
	}
