/*
** Exception Library -- General exception handling for ANSI C programs
** 
** Copyright (C) 1992 Computational Vision and Active Perception Lab. (CVAP),
**                    Royal Institute of Technology, Stockholm.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library (see COPYING-LIB); if not, write to 
** the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
** USA.
** 
**                            Written by
**                                 
**                  Harald Winroth, Matti Rendahl
**      Computational Vision and Active Perception Laboratory
**                  Royal Institute of Technology
**                        S-100 44 Stockholm
**                              Sweden
**                                 
** Report bugs to candela-bug@bion.kth.se, and direct all inquiries to 
** candela@bion.kth.se.
**
*/

#ifndef _exception_config_h
#define _exception_config_h

/*
 * EXC_MAX_HANDLERS is the maximum number of top-level exception handlers
 * that can be installed. Usually, there is at most one handler for each
 * library linked with the application.
 */

#define EXC_MAX_HANDLERS          128

/*
 * EXC_MAX_CALLBACKS is the maximum number of callbacks that can be installed.
 * Very few packages will install callbacks if their own.
 */

#define EXC_MAX_CALLBACKS         128

/* 
 * EXC_LOCAL_TRY_DATA_SIZE is the number of words (actually void*) reserved 
 * for callback data in each TRY-block. Set EXC_LOCAL_TRY_DATA_SIZE to the
 * expected number of callbacks installed. If it is too low, you will pay a
 * small performance penelty. If it is too large, some stack space will be
 * wasted, which might be noticible for deeply nested function.
 *
 * NOTE: The value affects the macro expansions. Therefore, the exception
 * library and ALL CLIENT CODE MUST BE RE-COMPILED (not just re-linked) if
 * the value is changed.
 */

#define EXC_LOCAL_TRY_DATA_SIZE     4

/*
 * Define HAVE_TERMCAP if the termcap(3) terminal control library should
 * be used by the exc_err_*() text formatting routines (for underline, reverse
 * video etc.). If the symbol is defined, all applications using the exception
 * library must also be linked with the termcap library. Usually, the 
 * HAVE_TERMCAP symbol is defined in the makefile only (if defined at all).
 */

#if 0
#define HAVE_TERMCAP
#endif

#endif /* !_exception_config_h */
