Listing 1 - Rough outline for a hierarchy of file types

class file
	{
public:
	file(const char *name);
	int read(char *buf, size_t len);
	int write(char *buf, size_t len);
	int eof();
	// ...
private:
	char *buffer;
	char *next;
	// ...
	};

class random_file : public file
	{
public:
	random_file(const char *name, const char *mode);
	int read(char *buf, size_t len);
	int write(char *buf, size_t len);
	int eof();
	typedef ... pos_t;
	int seek(pos_t pos);
	pos_t tell();
	// ...
private:
	pos_t curpos;
	// ...
	};

class disk_file : public random_file
	{
public:
	disk_file(const char *name, const char *mode);
	int read(char *buf, size_t len);
	int write(char *buf, size_t len);
	int seek(pos_t pos);
	pos_t tell();
	// ...
private:
	// ...
	};

class tape_file : public random_file
	{
	tape_file(const char *name, const char *mode);
	int read(char *buf, size_t len);
	int write(char *buf, size_t len);
	int seek(pos_t pos);
	pos_t tell();
	// ...
private:
	// ...
	};

class sequential_file : public file
	{
public:
	sequential_file(const char *name);
	// ...
	};

class parallel_port : public sequential_file
	{
public:
	parallel_port(const char *name);
	// ...
	};

class serial_port : public sequential_file
	{
public:
	serial_port(const char *name);
	// ...
	};
