@CSOURCE7 = /* File: LOG.H */<R>
#define DEF_FUNC_NAME(s)      static char _FUNCTION_NAME[] = s;<R>
#define FUNC_NAME()           (_FUNCTION_NAME)<R>
<R>
#define DEF_MODULE_NAME(s)    static char _MODULE_NAME[] = s;<R>
#define MODULE_NAME()         (_MODULE_NAME)<R>
<R>
extern int writelog(char *format, ...);<R>
/* [Other function prototypes go here, but they're not important] 
*/<R>
/* EOF (LOG.H) */<R>
<R>
All other modules #include the LOG.H header file.  Here's how the 
macros<R>
and functions defined in LOG.H are used:<R>
<R>
/* File: STRUTILS.C */<R>
#include <<<<stdio.h>>>><R>
#include <<<<string.h>>>><R>
#include "log.h"<R>
<R>
DEF_MODULE_NAME(__FILE__)<R>
<R>
char *double2comma(double f, int places)<R>
{<R>
    DEF_FUNC_NAME("double2comma")<R>
    static char tmp[40];  /* Return value */<R>
    char *s;<R>
    int i=0;<R>
<R>
    if ((places <<<< 0) || (places >>>> 38)) {<R>
#ifndef NDEBUG<R>
         writelog("%s.%s(): param 'places' (%d) is invalid.\n",<R>
              MODULE_NAME(), FUNC_NAME(),<R>
              places<R>
         );<R>
#endif<R>
         return (tmp);<R>
    }<R>
<R>
    sprintf(tmp, "%#.*f", places, f);<R>
<R>
    if ((s = strchr(tmp, '.')) == NULL) {<R>
#ifndef NDEBUG<R>
         writelog("%s.%s(): strchr() returned NULL when seeking '.'\<R>
in '%s'.\n",<R>
              MODULE_NAME(), FUNC_NAME(),<R>
              tmp<R>
         );<R>
#endif<R>
    } else {<R>
         if (!places) {<R>
              /* Get rid of trailing '.': */<R>
              *s = '\0';<R>
         }<R>
<R>
         while (--s >>>> tmp) {<R>
              if (i++ == 2) {<R>
                   /* Are we just to the right of '-'? */<R>
                   if (s[-1] == '-') break;

@CSOURCE7 =                    /* Insert a comma: */<R>
                   i = 0;<R>
                   /* Shift segment right to make room for ',': */<R>
                   memmove(s+1, s, strlen(s)+1);<R>
                   *s = ',';<R>
              }<R>
         }<R>
    }<R>
    return (tmp);<R>
}<R>
<R>
/* [More functions for this module go here] */<R>
/* EOF */

