Listing 2 (debug.cpp)
=====================

MyDebugStream::MyDebugStream(

// default output specifier
	BOOL UseMessageBox,

// possible title for MessageBox
	char* pTitle )

// pass arguments to MyDebugStreambuf constructor
	: m_buf( UseMessageBox, pTitle ),

// pass MyDebugStreambuf to ostream constructor
	  ostream( (streambuf*) &m_buf )
{
	ASSERT( this );
}

MyDebugStreambuf::MyDebugStreambuf(
	BOOL UseMessageBox,
	char* pTitle )

	: strstreambuf()
{
	ASSERT( this );
// store the default output flag
	m_UseMessageBox = UseMessageBox;
	
// store pointer to the MessageBox title
	m_pTitle = pTitle;
	
// store the buffer size
	m_BufferSize = DEBUG_BUFFER_SIZE;
	
// get one extra for NULL terminator
	m_pBuffer = new char[m_BufferSize + 1];
	
// paranoia check
	ASSERT( m_pBuffer );
	
// init put pointers
	setp( m_pBuffer, m_pBuffer + m_BufferSize );
}

int MyDebugStreambuf::overflow( int ch )
{
	ASSERT( this );
	if( out_waiting() )
// data in buffer
		Flush();
	return strstreambuf::overflow( ch );
}

int MyDebugStreambuf::sync()
{
	ASSERT( this );
	if( out_waiting() )
// data in buffer
		Flush();
	return strstreambuf::sync();
}

void MyDebugStreambuf::Flush()
{
	ASSERT( this );
// get default
	BOOL UseMessageBox = m_UseMessageBox;

// get pointer to last character
	char* p = pptr() - 1;
	if( *p == (char) FLUSH_TO_BOX )
	{
// set output flag
		UseMessageBox = TRUE;

// discard FLUSH_TO_BOX
		*p = '\0';
	}
	else if( *p == (char) FLUSH_TO_DEBUG )
	{
// set output flag
		UseMessageBox = FALSE;
		
// discard FLUSH_TO_DEBUG
		*p = '\0';
	}
	else
// NULL terminate
		*pptr() = '\0';

// do the output
	if( UseMessageBox )
		MessageBox( NULL, m_pBuffer, m_pTitle,
			    MB_OK|MB_ICONINFORMATION );
	else
		::OutputDebugString( m_pBuffer );

// reset buffer pointers
	setp( m_pBuffer, m_pBuffer + m_BufferSize );
}

ostream& BoxFlush( ostream& os )
{
	return os << (char) FLUSH_TO_BOX << flush;
}

ostream& DebugFlush( ostream& os )
{
	return os << "\r\n"
		  << (char) FLUSH_TO_DEBUG << flush;
}
