LISTING 1 - String Class Definition and Inline Functions
#if !defined(STRING_HPP)
#define STRING_HPP

#include <stddef.h>
#include <assert.h>

class istream;
class ostream;

const size_t NPOS = (size_t) -1;    // "SIZE_T_MAX"

class string
{
public:
    // Constructors / Destructor
    string();
    string(const string& s);
    string(const char *s, size_t n = NPOS);
    ~string();

    // Assignment
    string& operator=(const string& s);

    // Concatenation
    string& operator+=(const string& s);
    friend string operator+(const string& s1, const string& s2);

    // Predicates
    friend int operator==(const string&, const string&);
    friend int operator!=(const string&, const string&);

    // Subscripting
    char get_at(size_t pos) const;
    void put_at(size_t pos, char c);
    string substr(size_t pos, size_t n = NPOS) const;

    // Searching
    size_t find(const string& s, size_t pos = 0) const;
    size_t find_first_of(const string& s, size_t pos = 0) const;
    size_t find_first_not_of(const string& s, size_t pos = 0)
      const;

    // I/O
    friend ostream& operator<<(ostream&, const string&);
    friend istream& operator>>(istream& is, string&);

    // Miscellaneous
    size_t length() const;
    const char *c_str() const;

private:
    char *data;
    size_t count;   // Doesn't include terminating 0

    void clone(const char *s, size_t n);
};

inline string::string()
{
    *(data = new char[1]) = '\0';
    count = 0;
}

inline string::string(const string& s)
{
    clone(s.data,s.count);
}

inline string::~string()
{
    delete [] data;
}

inline string operator+(const string& s1, const string& s2)
{
    string s(s1);
    return s += s2;
}

inline char string::get_at(size_t pos) const
{
    assert(pos < count);
    return data[pos];
}

inline size_t string::length() const
{
    return count;
}

inline const char * string::c_str() const
{
    return data;
}

#endif
